<?php
/**
 *
 * Testimonial Shortcode
 *
 */


class Edumodo_Shortcode_Testimonial {


    /**
     *
     * Shortcode Name
     * @var string
     */

    private $name = 'edumodo-testimonial';

    /**
     * Instance of class
     */
    private static $instance;

    /**
     * Initialization
     */
    public static function init() {
        if ( null === self::$instance ) {
            self::$instance = new self;
        }

        return self::$instance;
    }


    private function __construct() {

        add_shortcode( $this->name, array( $this, 'create_testimonial_shortcode' ) );
    }


    /**
     * Shortcode Function
     *
     * @param $atts
     * @return string
     */

    public function create_testimonial_shortcode( $atts ) {

        ob_start();
        global $post;

        $option = array(
            'item' => 3,
            'order' => 'DESC',
            'orderby' => 'date',
            'post_cat' => 'edumodo_testimonial'
        );

        $s = shortcode_atts( $option, $atts );

        $args = array(
            'post_type' => $s['post_cat'],
            'order' => $s['order'],
            'orderby' => $s['orderby'],
            'posts_per_page' => $s['item'],
        );

        $q = new WP_Query( $args );

        if ( $q->have_posts() ): ?>

            <div id="edumodo-testimonial" class="ateam carousel slide at-accordion edumodo-testimonial" data-ride="carousel">
                <i class="glyph-icon flaticon-left-quote"></i>
                <!-- Wrapper for slides -->
                <div class="carousel-inner">

            <?php $counter=1; while( $q->have_posts() ): $q->the_post();
            
                $prefix = '_edumodo_';
                $edumodo_testimoni_name = get_post_meta( get_the_ID(), $prefix . 'testimoni_name', true );
                $edumodo_testimoni_designation = get_post_meta( get_the_ID(), $prefix . 'testimoni_designation', true );
                $edumodo_testimoni_details = get_post_meta( get_the_ID(), $prefix . 'testimoni_details', true );

            ?>

                    <div class="item <?php echo $counter++ === 1 ? 'active': ''?>">
                        <div class="inner-wrapper">

                            <div class="inner-body">
                                <h4><?php echo $edumodo_testimoni_name; ?></h4>
                                <h5><?php echo $edumodo_testimoni_designation; ?></h5>
                                <p class="at-desc"><?php echo $edumodo_testimoni_details; ?></p>
                            </div>
                            <div class="inner-image">

                                <?php
                                if( has_post_thumbnail() ){
                                    $feat_image_url = wp_get_attachment_url( get_post_thumbnail_id() ); ?>

                                    <img src="<?php echo esc_url($feat_image_url ); ?>" alt="<?php the_title(); ?>" class="square img-responsive">

                                <?php } ?>
                            </div>
                        </div>
                    </div>

            <?php endwhile; wp_reset_postdata(); ?>

                </div>
                <ol class="carousel-indicators">

            <?php
            $data_num = 0;
            $counter=1;
            while( $q->have_posts() ): $q->the_post(); ?>

                    <li data-target="#edumodo-testimonial" data-slide-to="<?php echo $data_num; ?>" class="<?php echo $counter++ === 1 ? 'active': ''?>"></li>
                <?php $data_num++; endwhile; wp_reset_postdata(); ?>

                </ol>
                <i class="glyph-icon flaticon-right-quote"></i>
            </div>



        <?php else: ?>

            <p> <?php esc_html_e( 'Sorry no testimonial found.', 'edumodo' ); ?> </p>

        <?php    endif;

        $output = ob_get_clean();

        return $output;

    }



}