<?php
/**
 *
 * Related Post Shortcode
 *
 */


class Edumodo_Shortcode_Recent_Post{


    /**
     *
     * Shortcode Name
     * @var string
     */

    private $name = 'edumodo-recent-post';


    /**
     * Instance of class
     */
    private static $instance;

    /**
     * Initialization
     */
    public static function init() {
        if ( null === self::$instance ) {
            self::$instance = new self;
        }

        return self::$instance;
    }


    private function __construct() {

        add_shortcode( $this->name, array( $this, 'create_recent_post_shortcode' ) );
    }




    /**
     * Shortcode Function
     *
     * @param $atts
     * @return string
     */

    public function create_recent_post_shortcode( $atts ) {

        ob_start();

        $prefix = '_edumodo_';;

            $option = array(
                'item' => 3,
                'order' => 'DESC',
                'orderby' => 'date',
                'post_type' => 'post',
                'column' => '12',
            );

            $s = shortcode_atts( $option, $atts );

            // arguments
            $args = array(
            'post_type' => $s['post_type'],
            'post_status' => 'publish',
            'order' => $s['order'],
            'orderby' => $s['orderby'],
            'posts_per_page' => $s['item'],
            'post__not_in' => get_option( 'sticky_posts' ),
            );

            $related_items = new WP_Query( $args );

            // loop over query
            if ($related_items->have_posts()) : ?>

                <div class="edumodo-recent-post">

                <?php  
                    while ( $related_items->have_posts() ) : $related_items->the_post();?>
                          <?php if ( has_post_thumbnail() ):?>
                            <article id="post-<?php the_ID(); ?>" <?php post_class('recent-post'); ?>>

                                 <div class="recent-img">
                               
                                        <figure class="recent-post-thumbnail">
                                            <a href="<?php the_permalink(); ?>">
                                                <?php  the_post_thumbnail('thumbnail');?>
                                            </a>
                                        </figure>
                               
                                </div>
                                <div class="recent-post-details">
                     
                                    <?php if (get_post_type()) : ?>

                                        <header class="recent-entry-header">
                                            <h4 class="recent-entry-title">
                                                <a href="<?php the_permalink();?>">
                                                    <?php esc_html_e(wp_trim_words( get_the_title(),7, ''), 'edumodo'); ?>                                     
                                                </a>
                                            </h4>       
                                        </header><!-- .entry-header -->
                            
                                        <div class="recent-entry-meta">
                                            <span class="post-date">
                                                <?php 
                                                    $archive_year  = get_the_time('Y'); 
                                                    $archive_month = get_the_time('m'); 
                                                    $archive_day   = get_the_time('d'); 
                                                ?>
                                                <a href="<?php echo get_day_link( $archive_year, $archive_month, $archive_day); ?>"><?php echo get_the_date(); ?></a>
                                            </span>  
                                        </div><!-- .entry-meta -->

                                    <?php endif; ?>
                                
                                    <?php  
                                    $post_formats = array('audio', 'image', 'video', 'link', 'gallery'); 
                                    if (!in_array(get_post_format(), $post_formats)):?>
                                        <div class="recent-entry-content">
                                            <p><?php esc_html_e(wp_trim_words( get_the_content(),7, ''), 'edumodo'); ?></p>
                                        </div><!-- .entry-content -->
                                    <?php endif; ?>

                                </div>   
                            </article>
            
                    <?php endif; ?>
                <?php endwhile; wp_reset_postdata(); ?>

            </div>

        <?php else: ?>

            <p> <?php esc_html_e( 'Sorry no post found.', 'edumodo' ); ?> </p>

        <?php    endif;

        $output = ob_get_clean();

        return $output;

    }



}