<?php
/**
 *
 * Related Post Shortcode
 *
 */


class Edumodo_Shortcode_Related_Posts {


    /**
     *
     * Shortcode Name
     * @var string
     */

    private $name = 'edumodo-related-course';


    /**
     * Instance of class
     */
    private static $instance;

    /**
     * Initialization
     */
    public static function init() {
        if ( null === self::$instance ) {
            self::$instance = new self;
        }

        return self::$instance;
    }


    private function __construct() {

        add_shortcode( $this->name, array( $this, 'create_related_post_shortcode' ) );
    }


    /**
     * Shortcode Function
     *
     * @param $atts
     * @return string
     */

    public function create_related_post_shortcode( $atts ) {

        ob_start();

        $prefix = '_edumodo_';;
        $course_cost = get_post_meta( get_the_ID(), $prefix . 'course_cost', true );

            $option = array(
                'heading' => 'Related Course',
                'item' => 3,
                'post_type' => 'tx-course',
                'column' => '12',
            );

            $s = shortcode_atts( $option, $atts );

            $custom_taxterms = wp_get_object_terms( get_the_ID(), 'tx-course-category', array('fields' => 'ids') );
            // arguments
            $args = array(
            'post_status' => 'publish',
            'post_type' => $s['post_type'],
            'post_status' => 'publish',
            'posts_per_page' => $s['item'],
            'orderby' => 'rand',
            'tax_query' => array(
                array(
                    'taxonomy' => 'tx-course-category',
                    'field' => 'id',
                    'terms' => $custom_taxterms
                )
            ),

            'post__not_in' => array ( get_the_ID()),
            );

            $related_items = new WP_Query( $args );

            // loop over query
            if ($related_items->have_posts()) : ?>
            <div class="enter-related-course"> 
                <div class="enter-sub-title">
                    <h2>
                        <?php esc_html_e( $s['heading'], 'edumodo' ); ?>                                   
                    </h2>       
                </div>
            <div class="row">
                <div class="course-carousel">

                <?php  
                    while ( $related_items->have_posts() ) : $related_items->the_post();?>

                    <div class="edumodo-related-course-1">
                        
                        <div class="col-md-4">
                            <article id="post-<?php the_ID(); ?>" <?php post_class('custom-post'); ?>>

                                <?php if ( has_post_thumbnail() ):?>
                                    <figure class="post-thumbnail">
                                        <a href="<?php the_permalink(); ?>">
                                            <?php  the_post_thumbnail();?>
                                        </a>
                                    </figure>
                                <?php endif; ?>

                                <div class="course-details">
                     
                                    <?php if ( 'tx-course' === get_post_type() ) : ?>

                                        <header class="entry-header">
                                            <h4 class="course-entry-title">
                                                <a href="<?php the_permalink();?>">
                                                    <?php esc_html_e(wp_trim_words( get_the_title(),7, ''), 'edumodo'); ?>                                     
                                                </a>
                                            </h4>       
                                        </header><!-- .entry-header -->
                                        
                                        <div class="course-meta">

                                            <span class="course-view">
                                                <i class="glyph-icon flaticon-binoculars"></i></i><?php echo getPostViews(get_the_ID()); ?>
                                            </span>
                                            
                                            <span class="course-cost">
                                               <?php echo $course_cost; ?>
                                            </span>

                                        </div>
                                    <?php endif; ?>

                                        <div class="entry-content">
                                            <p> <?php esc_html_e(wp_trim_words( get_the_content(),6, ''), 'edumodo'); ?></p>
                                        </div>
                                </div>
                            </article>
                        </div>
                    </div>

                <?php endwhile; wp_reset_postdata(); ?>

            </div>
        </div>
        <?php else: ?>

           

        <?php    endif; ?>
    </div>
      <?php  $output = ob_get_clean();

        return $output;

    }


}