<?php

/**
 *
 * Course Shortcode
 *
 */
class Edumodo_Shortcode_Follow_Us {


    /**
     *
     * Shortcode Name
     * @var string
     */

    private $name = 'edumodo-follow-us';


    /**
     * Instance of class.
     * @var null|Edumodo_CPT_Course
     */
    private static $instance;

    /**
     * Initialization
     *
     * @return Edumodo_CPT_Course
     */
    public static function init() {
        if ( null === self::$instance ) {
            self::$instance = new self;
        }

        return self::$instance;
    }

    private function __construct() {
        add_shortcode( $this->name, array( $this, 'create_edumodo_follow_us' ));

    }

    /**
     * Shortcode Function
     *
     * @param $atts
     * @return string
     */

    function create_edumodo_follow_us($atts){
        remove_filter( 'the_title', 'wptexturize' );
        $tx_title = urlencode(html_entity_decode(get_the_title()));
        add_filter( 'the_title', 'wptexturize' );
        remove_filter( 'the_excerpt', 'wptexturize' );
        $tx_excerpt = urlencode(html_entity_decode(get_the_excerpt()));
        add_filter( 'the_excerpt', 'wptexturize' );
        $tx_url = urlencode( get_permalink() );
        // Construct sharing URL without using any script
        $twitter_url = 'https://twitter.com/intent/tweet?text='.$tx_title.'&amp;url='.$tx_url;
        $facebook_url = 'https://www.facebook.com/sharer/sharer.php?u='.$tx_url;
        $linked_url = 'https://www.linkedin.com/shareArticle?mini=true&url='.$tx_url.'&title='.$tx_title.'&summary='.$tx_excerpt;

        ob_start();
        $prefix = '_edumodo_';

        $default = array(
            'id' => '',
            
        );

        $option = shortcode_atts($default, $atts);

        ?>
              
                    <div class="edumodo-social">
                        <a href="<?php echo esc_url($facebook_url); ?>"><i class="glyph-icon flaticon-facebook-logo"></i></a>
                        <a href="<?php echo esc_url($twitter_url); ?>"><i class="glyph-icon flaticon-twitter"></i> </a>
                        <a href="<?php echo esc_url($linked_url); ?>"><i class="glyph-icon flaticon-linkedin-logo"></i> </a>
                    </div>


        <?php

        $output = ob_get_clean();
        return $output;

    }

}
