<?php

/**
 *
 * Course Shortcode
 *
 */
class Edumodo_Shortcode_Course_Enroll {


    /**
     *
     * Shortcode Name
     * @var string
     */

    private $name = 'edumodo-course-enroll';


    /**
     * Instance of class.
     * @var null|Edumodo_CPT_Course
     */
    private static $instance;

    /**
     * Initialization
     *
     * @return Edumodo_CPT_Course
     */
    public static function init() {
        if ( null === self::$instance ) {
            self::$instance = new self;
        }

        return self::$instance;
    }

    private function __construct() {
        add_shortcode( $this->name, array( $this, 'create_edumodo_course_enroll' ));

    }

    /**
     * Shortcode Function
     *
     * @param $atts
     * @return string
     */

    function create_edumodo_course_enroll($atts){

        ob_start();
        $prefix = '_edumodo_';
        $start_date = get_post_meta( get_the_ID(), $prefix . 'course_start_date', true );
        $end_date = get_post_meta( get_the_ID(), $prefix . 'course_end_date', true );
        $total_hours = get_post_meta( get_the_ID(), $prefix . 'course_hours', true );
        $total_student = get_post_meta( get_the_ID(), $prefix . 'course_students', true );
        $course_time = get_post_meta( get_the_ID(), $prefix . 'course_time', true );
        $course_Levels = get_post_meta( get_the_ID(), $prefix . 'course_levels', true );
        $course_cost = get_post_meta( get_the_ID(), $prefix . 'course_cost', true );

        $default = array(
            'id' => '',
            'btn-text' => 'Enroll This Course',
            
        );

        $option = shortcode_atts($default, $atts);

        ?>
              
               <div class="enroll-btn">
                  <a href="#"><button type="button" class="btn"><?php esc_html_e( $option['btn-text'], 'edumodo' ); ?></button></a>
                </div>

        <?php

        $output = ob_get_clean();
        return $output;

    }

}
