<?php
/**
 *
 * Related Post Shortcode
 *
 */


class Edumodo_Shortcode_Course_Teacher {


    /**
     *
     * Shortcode Name
     * @var string
     */

    private $name = 'edumodo-course-teacher';


    /**
     * Instance of class
     */
    private static $instance;

    /**
     * Initialization
     */
    public static function init() {
        if ( null === self::$instance ) {
            self::$instance = new self;
        }

        return self::$instance;
    }


    private function __construct() {

        add_shortcode( $this->name, array( $this, 'create_course_teacher_shortcode' ) );
    }




    /**
     * Shortcode Function
     *
     * @param $atts
     * @return string
     */

    public function create_course_teacher_shortcode( $atts ) {

        ob_start();

            $prefix = '_edumodo_';;
            $course_teacher = get_post_meta( get_the_ID(), $prefix . 'select_course_teacher', true );

            $option = array(
                'heading' => 'Course Teacher',
                'item' => 10,
            );

            $s = shortcode_atts( $option, $atts );

            // arguments
            $args = array(
            'post_type' => 'teacher',
            'posts_per_page' => 'item',
            );

            $related_items = new WP_Query( $args );

            // loop over query
            if ($related_items->have_posts() && !empty($course_teacher)) : ?>

                <div class="course-teacher-carousel">

                <?php foreach($course_teacher as $teacher_meta): 

                $teacher_img_links = get_post_meta($teacher_meta, $prefix . 'teacher_img', true );
                $designation = get_post_meta( $teacher_meta, $prefix . 'teacher_designation', true );
                $email = get_post_meta( $teacher_meta, $prefix . 'teacher_email', true );
                $phone = get_post_meta( $teacher_meta, $prefix . 'teacher_phone', true );
                $website = get_post_meta( $teacher_meta, $prefix . 'teacher_website', true );
                $teacher_facebook = get_post_meta( $teacher_meta, $prefix . 'teacher_facebook_link', true );
                $teacher_twitter = get_post_meta( $teacher_meta, $prefix . 'teacher_twitter_link', true );
                $teacher_linkedin = get_post_meta( $teacher_meta, $prefix . 'teacher_linkedin_link', true );

                ?>

                  <div class="courser-teacher">
                     <div class="teacher-person">

                        <?php if ($teacher_img_links) : ?>
                            <div class="person-img">
                                <img class="img-circle" src="<?php echo $teacher_img_links; ?>" alt="<?php echo get_the_title($teacher_meta); ?>">
                            </div>
                        <?php endif; ?>
                        
                          <div class="person-info">
                            <h4 class="teacher-title">
                               <a href="<?php the_permalink(); ?>">
                                  <?php  echo get_the_title($teacher_meta); ?>
                               </a>
                            </h4>

                          <?php if ($designation) : ?>
                                <p class="teacher-position"><?php echo $designation; ?></p>
                          <?php endif; ?>

                          <?php if ($teacher_meta) : ?>
                          <p><?php echo get_the_excerpt( $teacher_meta ); ?> </p>
                          <?php endif; ?>

                            <div class="social-links-teacher">
                              <?php if ($teacher_facebook) : ?>
                                      <a class="teacher-facebook" href="<?php echo $teacher_facebook; ?>"><i class="glyph-icon flaticon-facebook-logo"></i></a>
                              <?php endif; ?>

                              <?php if ($teacher_twitter) : ?>
                                      <a class="teacher-teitter" href="<?php echo $teacher_twitter; ?>"><i class="glyph-icon flaticon-twitter"></i> </a>
                              <?php endif; ?>

                              <?php if ($teacher_linkedin) : ?>
                                       <a class="teacher-linkedin" href="<?php echo $teacher_linkedin; ?>"><i class="glyph-icon flaticon-linkedin-logo"></i> </a>
                              <?php endif; ?>
                            </div>
                          </div>
                     </div>
                  </div> <!-- /.section -->

                <?php endforeach; wp_reset_postdata(); ?>

            </div>

        <?php else: ?>

            <p> <?php esc_html_e( 'Sorry no teacher found.', 'edumodo' ); ?> </p>

        <?php endif;

        $output = ob_get_clean();

        return $output;

    }



}