<?php

/**
 *
 * CPT "Testimonial"
 *
 */
class Edumodo_CPT_Testimonial {

    /**
     * Custom Post Type slug.
     * @var string
     */
    private $post_type = 'edumodo_testimonial';

    /**
     * Instance of class.
     * @var null|Edumodo_CPT_Testimonial
     */
    private static $instance;

    /**
     * Initialization
     *
     * @return Edumodo_CPT_Testimonial
     */
    public static function init() {
        if ( null === self::$instance ) {
            self::$instance = new self;
        }

        return self::$instance;
    }

    private function __construct() {
        add_action( 'init', array( $this, 'register_post_type' ), 0 );
    }

    public function register_post_type() {
        $labels = array(
            'name'                  => _x( 'Testimonials', 'Post Type General Name', 'edumodo' ),
            'singular_name'         => _x( 'Testimonial', 'Post Type Singular Name', 'edumodo' ),
            'menu_name'             => __( 'Testimonial', 'edumodo' ),
            'name_admin_bar'        => __( 'Testimonial', 'edumodo' ),
            'archives'              => __( 'Testimonial Archives', 'edumodo' ),
            'parent_item_colon'     => __( 'Parent Testimonial:', 'edumodo' ),
            'all_items'             => __( 'All Testimonials', 'edumodo' ),
            'add_new_item'          => __( 'Add New Testimonial', 'edumodo' ),
            'add_new'               => __( 'Add New', 'edumodo' ),
            'new_item'              => __( 'New Testimonial', 'edumodo' ),
            'edit_item'             => __( 'Edit Testimonial', 'edumodo' ),
            'update_item'           => __( 'Update Testimonial', 'edumodo' ),
            'view_item'             => __( 'View Testimonial', 'edumodo' ),
            'search_items'          => __( 'Search Testimonial', 'edumodo' ),
            'not_found'             => __( 'Not found', 'edumodo' ),
            'not_found_in_trash'    => __( 'Not found in Trash', 'edumodo' ),
            'featured_image'        => __( 'Client\'s Image', 'edumodo' ),
            'set_featured_image'    => __( 'Set client\'s image', 'edumodo' ),
            'remove_featured_image' => __( 'Remove client\'s image', 'edumodo' ),
            'use_featured_image'    => __( 'Use as client\'s image', 'edumodo' ),
            'insert_into_item'      => __( 'Insert into testimonial', 'edumodo' ),
            'uploaded_to_this_item' => __( 'Uploaded to this item', 'edumodo' ),
            'items_list'            => __( 'Testimonials list', 'edumodo' ),
            'items_list_navigation' => __( 'Testimonials list navigation', 'edumodo' ),
            'filter_items_list'     => __( 'Filter teachers list', 'edumodo' ),
        );
        $args = array(
            'label'                 => __( 'Testimonial', 'edumodo' ),
            'description'           => __( 'Add and manage client\'s testimonial.', 'edumodo' ),
            'labels'                => $labels,
            'supports'              => array( 'title', 'thumbnail' ),
            'taxonomies'            => array( ),
            'hierarchical'          => false,
            'public'                => true,
            'show_ui'               => true,
            'show_in_menu'          => true,
            'menu_position'         => 30,
            'menu_icon'             => 'dashicons-format-quote',
            'show_in_admin_bar'     => true,
            'show_in_nav_menus'     => true,
            'can_export'            => true,
            'has_archive'           => true,
            'exclude_from_search'   => false,
            'publicly_queryable'    => true,
            'capability_type'       => 'page',
            'rewrite'               => array( 'slug' => 'testimonial' ),
        );

        register_post_type( $this->post_type, $args );
    }
}
