<?php

/**
 *
 * CPT "Teacher"
 *
 */
class Edumodo_CPT_Teacher {

    /**
     * Custom Post Type slug.
     * @var string
     */
    private $post_type = 'teacher';

    /**
     * Instance of class.
     * @var null|Edumodo_CPT_Teacher
     */
    private static $instance;

    /**
     * Initialization
     *
     * @return Edumodo_CPT_Teacher
     */
    public static function init() {
        if ( null === self::$instance ) {
            self::$instance = new self;
        }

        return self::$instance;
    }

    private function __construct() {
        add_action( 'init', array( $this, 'register_post_type' ), 0 );

    }

    public function register_post_type() {
        $labels = array(
            'name'                  => _x( 'Teachers', 'Post Type General Name', 'edumodo' ),
            'singular_name'         => _x( 'Teacher', 'Post Type Singular Name', 'edumodo' ),
            'menu_name'             => __( 'Teacher', 'edumodo' ),
            'name_admin_bar'        => __( 'Teacher', 'edumodo' ),
            'archives'              => __( 'Teacher Archives', 'edumodo' ),
            'parent_item_colon'     => __( 'Parent Teacher:', 'edumodo' ),
            'all_items'             => __( 'All Teacher', 'edumodo' ),
            'add_new_item'          => __( 'Add New Teacher', 'edumodo' ),
            'add_new'               => __( 'Add New', 'edumodo' ),
            'new_item'              => __( 'New Teacher', 'edumodo' ),
            'edit_item'             => __( 'Edit Teacher', 'edumodo' ),
            'update_item'           => __( 'Update Teacher', 'edumodo' ),
            'view_item'             => __( 'View Teacher', 'edumodo' ),
            'search_items'          => __( 'Search Teacher', 'edumodo' ),
            'not_found'             => __( 'Not found', 'edumodo' ),
            'not_found_in_trash'    => __( 'Not found in Trash', 'edumodo' ),
            'featured_image'        => __( 'Featured Image', 'edumodo' ),
            'set_featured_image'    => __( 'Set featured image', 'edumodo' ),
            'remove_featured_image' => __( 'Remove featured image', 'edumodo' ),
            'use_featured_image'    => __( 'Use as featured image', 'edumodo' ),
            'insert_into_item'      => __( 'Insert into teacher', 'edumodo' ),
            'uploaded_to_this_item' => __( 'Uploaded to this teacher', 'edumodo' ),
            'items_list'            => __( 'Teacher list', 'edumodo' ),
            'items_list_navigation' => __( 'Teacher list navigation', 'edumodo' ),
            'filter_items_list'     => __( 'Filter teacher list', 'edumodo' ),
        );
        $args = array(
            'label'                 => __( 'Teacher', 'edumodo' ),
            'description'           => __( 'Add and manage teacher information', 'edumodo' ),
            'labels'                => $labels,
            'supports'              => array( 'title', 'editor','revisions', 'excerpt' ),
            'taxonomies'            => array( ),
            'hierarchical'          => false,
            'public'                => true,
            'show_ui'               => true,
            'show_in_menu'          => true,
            'menu_position'         => 25,
            'menu_icon'             => 'dashicons-welcome-learn-more',
            'show_in_admin_bar'     => true,
            'show_in_nav_menus'     => true,
            'can_export'            => true,
            'has_archive'           => true,
            'exclude_from_search'   => false,
            'publicly_queryable'    => true,
            'capability_type'       => 'page',
            'rewrite'               => array( 'slug' => 'teacher' ),
        );

        register_post_type( $this->post_type, $args );
    }


}
