<?php

/**
 *
 * CPT "Notice"
 *
 */
class Edumodo_CPT_Notice {

    /**
     * Custom Post Type slug.
     * @var string
     */
    private $post_type = 'notice';

    /**
     * Custom taxonomy - category - for post type
     * @var string
     */
    private $taxonomy = 'notice_category';

    /**
     * Instance of class.
     * @var null|Edumodo_CPT_Notice
     */
    private static $instance;

    /**
     * Initialization
     *
     * @return Edumodo_CPT_Notice
     */
    public static function init() {
        if ( null === self::$instance ) {
            self::$instance = new self;
        }

        return self::$instance;
    }

    private function __construct() {
        add_action( 'init', array( $this, 'register_post_type' ), 0 );
        add_action( 'init', array( $this, 'register_taxonomy' ), 0 );

    }

    public function register_post_type() {
        $labels = array(
            'name'                  => _x( 'Notice', 'Post Type General Name', 'edumodo' ),
            'singular_name'         => _x( 'Notice', 'Post Type Singular Name', 'edumodo' ),
            'menu_name'             => __( 'Notice', 'edumodo' ),
            'name_admin_bar'        => __( 'Notice', 'edumodo' ),
            'archives'              => __( 'Notice Archives', 'edumodo' ),
            'parent_item_colon'     => __( 'Parent Notice:', 'edumodo' ),
            'all_items'             => __( 'All Notice', 'edumodo' ),
            'add_new_item'          => __( 'Add New Notice', 'edumodo' ),
            'add_new'               => __( 'Add New', 'edumodo' ),
            'new_item'              => __( 'New Notice', 'edumodo' ),
            'edit_item'             => __( 'Edit Notice', 'edumodo' ),
            'update_item'           => __( 'Update Notice', 'edumodo' ),
            'view_item'             => __( 'View Notice', 'edumodo' ),
            'search_items'          => __( 'Search Notice', 'edumodo' ),
            'not_found'             => __( 'Not found', 'edumodo' ),
            'not_found_in_trash'    => __( 'Not found in Trash', 'edumodo' ),
            'featured_image'        => __( 'Featured Image', 'edumodo' ),
            'set_featured_image'    => __( 'Set featured image', 'edumodo' ),
            'remove_featured_image' => __( 'Remove featured image', 'edumodo' ),
            'use_featured_image'    => __( 'Use as featured image', 'edumodo' ),
            'insert_into_item'      => __( 'Insert into notice', 'edumodo' ),
            'uploaded_to_this_item' => __( 'Uploaded to this notice', 'edumodo' ),
            'items_list'            => __( 'Notice list', 'edumodo' ),
            'items_list_navigation' => __( 'Notice list navigation', 'edumodo' ),
            'filter_items_list'     => __( 'Filter notice list', 'edumodo' ),
        );
        $args = array(
            'label'                 => __( 'Notice', 'edumodo' ),
            'description'           => __( 'Add and manage notice information', 'edumodo' ),
            'labels'                => $labels,
            'supports'              => array( 'title', 'editor', 'thumbnail', 'excerpt' ),
            'taxonomies'            => array( ),
            'hierarchical'          => false,
            'public'                => true,
            'show_ui'               => true,
            'show_in_menu'          => true,
            'menu_position'         => 25,
            'menu_icon'             => 'dashicons-welcome-learn-more',
            'show_in_admin_bar'     => true,
            'show_in_nav_menus'     => true,
            'can_export'            => true,
            'has_archive'           => true,
            'exclude_from_search'   => false,
            'publicly_queryable'    => true,
            'capability_type'       => 'page',
            'rewrite'               => array( 'slug' => 'notice' ),
        );

        register_post_type( $this->post_type, $args );
    }

    /**
     *
     * Register Taxonomy
     *
     */

    public function register_taxonomy() {
        $labels = array(
            'name'                       => _x( 'Categories', 'Taxonomy General Name', 'edumodo' ),
            'singular_name'              => _x( 'Category', 'Taxonomy Singular Name', 'edumodo' ),
            'menu_name'                  => __( 'Categories', 'edumodo' ),
            'all_items'                  => __( 'All Items', 'edumodo' ),
            'parent_item'                => __( 'Parent Item', 'edumodo' ),
            'parent_item_colon'          => __( 'Parent Item:', 'edumodo' ),
            'new_item_name'              => __( 'New Item Name', 'edumodo' ),
            'add_new_item'               => __( 'Add New', 'edumodo' ),
            'edit_item'                  => __( 'Edit', 'edumodo' ),
            'update_item'                => __( 'Update', 'edumodo' ),
            'separate_items_with_commas' => __( 'Separate with commas', 'edumodo' ),
            'search_items'               => __( 'Search', 'edumodo' ),
            'add_or_remove_items'        => __( 'Add or remove items', 'edumodo' ),
            'choose_from_most_used'      => __( 'Choose from the most used items', 'edumodo' ),
            'not_found'                  => __( 'Not Found', 'edumodo' )
        );
        $args = array(
            'labels'                     => $labels,
            'hierarchical'               => true,
            'public'                     => true,
            'show_ui'                    => true,
            'show_admin_column'          => true,
            'show_in_nav_menus'          => true,
            'show_tagcloud'              => true,
            'rewrite'                    => array( 'slug' => 'notice-category' ),
        );

        register_taxonomy( $this->taxonomy, $this->post_type, $args );
    }


}
