<?php

/**
 * Metabox for blog post format
 * @
 */

function edumodo_post_metabox(){

    // Start with an underscore to hide fields from custom fields list
    $prefix = '_edumodo_';

    $post_format = new_cmb2_box(array(
        'id'           => $prefix . 'post_metabox',
        'title'        => __('Post Format Fields', 'edumodo'),
        'object_types' => array('post'), // Post type.
    ));

    $post_format->add_field(array(
        'name'       => __('Upload Image', 'edumodo'),
        'desc'       => __('Upload your image ', 'edumodo'),
        'id'         => $prefix . 'image_format',
        'type'       => 'file',
        'attributes' => array(
            'required'               => false, // Will be required only if visible.
            'data-conditional-id'    => 'post_format',
            'data-conditional-value' => 'image',
        ),
    )
    );

    $post_format->add_field(array(
        'name'       => __('Upload Video', 'edumodo'),
        'desc'       => __('Upload your video ', 'edumodo'),
        'id'         => $prefix . 'video_format',
        'type'       => 'oembed',
        'attributes' => array(
            'required'               => false, // Will be required only if visible.
            'data-conditional-id'    => 'post_format',
            'data-conditional-value' => 'video',
        ),
    )
    );

    $post_format->add_field(array(
        'name'       => __('Upload Audio', 'edumodo'),
        'desc'       => __('Upload your audio ', 'edumodo'),
        'id'         => $prefix . 'audio_format',
        'type'       => 'oembed',
        'attributes' => array(
            'required'               => false, // Will be required only if visible.
            'data-conditional-id'    => 'post_format',
            'data-conditional-value' => 'audio',
        ),
    )
    );

    $post_format->add_field(array(
        'name'       => __('Upload Gallery', 'edumodo'),
        'desc'       => __('Upload your gallery ', 'edumodo'),
        'id'         => $prefix . 'gallery_format',
        'type'       => 'file_list',
        'attributes' => array(
            'required'               => false, // Will be required only if visible.
            'data-conditional-id'    => 'post_format',
            'data-conditional-value' => 'gallery',
        ),
    )
    );

    $post_format->add_field(array(
        'name'       => __('Write Link', 'edumodo'),
        'desc'       => __('Write your link', 'edumodo'),
        'id'         => $prefix . 'link_format',
        'type'       => 'text_medium',
        'attributes' => array(
            'required'               => false, // Will be required only if visible.
            'data-conditional-id'    => 'post_format',
            'data-conditional-value' => 'link',
        ),
    )
    );

    $post_format->add_field(array(
        'name'       => __('Write Quote', 'edumodo'),
        'desc'       => __('Write your quote', 'edumodo'),
        'id'         => $prefix . 'quote_format',
        'type'       => 'text_medium',
        'attributes' => array(
            'required'               => false, // Will be required only if visible.
            'data-conditional-id'    => 'post_format',
            'data-conditional-value' => 'quote',
        ),
    )
    );

}

add_action('cmb2_admin_init', 'edumodo_post_metabox');
