<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Scheme_Color;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Class EEdumodo_Woo_Product_Categorie_Config
 */
class Edumodo_Woo_Product_Categorie_Config extends Widget_Base {

	public function get_name() {
		return 'edumodo-woo-product-categorie';
	}

	public function get_title() {
		return __( 'Woo Product Categorie', 'edumodo' );
	}

	public function get_icon() {
		return 'eicon-cart-medium';
	}

	public function get_categories() {
		return [ 'edumodo' ];
	}


	protected function _register_controls() {

        $this->start_controls_section(
            'section_title',
            [
                'label' => __( 'Content', 'edumodo' ),
            ]
        );
 
        $categories = get_terms( 'product_cat' );

        $options = [];
        foreach ( $categories as $category ) {
            $options[ $category->term_id ] = $category->name;
        }
        $this->add_control(
            'shop_layout',
            [
                'label'     => esc_html__( 'Shop Layout', 'edumodo' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'layout_1',
                'options'   => [
                    'layout_1'   => esc_html__( 'Layout 1', 'edumodo' ),
                    'layout_2'   => esc_html__( 'Layout 2', 'edumodo' ),
                ],

            ]
        );

        $this->add_control(
            'categories',
            [
                'label' => __( 'Categories', 'edumood' ),
                'type' => Controls_Manager::SELECT2,
                'options' => $options,
                'default' => [],
                'label_block' => true,
                'multiple' => true,
            ]
        );
        $this->add_control(
            'posts_column',
            [
                'label' => __('Column', 'edumodo'),
                'type' => Controls_Manager::SELECT,
                'default' => '4',
                'options' => [
                    '2' => __('6 Column', 'edumodo'),
                    '3' => __('4 Column', 'edumodo'),
                    '4' => __('3 Column', 'edumodo'),
                    '6' => __('2 Column', 'edumodo'),
                    '12' => __('1 Column', 'edumodo'),
                ],
            ]
        ); 

        $this->add_control(
            'posts_per_page',
            [
                'label' => __('Item to Show', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 3,
                'min' => 2,
                'max' => 20,
                'step' => 1,
            ]
        );

        $this->add_control(
            'orderby',
            [
                'label' => __( 'Order by', 'edumodo' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'date' => __( 'Date', 'edumodo' ),
                    'title' => __( 'Title', 'edumodo' ),
                    'price' => __( 'Price', 'edumodo' ),
                    'popularity' => __( 'Popularity', 'edumodo' ),
                    'rating' => __( 'Rating', 'edumodo' ),
                    'rand' => __( 'Random', 'edumodo' ),
                    'menu_order' => __( 'Menu Order', 'edumodo' ),
                ],
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => __( 'Order', 'edumodo' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'desc',
                'options' => [
                    'asc' => __( 'ASC', 'edumodo' ),
                    'desc' => __( 'DESC', 'edumodo' ),
                ],
                'condition' => [
                    'query_post_type!' => 'current_query',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_fixed_height',
            [
                'label' => __( 'Image Height', 'edumodo' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 150,
                        'max' => 600,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-shop-wrapper.kindergarten figure.post-thumbnail.fixed-height-img img' => 'max-height: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'border_radius',
            [
                'label' => __( 'Border Radius', 'edumodo' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-shop-wrapper.kindergarten .edumodo-shop-product' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .edumodo-shop-wrapper.kindergarten .edumodo-shop-product',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [   'label' => __( 'Box Shadow Hover', 'edumodo' ),
                'name' => 'box_shadow_hover',
                'selector' => '{{WRAPPER}} .edumodo-shop-wrapper.kindergarten .edumodo-shop-product:hover',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_title_options',
            [
                'label' => __( 'Title', 'edumodo' ),
            ]
        );

        $this->add_control(
            'title_word',
            [
                'label' => __('Title Word', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 4,
                'min' => 1,
                'max' => 20,
                'step' => 1,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => __( 'Title Color', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .e-woo-latest-product  a.edumodo-title' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'shop_layout' => 'layout_1',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .e-woo-latest-product .product .product-short-info .e-product-title',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_price_options',
            [
                'label' => __( 'Price', 'edumodo' ),
            ]
        );

        $this->add_control(
            'price_color',
            [
                'label'     => __( 'Price Color', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .edumodo-shop-wrapper.kindergarten span.price' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'price_typography',
                'selector' => '{{WRAPPER}} .edumodo-shop-wrapper.kindergarten span.price',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'author_section_style',
            [
                'label' => __( 'Author', 'edumodo' ),
                'condition' => [
                    'shop_layout' => 'layout_1',
                ],
            ]
        );

        $this->add_control(
            'author_color',
            [
                'label'     => __( 'Author Color', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .e-woo-latest-product .e-product-author' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_button',
            [
                'label' => __( 'Button', 'edumodo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'scheme' => Scheme_Typography::TYPOGRAPHY_4,
                'selector' => '{{WRAPPER}} .e-woo-latest-product .product .e-product-price .e-product-price-wrapper a, .e-woo-latest-product span.woocommerce-Price-amount.amount',
            ]
        );


        $this->start_controls_tabs( 'tabs_button_style' );

        $this->start_controls_tab(
            'tab_button_normal',
            [
                'label' => __( 'Normal', 'edumodo' ),
            ]
        );

        $this->add_control(
            'button_text_color',
            [
                'label' => __( 'Text Color', 'edumodo' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .e-woo-latest-product .product .e-product-price .e-product-price-wrapper a' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .e-woo-latest-product .woocommerce-Price-amount.amount' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'background_color',
            [
                'label' => __( 'Background Color', 'edumodo' ),
                'type' => Controls_Manager::COLOR,
                'scheme' => [
                    'type' => Scheme_Color::get_type(),
                    'value' => Scheme_Color::COLOR_4,
                ],
                'selectors' => [
                    '{{WRAPPER}} .e-woo-latest-product .product .e-product-price .e-product-price-wrapper' => 'background-color: {{VALUE}};',
                ],
            ]
        );



        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_button_hover',
            [
                'label' => __( 'Hover', 'edumodo' ),
            ]
        );

        $this->add_control(
            'hover_color',
            [
                'label' => __( 'Text Color', 'edumodo' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .e-product-price-wrapper:hover p' => 'color: {{VALUE}};',
 
                ],
            ]
        );

        $this->add_control(
            'button_background_hover_color',
            [
                'label' => __( 'Background Color', 'edumodo' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .e-woo-latest-product .product .e-product-price .e-product-price-wrapper:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_hover_border_color',
            [
                'label' => __( 'Border Color', 'edumodo' ),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-blog .blog-article-one .post-content-body .blog-btn a:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );


        $this->end_controls_tab();

        $this->end_controls_tabs();
        $this->end_controls_section();
    }


	protected function render() {
        require EDUMODO_CORE_ROOT . '/elements/woo-product-categorie/template/view.php';
	}
}
