<?php 
		$settings = $this->get_settings();
        $posts_column = $settings['posts_column'];
        $posts_per_page = $settings['posts_per_page'];
        $title_word = $settings['title_word'];
        $product_orderby = $settings['orderby'];
        $product_order = $settings['order'];

        $args = array(
            'post_type' => 'product',
            'stock' => 1,
            'posts_per_page' => $posts_per_page,
            'orderby' => $product_orderby,
            'order' => $product_order,
        );

        $query = new WP_Query($args);
        if($query->have_posts()):
            ?>
            <div class="row">
                <div class="e-woo-latest-product">
                    <ul class="product">
                    <?php
                    while($query->have_posts()):

                        $query->the_post();

                        ?>
                        <li class="product-item col-md-<?php echo $posts_column ;?> col-sm-6">
                            <?php
                            $product_author = get_post_meta(get_the_ID(), '_edumodo_product_author');
                            ?>
                            <div class="e.product-item-wrapper">
                                <figure>
                                    <div class="product-image">
                                        <a href="<?php the_permalink(); ?>" >
                                            <div class="atvImg e-atvImg">
                                            <?php if(has_post_thumbnail()): ?>
                                                <?php the_post_thumbnail('full'); ?>
                                            <?php endif; ?>
                                            <div class="atvImg-layer" data-img="<?php echo get_the_post_thumbnail_url(get_the_ID()); ?>"></div>
                                            <div class="atvImg-layer" data-img="<?php echo get_the_post_thumbnail_url(get_the_ID()); ?>"></div>
                                            </div>
                                        </a>

                                    </div>
                                </figure>

                                <div class="product-short-info">

                                    <a class="edumodo-title e-product-title" href="<?php the_permalink();?>">
                                        <?php the_title(); ?>
                                    </a>
                                    <?php if(! empty($product_author[0])): ?>
                                    <p class="e-product-author">
                                        <span><?php esc_html_e('By ', 'edumodo'); ?></span>
                                        <span><?php echo $product_author[0]; ?></span>
                                    </p>
                                    <?php endif; ?>
                                    <div class="e-product-price">
                                        <div class="e-product-price-wrapper">
                                            <?php echo do_shortcode('[add_to_cart id="'. get_the_ID() .'"]'); ?>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </li>

                        <?php
                    endwhile;
                    ?>
                    </ul>
                </div>
            </div>
            <?php
            wp_reset_postdata();
        endif;
