<?php
    $settings = $this->get_settings();

    // Global Options
    global $post;
     // Prefix
    $prefix = '_edumodo_';
    
    $course_cat_enable = $settings['course_cat_enable'];
    $course_view_enable = $settings['course_view_enable'];
    $excerpt_title_word = $settings['excerpt_title_word'];
    $excerpt_desc_word = $settings['excerpt_desc_word'];
    $meta_position = $settings['meta_position_vertical'];

?>
        <div class="edumodo-default-course">
            <div class="row">
                <?php 
                   $args = array(
                        'post_type'      => 'tx-course',
                        'posts_per_page'    => $settings['posts_per_page'],
                        'meta_key'       => '_edumodo_course_start_date',
                        'orderby'        => $settings['orderby'],
                        'order'          => $settings['order'],
                    );

                    $tx_courses = new WP_Query( $args );
                        if($tx_courses->have_posts()):
                            while($tx_courses->have_posts()): 
                                $tx_courses->the_post(); 

                    $course_start_date = get_post_meta($post->ID, $prefix . 'course_start_date', true); 
                    // var_dump(get_post_meta($post->ID));
                ?>

                <div class="col-md-<?php echo $settings['posts_column']; ?> col-sm-6 col-xs-12">
                    <article id="post-<?php the_ID(); ?>" class="tx-course">
                        <?php if ( has_post_thumbnail() ):?>
                            <figure class="post-thumbnail">
                                <a href="<?php the_permalink(); ?>">
                                    <?php  the_post_thumbnail('archive_image_size');?>
                                </a>
                            </figure>
                        <?php endif; ?>

                        <div class="course-details">
                            <?php if ($meta_position == 'top'): ?>
                                <div class="course-meta">
                                    <?php if($course_cat_enable == 'yes'): ?>
                                        <span class="post-date">
                                            <i class="glyph-icon flaticon-calendar-with-spring-binder-and-date-blocks"></i> 
                                            <?php echo $course_start_date; ?>
                                        </span>
                                    <?php endif ?>
                                    <?php if($course_view_enable == 'yes'): ?>
                                        <span class="post-view">
                                            <i class="glyph-icon flaticon-binoculars"></i> 
                                            <?php echo getPostViews(get_the_ID()); ?>
                                        </span>
                                    <?php endif ?>
                                </div><!-- .entry-meta -->
                            <?php endif; ?>
                            <header class="entry-header">
                                <h4 class="course-entry-title">
                                    <a href="<?php the_permalink();?>">
                                        <?php esc_html_e(wp_trim_words( get_the_title(), $excerpt_title_word, ''), 'edumodo'); ?>                                   
                                    </a>
                                </h4>       
                            </header><!-- .entry-header -->

                            <?php if ($meta_position == 'bottom'): ?>
                                <div class="course-meta">
                                    <?php if($course_cat_enable == 'yes'): ?>
                                        <span class="post-date">
                                            <i class="glyph-icon flaticon-calendar-with-spring-binder-and-date-blocks"></i> 
                                            <?php echo $course_start_date; ?>
                                        </span>
                                    <?php endif ?>
                                    <?php if($course_view_enable == 'yes'): ?>
                                        <span class="post-view">
                                            <i class="glyph-icon fa fa-eye"></i> 
                                            <?php echo getPostViews(get_the_ID()); ?>
                                        </span>
                                    <?php endif ?>
                                </div><!-- .entry-meta -->
                            <?php endif; ?>

                            <?php if ($tx_courses):?>
                                <div class="entry-content">
                                    <p><?php esc_html_e(wp_trim_words( get_the_content(), $excerpt_desc_word, ''), 'edumodo'); ?></p>
                                </div><!-- .entry-content -->
                            <?php endif; ?>
                        </div><!-- .course details -->
                    </article><!-- #post-## -->
                </div> <!-- /.col-md-4 -->

            <?php endwhile; wp_reset_postdata(); endif; ?>
        </div>  
    </div> 

    
