<?php

use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor edumodo Testimonial
 *
 * Elementor widget for edumodo Testimonial
 *
 * @since 1.0.0
 */
class edumodo_testimonial_1 extends Widget_Base {

	public function get_name() {
		return 'edumodo-testimonial-1';
	}

	public function get_title() {
		return __( 'Dynamic Testimonial', 'edumodo' );
	}

	public function get_icon() {
		return 'eicon-testimonial';
	}

	public function get_categories() {
		return [ 'edumodo' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
	public function get_script_depends() {
		return [ 'edumodo-testimonial-1' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'section_testimonial',
			[
				'label' => __( 'Query', 'edumodo' ),
			]
		);

		$this->add_control(
			'testimonial_items',
			[
				'label'     => __( 'Items to Show', 'edumodo' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => '3',
				'options'   => [
					'1'   => __( '1', 'edumodo' ),
					'2'   => __( '2', 'edumodo' ),
					'3'   => __( '3', 'edumodo' ),
				],
			]
		);

		$this->end_controls_section();


			$this->start_controls_section(
	            'section_controls',
	            [
	                'label' => esc_html__( 'Controls', 'edumodo' ),
	            ]
	        );

	      //   	$this->add_control(
		     //        'content_height',
		     //            [
		     //                'label' => __( 'Height', 'edumodo' ),
		     //                'type'  => Controls_Manager::HEADING,
		     //                'separator' => 'before',
		     //            ]
		     //    );

		    	// $this->add_responsive_control(
		     //        'fixed_height',
		     //        [
		     //            'label' => __( 'Set Height', 'edumodo' ),
		     //            'type' => Controls_Manager::SLIDER,
		     //            'range' => [
		     //                'px' => [
		     //                    'min' => 150,
		     //                    'max' => 600,
		     //                ],
		     //            ],
		     //            'selectors' => [
		     //                '{{WRAPPER}} .edumodo-lp-course-1 .lp-course-1' => 'max-height: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
		     //            ],
		     //        ]
		     //    );


		       	$this->add_control(
		            'content_autoplay_mode',
		                [
		                    'label' => __( 'Autoplay', 'edumodo' ),
		                    'type'  => Controls_Manager::HEADING,
		                    'separator' => 'before',
		                ]
		            );
	        		$this->add_control(
						'autoplay_enable',
						[
							'label'     => __( 'Enable', 'edumodo' ),
							'type'      => Controls_Manager::SWITCHER,
							'default'   => 'no',
							'true'    => __( 'True', 'edumodo' ),
							'false'   => __( 'False', 'edumodo' ),
						]
					);

		        // $this->add_control(
		        //     'content_interval',
		        //         [
		        //             'label' => __( 'Interval', 'edumodo' ),
		        //             'type'  => Controls_Manager::HEADING,
		        //             'separator' => 'before',
		        //         ]
		        //     );

	            // $this->add_control(
	            //     'content_interval_option',
	            //     [
	            //         'label'   => __( 'Set Interval', 'edumodo' ),
	            //         'type'    => Controls_Manager::NUMBER,
	            //         'default' => 5000,
	            //         'min'     => 100,
	            //         'max'     => 10000,
	            //         'step'    => 10,
	            //     ]
	            // );


	        $this->end_controls_section();

	    $this->start_controls_section(
            'navs_content',
                [
                    'label' => esc_html__( 'Navigation', 'edumodo' ),
                ]
        );

		        $this->add_control(
	                'content_arrow_heading',
	                [
	                    'label' => __( 'Arrow', 'edumodo' ),
	                    'type'  => Controls_Manager::HEADING,
	                    'separator' => 'before',
	                ]
	            );

	            $this->add_control(
	                'arrow_enable',
	                    [
	                        'label'     => esc_html__( 'Display', 'edumodo' ),
	                        'type'      => Controls_Manager::SWITCHER,
	                        'default'   => 'no',
	                        'yes'    => esc_html__( 'Yes', 'edumodo' ),
	                        'no'     => esc_html__( 'No', 'edumodo' ),
	                    ]
	            );


	            
				$this->add_control(
	                'content_nav_heading',
	                [
	                    'label' => __( 'Dot', 'edumodo' ),
	                    'type'  => Controls_Manager::HEADING,
	                    'separator' => 'before',
	                ]
	            );

		        $this->add_control(
	                'dot_enable',
	                    [
	                        'label'     => esc_html__( 'Display', 'edumodo' ),
	                        'type'      => Controls_Manager::SWITCHER,
	                        'default'   => 'yes',
	                        'yes'    => esc_html__( 'Yes', 'edumodo' ),
	                        'no'     => esc_html__( 'No', 'edumodo' ),
	                    ]
	            );


        $this->end_controls_section();


       	$this->start_controls_section(
            'section_style_thumbnail',
            [
                'label' => esc_html__( 'Image', 'edumodo' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        	    $this->add_control(
					'thumbnail_position',
					[
						'label' => __( 'Position', 'edumodo' ),
						'type' => Controls_Manager::CHOOSE,
						'default' => 'left',
						'options' => [
							'left' => [
								'title' => __( 'Left', 'edumodo' ),
								'icon' => 'eicon-h-align-left',
							],
							'right' => [
								'title' => __( 'Right', 'edumodo' ),
								'icon' => 'eicon-h-align-right',
							],
						],
						'toggle' => false,
					]
				);


	           	$this->add_control(
		            'image_radius',
		            [
		                'label' => esc_html__( 'Border Radius', 'edumodo' ),
		                'type'  => Controls_Manager::DIMENSIONS,
		                'size_units' => [ 'px', '%' ],
		                'selectors'  => [
		                    '{{WRAPPER}} .edumodo-testimonial .edumodo-testimoni-wrapper .testimoni-image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		                ],
		            ]
		        );

        $this->end_controls_section();


		// $this->start_controls_section(
		// 	'section_testimoni_style',
		// 	[
		// 		'label' => __( 'Style', 'edumodo' ),
		// 		'tab'   => Controls_Manager::TAB_STYLE,
		// 	]
		// );

			// $this->add_control(
			// 	'bg_color',
			// 	[
			// 		'label'     => __( 'Background Color', 'edumodo' ),
			// 		'type'      => Controls_Manager::COLOR,
			// 		'default'   => 'transparent',
			// 		'selectors' => [
			// 			'{{WRAPPER}} .edumodo-testimonial .edumodo-testimoni-wrapper' => 'background-color: {{VALUE}};',

			// 		],
			// 	]
			// );

		// $this->add_control(
		// 	'hover_bg_color',
		// 	[
		// 		'label'     => __( 'Dot Color', 'edumodo' ),
		// 		'type'      => Controls_Manager::COLOR,
		// 		'default'   => '',
		// 		'selectors' => [
		// 			'{{WRAPPER}} .edumodo-testimonial .owl-controls .owl-dot.active' => 'background: {{VALUE}}; border-color: {{VALUE}};',
		// 			'{{WRAPPER}} .edumodo-testimonial .owl-controls .owl-dot' => 'border-color: {{VALUE}};',
		// 		],
		// 	]
		// );

	// $this->end_controls_section();



	    $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__( 'Content', 'edumodo' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );


	            $this->add_control(
	                'content_heading',
	                [
	                    'label' => __( 'Description', 'edumodo' ),
	                    'type'  => Controls_Manager::HEADING,
	                    'separator' => 'before',
	                ]
	            );

	            $this->add_control(
	                'testimoni_color',
	                [
	                    'label'     => esc_html__( 'Color', 'edumodo' ),
	                    'type'      => Controls_Manager::COLOR,
	                    'default'   => '',
	                    'selectors' => [
	                        '{{WRAPPER}} .edumodo-testimonial .edumodo-testimoni-wrapper .testimony .desc' => 'color: {{VALUE}};',
	                    ],
	                ]
	            );



	            $this->add_group_control(
	                Group_Control_Typography::get_type(),
	                    [
	                        'name'     => 'Content_typography',
	                        'label'    => esc_html__( 'Typography', 'edumodo' ),
	                        'scheme'   => Scheme_Typography::TYPOGRAPHY_4,
	                        'selector' => '{{WRAPPER}} .edumodo-testimonial .edumodo-testimoni-wrapper .testimony .desc',
	                    ]
	            );


	            $this->add_responsive_control(
		            'content_spacing',
		                [
		                    'label'   => esc_html__( 'Spacing', 'edumodo' ),
		                    'type'    => Controls_Manager::SLIDER,
		                    'default' => [
		                    'size'    => '',
		                    ],
		                    'range'   => [
		                        'px'  => [
		                            'min' => 0,
		                            'max' => 100,
		                        ],
		                    ],
		                    'selectors' => [
		                        '{{WRAPPER}} .edumodo-testimonial .edumodo-testimoni-wrapper .testimony .desc' => 'margin: 0 0 {{SIZE}}{{UNIT}};',
		                    ],
		                ]
		        );

	        	$this->add_control(
		            'quote_color',
		            [
		                'label'     => esc_html__( 'Quote Color', 'edumodo' ),
		                'type'      => Controls_Manager::COLOR,
		                'default'   => '',
		                'selectors' => [
		                    '{{WRAPPER}} .edumodo-testimonial .edumodo-testimoni-wrapper:before' => 'color:{{VALUE}};',
		                ],
		            ]
		        );

	            $this->add_control(
	                'title_heading',
	                [
	                    'label' => __( 'Title', 'edumodo' ),
	                    'type'  => Controls_Manager::HEADING,
	                    'separator' => 'before',
	                ]
	            );

	            $this->add_control(
	                'name_color',
	                [
	                    'label'     => esc_html__( 'Color', 'edumodo' ),
	                    'type'      => Controls_Manager::COLOR,
	                    'default'   => '',
	                    'selectors' => [
	                        '{{WRAPPER}} .edumodo-testimonial .edumodo-testimoni-wrapper .testimony .name-des .name' => 'color: {{VALUE}};',
	                    ],
	                ]
	            );

	            $this->add_group_control(
	                Group_Control_Typography::get_type(),
	                    [
	                        'name'     => 'name_typography',
	                        'label'    => esc_html__( 'Typography', 'edumodo' ),
	                        'scheme'   => Scheme_Typography::TYPOGRAPHY_4,
	                        'selector' => '{{WRAPPER}} .edumodo-testimonial .edumodo-testimoni-wrapper .testimony .name-des .name',
	                    ]
	            );

	           	// $this->add_control(
	            //     'name_hover_color',
	            //     [
	            //         'label'     => esc_html__( 'Hover Color', 'edumodo' ),
	            //         'type'      => Controls_Manager::COLOR,
	            //         'default'   => '#fff',
	            //         'selectors' => [
	            //             '{{WRAPPER}} .wk-testimonial .wk-card:hover .wk-card-body .wk-card-title a' => 'color: {{VALUE}};',
	            //         ],
	            //     ]
	            // );

	            $this->add_responsive_control(
	                'name_spacing',
	                    [
	                        'label'   => esc_html__( 'Spacing', 'edumodo' ),
	                        'type'    => Controls_Manager::SLIDER,
	                        'default' => [
	                        'size'    => '',
	                        ],
	                        'range'  => [
	                            'px' => [
	                                'min' => 0,
	                                'max' => 100,
	                            ],
	                        ],
	                        'selectors' => [
	                            '{{WRAPPER}} .edumodo-testimonial .edumodo-testimoni-wrapper .testimony .position-right .designation' => 'margin-left: {{SIZE}}{{UNIT}};',
	                            '{{WRAPPER}} .edumodo-testimonial .edumodo-testimoni-wrapper .testimony .position-bottom .designation' => 'margin-top: {{SIZE}}{{UNIT}};',
	                        ],
	                    ]
	            );

	            $this->add_control(
		            'designation_heading',
		            [
		                'label' => __( 'Designation', 'edumodo' ),
		                'type'  => Controls_Manager::HEADING,
		                'separator' => 'before',
		            ]
		        );

		        $this->add_control(
		            'designation_color',
		            [
		                'label'     => esc_html__( 'Color', 'edumodo' ),
		                'type'      => Controls_Manager::COLOR,
		                'default'   => '',
		                'selectors' => [
		                    '{{WRAPPER}} .edumodo-testimonial .edumodo-testimoni-wrapper .testimony .name-des .designation' => 'color: {{VALUE}};',
		                ],
		            ]
		        );

		        $this->add_group_control(
		            Group_Control_Typography::get_type(),
		                [
		                    'name'     => 'designation_typography',
		                    'label'    => esc_html__( 'Typography', 'edumodo' ),
		                    'scheme'   => Scheme_Typography::TYPOGRAPHY_4,
		                    'selector' => '{{WRAPPER}} .edumodo-testimonial .edumodo-testimoni-wrapper .testimony .name-des .designation',
		                ]
		        );
		        // $this->add_control(
	         //        'designation_hover_color',
	         //        [
	         //            'label'     => esc_html__( 'Hover Color', 'edumodo' ),
	         //            'type'      => Controls_Manager::COLOR,
	         //            'default'   => '#fff',
	         //            'selectors' => [
	         //                '{{WRAPPER}} .wk-testimonial .wk-card:hover .wk-card-body span' => 'color: {{VALUE}};',
	         //            ],
	         //            'condition'   => [
          //               	'item_styles' => ['screen_4'],
          //           	],
	         //        ]
	         //    );



		       	$this->add_control(
					'designation_position',
					[
						'label' => __( 'Position', 'edumodo' ),
						'type' => Controls_Manager::CHOOSE,
						'default' => 'right',
						'options' => [
							'right' => [
								'title' => __( 'Right', 'edumodo' ),
								'icon' => 'eicon-h-align-right',
							],
							'bottom' => [
								'title' => __( 'Bottom', 'edumodo' ),
								'icon' => 'eicon-v-align-bottom',
							],
						],
						'toggle' => false,
					]
				);



	            $this->add_control(
		            'global_heading',
		            [
		                'label' => __( 'Global', 'edumodo' ),
		                'type'  => Controls_Manager::HEADING,
		                'separator' => 'before',
		            ]
		        );

	            $this->add_control(
	                'bg_color',
	                [
	                    'label'     => esc_html__( 'Background Color', 'edumodo' ),
	                    'type'      => Controls_Manager::COLOR,
	                    'default'   => '',
	                    'selectors' => [
	                        '{{WRAPPER}} .edumodo-testimonial .edumodo-testimoni-wrapper' => 'background: {{VALUE}};',
	                    ],
	                ]
	            );


	            $this->add_group_control(
	                Group_Control_Box_Shadow::get_type(),
	                [
	                    'name' => 'content_box_shadow',
	                    'label'     => esc_html__( 'Normal Box Shadow', 'edumodo' ),
	                    'exclude' => [
	                        'box_shadow_position',
	                    ],
	                    'selector' => '{{WRAPPER}} .edumodo-testimonial .edumodo-testimoni-wrapper',
	                ]
	            );

	           	$this->add_group_control(
	                Group_Control_Box_Shadow::get_type(),
	                [
	                    'name' => 'content_hover_box_shadow',
	                    'label'     => esc_html__( 'Hover Box Shadow', 'edumodo' ),
	                    'exclude' => [
	                        'box_shadow_position',
	                    ],
	                    'selector' => '{{WRAPPER}} .edumodo-testimonial .edumodo-testimoni-wrapper:hover',
	                ]
	            );

			    $this->add_control(
					'content_layout_align',
					[
						'label' => esc_html__( 'Alignment', 'edumodo' ),
						'type'  => Controls_Manager::CHOOSE,
						'default'   => '',
						'options'   => [
							'left'    => [
								'title' => esc_html__( 'Left', 'edumodo' ),
								'icon'  => 'eicon-text-align-left',
							],
							'center' => [
								'title' => esc_html__( 'Center', 'edumodo' ),
								'icon'  => 'eicon-text-align-center',
							],
							'right' => [
								'title' => esc_html__( 'Right', 'edumodo' ),
								'icon'  => 'eicon-text-align-left',
							],
						],
						'selectors' => [
							'{{WRAPPER}} .edumodo-testimonial .edumodo-testimoni-wrapper' => 'text-align: {{VALUE}};',
						],
					]
				);

				$this->add_control(
		            'content_item_padding',
		            [
		                'label' => esc_html__( 'Padding', 'edumodo' ),
		                'type'  => Controls_Manager::DIMENSIONS,
		                'size_units' => [ 'px', '%' ],
		                'selectors'  => [
		                    '{{WRAPPER}} .edumodo-testimonial .edumodo-testimoni-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		                ],
		            ]
		        );


			$this->add_control(
		        'item_border_radius',
		            [
		                'label' => esc_html__( 'Radius', 'edumodo' ),
		                'type'  => Controls_Manager::DIMENSIONS,
		                'size_units' => [ 'px', '%' ],
		                'selectors'  => [
		                    '{{WRAPPER}} .edumodo-testimonial .edumodo-testimoni-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		                ],
		            ]
		    );

        $this->end_controls_section();

        // Navigation options Start
        $this->start_controls_section(
            'navs_style',
                [
                    'label' => esc_html__( 'Navigation', 'edumodo' ),
                    'tab'   => Controls_Manager::TAB_STYLE,
                ]
        );

            $this->add_control(
                'arrow_heading',
                [
                    'label' => __( 'Arrow', 'edumodo' ),
                    'type'  => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition' => [
                        'arrow_enable' => 'yes',
                    ],
                ]
            );

            $this->add_control(
                'arrow_color',
                    [
                        'label' => esc_html__( 'Color', 'edumodo' ),
                        'type'  => Controls_Manager::COLOR,
                        'default'   => '',
                        'selectors' => [
                          '{{WRAPPER}} .edumodo-testimonial .owl-nav .owl-carousel-left, {{WRAPPER}} .edumodo-testimonial .owl-nav .owl-carousel-right' => 'color: {{VALUE}};',
                        ],

                       'condition' => [
                            'arrow_enable' => 'yes',
                        ],
                    ]
            );

            $this->add_responsive_control(
	            'arrow_font_size',
	                [
	                    'label'  => esc_html__( 'Size', 'edumodo' ),
	                    'type'   => Controls_Manager::SLIDER,
	                    'default'  => [
	                        'size' =>25,
	                    ],
	                    'range'  => [
	                        'px' => [
	                            'min' =>20,
	                            'max' => 50,
	                        ],
	                    ],
	                    'selectors' => [
	                        '{{WRAPPER}} .edumodo-testimonial .owl-nav .owl-carousel-left, {{WRAPPER}} .edumodo-testimonial .owl-nav .owl-carousel-right' => 'width: {{SIZE}}{{UNIT}}; height:{{SIZE}}{{UNIT}};',
	                    ],
	                    'condition' => [
                        	'arrow_enable' => 'yes',
                    	],
	                ]
            );


            $this->add_control(
                'arrow_background_color',
                    [
                        'label' => esc_html__( 'Background Color', 'edumodo' ),
                        'type'  => Controls_Manager::COLOR,
                        'default'   => '',
                        'selectors' => [
                          '{{WRAPPER}} .edumodo-testimonial .owl-nav .owl-carousel-left, {{WRAPPER}} .edumodo-testimonial .owl-nav .owl-carousel-right' => 'background: {{VALUE}}; transition:all 0.3s ease;',
                        ],

                       'condition' => [
                            'arrow_enable' => 'yes',
                        ],
                    ]
            );

            $this->add_control(
                'arrow_hover_background_color',
                    [
                        'label' => esc_html__( 'Hover Background Color', 'edumodo' ),
                        'type'  => Controls_Manager::COLOR,
                        'default'   => '',
                        'selectors' => [
                          '{{WRAPPER}} .edumodo-testimonial .owl-nav .owl-carousel-left:hover, {{WRAPPER}} .edumodo-testimonial .owl-nav .owl-carousel-right:hover' => 'background: {{VALUE}}; transition:all 0.3s ease;',

                        ],

                       'condition' => [
                            'arrow_enable' => 'yes',
                        ],
                    ]
            );


            $this->add_control(
	            'arrow_border_radius',
	            [
	                'label' => esc_html__( 'Border Radius', 'edumodo' ),
	                'type'  => Controls_Manager::DIMENSIONS,
	                'size_units' => [ 'px', '%' ],
	                'selectors'  => [
	                    '{{WRAPPER}} .edumodo-testimonial .owl-nav .owl-carousel-left, {{WRAPPER}} .edumodo-testimonial .owl-nav .owl-carousel-right' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	                ],
	                'condition' => [
                        'arrow_enable' => 'yes',
                    ],
                    'separator' => 'after',
	            ]
	        );


            $this->add_control(
                'dot_heading',
                [
                    'label' => __( 'Dot', 'edumodo' ),
                    'type'  => Controls_Manager::HEADING,
                    'condition' => [
                        'dot_enable' => 'yes',
                    ],
                ]
            );



		    $this->start_controls_tabs( 'tabs_nav_style' );

		    $this->start_controls_tab(
		        'tab_nav_normal',
		          [
		            'label' => esc_html__( 'Normal', 'edumodo' ),
		            'condition' => [
                        'dot_enable' => 'yes',
                    ],
		          ]
		    );

            $this->add_responsive_control(
	            'dot_normal_size',
	                [
	                    'label'  => esc_html__( 'Size', 'edumodo' ),
	                    'type'   => Controls_Manager::SLIDER,
	                    'default'  => [
	                        'size' =>10,
	                    ],
	                    'range'  => [
	                        'px' => [
	                            'min' => 10,
	                            'max' => 24,
	                        ],
	                    ],
	                    'selectors' => [
	                        

	                        '{{WRAPPER}} .edumodo-testimonial .owl-dots .owl-dot' => 'width: {{SIZE}}{{UNIT}}; height:{{SIZE}}{{UNIT}}; transition: all 0.3s ease;',
	                    ],
	                    'condition' => [
                        	'dot_enable' => 'yes',
                    	],
	                ]
            );

            $this->add_control(
                'dot_background_color',
                    [
                        'label' => esc_html__( 'Background Color', 'edumodo' ),
                        'type'  => Controls_Manager::COLOR,
                        'default'   => '',
                        'selectors' => [
                          '{{WRAPPER}} .edumodo-testimonial .owl-dots .owl-dot' => 'background-color: {{VALUE}};',
                        ],
                        'condition' => [
                        	'dot_enable' => 'yes',
                    	],
                    ]
            );


	        $this->add_group_control(
	            Group_Control_Border::get_type(),
	            [
	                'name'  => 'dot_border',
	                'label' => esc_html__( 'Border', 'edumodo' ),
	                'placeholder' => '1px',
	                'default'  => '1px',
	                'selector' => '
	                    {{WRAPPER}} .edumodo-testimonial .owl-dots .owl-dot',
	                'separator' => 'before',
	                'condition' => [
                        'dot_enable' => 'yes',
                    ],
	            ]
	        );

        	$this->add_control(
	            'dot_border_radius',
	            [
	                'label' => esc_html__( 'Border Radius', 'edumodo' ),
	                'type'  => Controls_Manager::DIMENSIONS,
	                'size_units' => [ 'px', '%' ],
	                'selectors'  => [
	                    '{{WRAPPER}} .edumodo-testimonial .owl-dots .owl-dot' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	                ],
	                'condition' => [
                        'dot_enable' => 'yes',
                    ],
	            ]
	        );

		    $this->add_control(
				'dot_nav_align',
				[
					'label' => esc_html__( 'Alignment', 'edumodo' ),
					'type'  => Controls_Manager::CHOOSE,
					'default'   => 'center',
					'options'   => [
						'left'    => [
							'title' => esc_html__( 'Left', 'edumodo' ),
							'icon'  => 'eicon-text-align-left',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'edumodo' ),
							'icon'  => 'eicon-text-align-center',
						],
						'right' => [
							'title' => esc_html__( 'Right', 'edumodo' ),
							'icon'  => 'eicon-text-align-left',
						],
					],
					'condition' => [
                       	'dot_enable' => 'yes',
                   	],
               	     'selectors_dictionary'  => [
                        'left'          => 'left',
                        'center'        => 'center',
                        'right'         => 'right',
                    ],
                    'selectors'             => [
                        '{{WRAPPER}} .edumodo-testimonial .owl-dots' => 'text-align: {{VALUE}};',
                    ],
				]
			);

		    $this->end_controls_tab();


		    $this->start_controls_tab(
		        'tab_nav_hover',
		            [
		                'label' => esc_html__( 'Active', 'edumodo' ),
		                'condition' => [
                        	'dot_enable' => 'yes',
                    	],
		            ]
		    );

		    $this->add_control(
		        'dot_background_hover_color',
		            [
		                'label' => esc_html__( 'Background Color', 'edumodo' ),
		                'type'  => Controls_Manager::COLOR,
		                'default'   => '',
		                'selectors' => [
		                  '{{WRAPPER}} .edumodo-testimonial .owl-dots .owl-dot.active, {{WRAPPER}} .edumodo-testimonial .owl-dots .owl-dot:hover' => 'background-color: {{VALUE}}; border-color: {{VALUE}};',
		                ],
		                'condition' => [
                        	'dot_enable' => 'yes',
                    	],
		            ]
		    );

	    	$this->end_controls_tab();


	    $this->end_controls_tabs();

	$this->end_controls_section();


	// $this->start_controls_section(
	// 	'section_style_content',
	// 		[
	// 			'label' => __( 'Content', 'edumodo' ),
	// 			'tab'   => Controls_Manager::TAB_STYLE,
	// 		]
	// 	);

		    // $this->add_control(
      //           'quote_color',
      //           [
      //               'label'     => esc_html__( 'Quote Color', 'edumodo' ),
      //               'type'      => Controls_Manager::COLOR,
      //               'default'   => '',
      //               'selectors' => [
      //                   '{{WRAPPER}} .edumodo-testimonial .edumodo-testimoni-wrapper:before' => 'color: {{VALUE}};',
      //               ],
      //           ]
      //       );

	// $this->add_control(
	// 	'testimoni_color',
	// 	[
	// 		'label'     => __( 'Content Color', 'edumodo' ),
	// 		'type'      => Controls_Manager::COLOR,
	// 		'default'   => '#666',
	// 		'selectors' => [
	// 			'{{WRAPPER}} .edumodo-testimoni-wrapper .desc' => 'color: {{VALUE}};',
	// 		],
	// 	]
	// );
	// $this->add_group_control(
 //        Group_Control_Typography::get_type(),
 //        [
 //            'name' => 'Content_typography',
 //            'selector' => '{{WRAPPER}} .edumodo-testimoni-wrapper .desc',
 //            'scheme' => Scheme_Typography::TYPOGRAPHY_3,
 //        ]
 //    );
	// $this->end_controls_section();

	// $this->start_controls_section(
	// 	'section_style_name',
	// 		[
	// 			'label' => __( 'Name', 'edumodo' ),
	// 			'tab'   => Controls_Manager::TAB_STYLE,
	// 		]
	// 	);

	// $this->add_control(
	// 	'name_color',
	// 	[
	// 		'label'     => __( 'Name Color', 'edumodo' ),
	// 		'type'      => Controls_Manager::COLOR,
	// 		'default'   => '#182432',
	// 		'selectors' => [
	// 			'{{WRAPPER}} .edumodo-testimoni-wrapper .name-des .name' => 'color: {{VALUE}};',
	// 		],
	// 	]
	// );
	// $this->add_group_control(
 //        Group_Control_Typography::get_type(),
 //        [
 //            'name' => 'name_typography',
 //            'selector' => '{{WRAPPER}} .edumodo-testimoni-wrapper .name-des .name',
 //            'scheme' => Scheme_Typography::TYPOGRAPHY_3,
 //        ]
 //    );
	// $this->end_controls_section();

	// $this->start_controls_section(
	// 	'section_style_designation',
	// 		[
	// 			'label' => __( 'Designation', 'edumodo' ),
	// 			'tab'   => Controls_Manager::TAB_STYLE,
	// 		]
	// 	);

	// $this->add_control(
	// 	'designation_color',
	// 	[
	// 		'label'     => __( 'Designation Color', 'edumodo' ),
	// 		'type'      => Controls_Manager::COLOR,
	// 		'default'   => '#989898',
	// 		'selectors' => [
	// 			'{{WRAPPER}} .edumodo-testimoni-wrapper .name-des .designation' => 'color: {{VALUE}};',
	// 		],
	// 	]

	// );
	// $this->add_group_control(
 //        Group_Control_Typography::get_type(),
 //        [
 //            'name' => 'designation_typography',
 //            'selector' => '{{WRAPPER}} .edumodo-testimoni-wrapper .name-des .designation',
 //            'scheme' => Scheme_Typography::TYPOGRAPHY_3,
 //        ]
 //    );
	// $this->end_controls_section();


	}

	protected function render() {
		require EDUMODO_CORE_ROOT . '/elements/testimonial/template/view.php';
	}


}
