<?php

use Elementor\Group_Control_Border;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor edumodo teacher 2
 *
 * Elementor widget for edumodo teacher 2
 *
 * @since 1.0.0
 */
class Edumodo_Teachers_2 extends Widget_Base {

	public function get_name() {
		return 'edumodo-teacher-2';
	}

	public function get_title() {
		return __( 'Teacher 2', 'edumodo' );
	}

	public function get_icon() {
		return 'eicon-person';
	}

	public function get_categories() {
		return [ 'edumodo' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
	public function get_script_depends() {
		return [ 'edumodo-teacher-2' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'section_icon',
			[
				'label' => __( 'Content', 'edumodo' ),
			]
		);

        $this->add_control(
            'posts_per_page',
            [
                'label' => __('Item to Show', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 6,
                'min' => -1,
                'max' => 50,
                'step' => 1,
            ]
        );

        $this->add_control(
            'posts_column',
            [
                'label' => __('Column to Show', 'edumodo'),
                'type' => Controls_Manager::SELECT,
                'default' => '4',
                'options' => [
                    '2'  => __('6', 'edumodo'),
                    '3'  => __('4', 'edumodo'),
                    '4'  => __('3', 'edumodo'),
                    '6'  => __('2', 'edumodo'),
                    '12' => __('1', 'edumodo'),
                ],
            ]
        );

		$this->end_controls_section();


		$this->start_controls_section(
			'section_conent_social',
			[
				'label' => __( 'Social Info', 'edumodo' ),
			]
		);
		    $this->add_control(
                'show_social',
                [
                    'label' => __( 'Display', 'edumodo' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'edumodo' ),
                    'label_off' => __( 'Hide', 'edumodo' ),
                    'return_value' => 'yes',
                ]
            );
		$this->end_controls_section();


		$this->start_controls_section(
			'section_style',
				[
					'label' => __( 'Content', 'edumodo' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);

				$this->add_control(
	                'content_name_heading',
	                    [
	                        'label' => __( 'Name', 'edumodo' ),
	                        'type' => Controls_Manager::HEADING,
	                        'separator' => 'before',
	                    ]
	            );

				$this->add_control(
					'name_color',
					[
						'label'     => __( 'Color', 'edumodo' ),
						'type'      => Controls_Manager::COLOR,
						'default'   => '',
						'selectors' => [
							'{{WRAPPER}} .edumodo-teacher-2 .teacher-2 .teacher-container .teacher-each-wrap .teacher-info .name .teacher-title' => 'color: {{VALUE}};',
						],
					]
				);
	            $this->add_group_control(
		            Group_Control_Typography::get_type(),
		            [
		                'name' => 'title_typography',
		                'selector' => '{{WRAPPER}} .edumodo-teacher-2 .teacher-2 .teacher-container .teacher-each-wrap .teacher-info .name .teacher-title',
		                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
		            ]
		        );

		        $this->add_control(
					'name_hover_color',
					[
						'label'     => __( 'Hover Color', 'edumodo' ),
						'type'      => Controls_Manager::COLOR,
						'default'   => '',
						'selectors' => [
							'{{WRAPPER}} .edumodo-teacher-2 .teacher-2 .teacher-container .teacher-each-wrap .teacher-info .name .teacher-title:hover' => 'color: {{VALUE}};',
						],
					]
				);
				$this->add_responsive_control(
					'teacher2_title_space',
					[
						'label' => __( 'Spacing', 'edumodo' ),
						'type' => Controls_Manager::SLIDER,
						'range' => [
							'px' => [
								'min' => 5,
								'max' => 50,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .edumodo-teacher-2 .teacher-2 .teacher-container .teacher-each-wrap .teacher-info .name .teacher-title' => 'margin: 0 0 {{SIZE}}{{UNIT}};',
						],
					]
				);

				$this->add_control(
	                'content_designation_heading',
	                    [
	                        'label' => __( 'Designation', 'edumodo' ),
	                        'type' => Controls_Manager::HEADING,
	                        'separator' => 'before',
	                    ]
	            );
	            $this->add_control(
					'degree_color',
					[
						'label'     => __( 'Color', 'edumodo' ),
						'type'      => Controls_Manager::COLOR,
						'default'   => '',
						'selectors' => [
							'{{WRAPPER}} .edumodo-teacher-2 .teacher-2 .teacher-container .teacher-each-wrap .teacher-info span' => 'color: {{VALUE}};',
						],
					]
				);

			    $this->add_group_control(
		            Group_Control_Typography::get_type(),
		            [
		                'name' => 'designation_typography',
		                'selector' => '{{WRAPPER}} .edumodo-teacher-2 .teacher-2 .teacher-container .teacher-each-wrap .teacher-info .name',
		                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
		            ]
		        );

		        $this->add_control(
	                'content_common_heading',
	                    [
	                        'label' => __( 'Common', 'edumodo' ),
	                        'type' => Controls_Manager::HEADING,
	                        'separator' => 'before',
	                    ]
	            );

	            $this->add_responsive_control(
	                'content_layout_align',
	                [
	                    'label' => esc_html__( 'Alignment', 'edumodo' ),
	                    'type'  => Controls_Manager::CHOOSE,
	                    'default'   =>'center' ,
	                    'options'   => [
	                        'left'    => [
	                            'title' => esc_html__( 'Left', 'edumodo' ),
	                            'icon'  => 'eicon-text-align-left',
	                        ],
	                        'center' => [
	                            'title' => esc_html__( 'Center', 'edumodo' ),
	                            'icon'  => 'eicon-text-align-center',
	                        ],
	                        'right' => [
	                            'title' => esc_html__( 'Right', 'edumodo' ),
	                            'icon'  => 'eicon-text-align-left',
	                        ],
	                    ],
	                    'selectors' => [
	                        '{{WRAPPER}} .edumodo-teacher-2 .teacher-2 .teacher-container .teacher-each-wrap .teacher-info' => 'text-align: {{VALUE}};',
	                    ],
	                ]
	            );
	           	$this->add_control(
	                'content_padding',
	                [
	                    'label' => esc_html__( 'Padding', 'edumodo' ),
	                    'type'  => Controls_Manager::DIMENSIONS,
	                    'size_units' => [ 'px', '%' ],
	                    'selectors'  => [
	                        '{{WRAPPER}} .edumodo-teacher-2 .teacher-2 .teacher-container .teacher-each-wrap .teacher-info' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	                    ],
	                    
	                ]
	            );

		$this->end_controls_section();


		$this->start_controls_section(
			'meta_style',
				[
					'label' => __( 'Social Info', 'edumodo' ),
					'tab'   => Controls_Manager::TAB_STYLE,
					'condition'   => [
                        'show_social' => 'yes',
                    ],
				]
			);

			$this->add_control(
				'icon_size',
				[
					'label' => __( 'Icon Size', 'edumodo' ),
					'type' => Controls_Manager::SLIDER,
					'default' => [
						'size' => 14,
					],
					'range' => [
						'px' => [
							'min' => 10,
							'max' => 60,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .teacher-2 .teacher-container:hover .teacher-social i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
					'condition'   => [
                        'show_social' => 'yes',
                    ],
				]
			);

            $this->start_controls_tabs( 'tabs_button_style' );

            $this->start_controls_tab(
                'button_normal',
                [
                    'label' => esc_html__( 'Normal', 'edumodo' ),
                    'condition'   => [
                        'show_social' => 'yes',
                    ],
                ]
            );

            $this->add_control(
                'icon_color',
                [
                    'label'   => esc_html__( 'Color', 'edumodo' ),
                    'type'    => Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .teacher-2 .teacher-container .teacher-each-wrap .teacher-social a' => 'color: {{VALUE}};',
                    ],
                    'condition'   => [
                        'show_social' => 'yes',
                    ],
                ]
            );

            $this->add_control(
                'icon_background_color',
                [
                    'label' => esc_html__( 'Background Color', 'edumodo' ),
                    'type'  => Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .teacher-2 .teacher-container .teacher-each-wrap .teacher-social a' => 'background-color: {{VALUE}};',
                    ],
                    'condition'   => [
                        'show_social' => 'yes',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name'  => 'icon_border',
                    'label' => esc_html__( 'Border', 'edumodo' ),
                    'placeholder' => '1px',
                    'default'   => '1px',
                    'selector'  => '{{WRAPPER}} .teacher-2 .teacher-container .teacher-each-wrap .teacher-social a',
                    'condition'   => [
                        'show_social' => 'yes',
                    ],
                  
                ]
            );

            $this->end_controls_tab();

            $this->start_controls_tab(
                'icon_hover',
                [
                    'label' => esc_html__( 'Hover', 'edumodo' ),
                    'condition'   => [
                        'show_social' => 'yes',
                    ],
                ]
            );

            $this->add_control(
                'icon_hover_color',
                [
                    'label' => esc_html__( 'Color', 'edumodo' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .teacher-2 .teacher-container .teacher-each-wrap .teacher-social a:hover i' => 'color: {{VALUE}};',
                    ],
                    'condition'   => [
                        'show_social' => 'yes',
                    ],
                ]
            );

            $this->add_control(
                'icon_background_hover_color',
                [
                    'label' => esc_html__( 'Background Color', 'edumodo' ),
                    'type'  => Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .teacher-2 .teacher-container .teacher-each-wrap .teacher-social a:hover' => 'background-color: {{VALUE}};',
                    ],
                    'condition'   => [
                        'show_social' => 'yes',
                    ],

                ]
            );

            $this->add_control(
                'icon_hover_border_color',
                [
                    'label' => esc_html__( 'Border Color', 'edumodo' ),
                    'type'  => Controls_Manager::COLOR,
                    'default'   => '',
                    'selectors' => [
                        '{{WRAPPER}} .teacher-2 .teacher-container .teacher-each-wrap .teacher-social a:hover' => 'border-color: {{VALUE}};',
                    ],
                    'condition'   => [
                        'show_social' => 'yes',
                    ],
                ]
            );

            $this->end_controls_tab();

            $this->end_controls_tabs();

            $this->add_control(
                'border_radius_icon',
                [
                    'label' => esc_html__( 'Border Radius', 'edumodo' ),
                    'type'  => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors'  => [
                        '{{WRAPPER}} .teacher-2 .teacher-container .teacher-each-wrap .teacher-social a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    
                ]
            );


            $this->add_control(
				'icon_width',
				[
					'label' => __( 'Padding', 'edumodo' ),
					'type' => Controls_Manager::SLIDER,
					'default' => [
						'size' => 40,
					],
					'range' => [
						'px' => [
							'min' =>30,
							'max' => 60,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .teacher-2 .teacher-container .teacher-each-wrap .teacher-social a' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
					],
					'separator' => 'before',
				]
			);

		$this->end_controls_section();


		$this->start_controls_section(
			'section_style_icon',
				[
					'label' => __( 'Global', 'edumodo' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);

		    $this->add_control(
				'layout_bg_color',
					[
						'label'     => __( 'Background Color', 'edumodo' ),
						'type'      => Controls_Manager::COLOR,
						'default'   => '',
						'selectors' => [
							'{{WRAPPER}} .teacher-2 .teacher-container .teacher-block' => 'background-color: {{VALUE}};',
						],
						'separator' => 'after',
					]
			);

		    $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name'  => 'border_width',
                    'label' => esc_html__( 'Border', 'edumodo' ),
                    'placeholder' => '1px',
                    'default'   => '1px',
                    'selector'  => '{{WRAPPER}} .teacher-2 .teacher-container .teacher-block',
                  
                ]
            );

			$this->add_control(
	            'border_radius',
	            [
	                'label' => __( 'Border Radius', 'edumodo' ),
	                'type' => Controls_Manager::SLIDER,
	                'range' => [
	                    'px' => [
	                        'min' => 0,
	                        'max' => 100,
	                    ],
	                ],
	                'selectors' => [
	                    '{{WRAPPER}} .teacher-2 .teacher-container .teacher-block' => 'border-radius: {{SIZE}}{{UNIT}};',
	                ],
	            ]
	        );

	        $this->add_group_control(
	            Group_Control_Box_Shadow::get_type(),
	            [
	                'name' => 'box_shadow',
	                'selector' => '{{WRAPPER}} .teacher-2 .teacher-container .teacher-block',
	            ]
	        );

	        $this->add_group_control(
	            Group_Control_Box_Shadow::get_type(),
	            [   'label' => __( 'Hover Box Shadow', 'edumodo' ),
	                'name' => 'box_shadow_hover',
	                'selector' => '{{WRAPPER}} .teacher-2 .teacher-container .teacher-block:hover',
	            ]
	        );


			$this->add_control(
               'content_overlay_heading',
                    [
                        'label' => __( 'Overlay', 'edumodo' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                    ]
            );

			$this->add_control(
				'overlay_color',
					[
						'label'     => __( 'Color', 'edumodo' ),
						'type'      => Controls_Manager::COLOR,
						'default'   => 'rgba(36, 44, 94, 0.8)',
						'selectors' => [
							'{{WRAPPER}} .teacher-2 .teacher-container .teacher-block .teacher-image:before' => ' background-color: {{VALUE}};',
						],
					]
				);



		$this->end_controls_section();


	}

	protected function render() {
		require EDUMODO_CORE_ROOT . '/elements/teacher-2/template/view.php';
	}


}
