<?php


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Color;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor edumodo Teacher 1
 *
 * Elementor widget for Teacher 1
 *
 * @since 1.0.0
 */
class Edumodo_Teachers_1 extends Widget_Base {

	public function get_name() {
		return 'edumodo-teacher-1';
	}

	public function get_title() {
		return __( 'Teacher 1', 'edumodo' );
	}

	public function get_icon() {
		return 'eicon-person';
	}

	public function get_categories() {
		return [ 'edumodo' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
	public function get_script_depends() {
		return [ 'edumodo-teacher-1' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'section_icon',
			[
				'label' => __( 'Content', 'edumodo' ),
			]
		);

        $this->add_control(
            'posts_per_page',
            [
                'label' => __('Item to Show', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 6,
                'min' => -1,
                'max' => 50,
                'step' => 1,
            ]
        );

        $this->add_control(
            'posts_column',
            [
                'label' => __('Columns to Show', 'edumodo'),
                'type' => Controls_Manager::SELECT,
                'default' => '4',
                'options' => [
                    '2'  => __('6', 'edumodo'),
                    '3'  => __('4', 'edumodo'),
                    '4'  => __('3', 'edumodo'),
                    '6'  => __('2', 'edumodo'),
                    '12' => __('1', 'edumodo'),
                ],
            ]
        );

		$this->end_controls_section();


		$this->start_controls_section(
			'section_style',
				[
					'label' => __( 'Content', 'edumodo' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			    $this->add_control(
	                'content_name_heading',
	                    [
	                        'label' => __( 'Name', 'edumodo' ),
	                        'type' => Controls_Manager::HEADING,
	                        'separator' => 'before',
	                    ]
	            );
				$this->add_control(
					'name_color',
					[
						'label'     => __( 'Color', 'edumodo' ),
						'type'      => Controls_Manager::COLOR,
						'default'   => '',
						'selectors' => [
							'{{WRAPPER}} .teacher-person .overlay .person-info .teacher-title a' => 'color: {{VALUE}};',
							// '{{WRAPPER}} .teacher-person .overlay .person-info .social-links-teacher i' => 'color: {{VALUE}};',
						],
					]
				);

        		$this->add_group_control(
		            Group_Control_Typography::get_type(),
		            [
		                'name' => 'title_typography',
		                'selector' => '{{WRAPPER}} .teacher-person .overlay .person-info .teacher-title a',
		                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
		            ]
		        );
		        $this->add_responsive_control(
					'edumodo_title_space',
						[
							'label' => __( 'Spacing', 'edumodo' ),
							'type' => Controls_Manager::SLIDER,
							'range' => [
								'px' => [
									'min' => 5,
									'max' => 50,
								],
							],
							'selectors' => [
								'{{WRAPPER}} .teacher-person .overlay .person-info .teacher-title' => 'margin: {{SIZE}}{{UNIT}} 0;',
							],
						]
				);
				$this->add_control(
	                'content_designation_heading',
	                    [
	                        'label' => __( 'Designation', 'edumodo' ),
	                        'type' => Controls_Manager::HEADING,
	                        'separator' => 'before',
	                    ]
	            );
	            $this->add_control(
					'designation_color',
					[
						'label'     => __( 'Color', 'edumodo' ),
						'type'      => Controls_Manager::COLOR,
						'default'   => '',
						'selectors' => [
							'{{WRAPPER}} .teacher-person .overlay .person-info .teacher-position' => 'color: {{VALUE}};',
						],
					]
				);

				$this->add_group_control(
		            Group_Control_Typography::get_type(),
		            [
		                'name' => 'designation_typography',
		                'selector' => '{{WRAPPER}} .teacher-person .overlay .person-info .teacher-position',
		                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
		            ]
		        );

		        $this->add_control(
	                'content_icon_heading',
	                    [
	                        'label' => __( 'Social Icon', 'edumodo' ),
	                        'type' => Controls_Manager::HEADING,
	                        'separator' => 'before',
	                    ]
	            );

				$this->add_control(
					'content_color',
					[
						'label'     => __( 'Color', 'edumodo' ),
						'type'      => Controls_Manager::COLOR,
						'default'   => '#fff',
						'selectors' => [
							'{{WRAPPER}} .teacher-person .overlay .person-info .social-links-teacher a' => 'color: {{VALUE}};',
							'{{WRAPPER}} .teacher-person .overlay .person-info .social-links-teacher i' => 'color: {{VALUE}};',
						],
					]
				);


				$this->add_responsive_control(
					'icon_size',
					[
						'label' => __( 'Size', 'edumodo' ),
						'type' => Controls_Manager::SLIDER,
						'default' => [
							'size' =>16,
						],
						'range' => [
							'px' => [
								'min' => 10,
								'max' => 60,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .teacher-person .overlay .person-info .social-links-teacher i' => 'font-size: {{SIZE}}{{UNIT}};',
						],
					]
				);

				$this->add_responsive_control(
					'icon_padding',
					[
						'label' => __( 'Padding', 'edumodo' ),
						'type' => Controls_Manager::SLIDER,
						'selectors' => [
							'{{WRAPPER}} .teacher-person .overlay .person-info .social-links-teacher a' => 'padding: {{SIZE}}{{UNIT}};',
						],
						'range' => [
							'em' => [
								'min' => 0,
								'max' => 30,
							],
						],
					]
				);

				$this->add_control(
	                'content_overlay_heading',
	                    [
	                        'label' => __( 'Global', 'edumodo' ),
	                        'type' => Controls_Manager::HEADING,
	                        'separator' => 'before',
	                    ]
	            );


				$this->add_control(
					'overlay_color',
					[
						'label'     => __( 'Overlay Color', 'edumodo' ),
						'type'      => Controls_Manager::COLOR,
						'default'   => 'rgba(36, 44, 94, 0.8)',
						'selectors' => [
							'{{WRAPPER}} .teacher-person .overlay' => ' background-color: {{VALUE}};',
						],
					]
				);

		$this->end_controls_section();





	}

	protected function render() {
		require EDUMODO_CORE_ROOT . '/elements/teacher-1/template/view.php';
	}


}
