<?php

    use Elementor\Widget_Base;
    use Elementor\Controls_Manager;
    use Elementor\Group_Control_Typography;
    use Elementor\Scheme_Typography;
    use Elementor\Utils;
    use Elementor\Group_Control_Image_Size;
    use Elementor\Repeater;
    use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor edumodo static testimonail
 *
 * Elementor widget for edumodo static testimonial
 *
 * @since 1.0.0
 */
class edumodo_static_testimonial extends Widget_Base {

	public function get_name() {
		return 'edumodo-static-testimonial';
	}

	public function get_title() {
		return __( 'Static Testimonial', 'edumodo' );
	}

	public function get_icon() {
		return 'eicon-testimonial';
	}

	public function get_categories() {
		return [ 'edumodo' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
	// public function get_script_depends() {
	// 	return [ 'edumodo-static-testimonial' ];
	// }

	protected function _register_controls() {
        $this->start_controls_section(
            'edumodo_testimonial_content_section',
            [
                'label' => __('Testimonial', 'edumodo'),
            ]
        );

            $this->add_control(
                'slider_on',
                [
                    'label' => esc_html__('Carousel', 'edumodo'),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                    'separator' => 'before',
                ]
            );

            $repeater = new Repeater();

            $repeater->add_control(
                'client_name',
                [
                    'label' => __('Name', 'edumodo'),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'default' => __('Johan Doe', 'edumodo'),

                ]
            );

            $repeater->add_control(
                'client_image',
                [
                    'label' => __('Image', 'edumodo'),
                    'type' => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src(),
                    ],
                ]
            );

            $repeater->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name' => 'client_imagesize',
                    'default' => 'large',
                    'separator' => 'none',
                ]
            );

            $repeater->add_control(
                'client_designation',
                [
                    'label' => __('Designation', 'edumodo'),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'default' => __('Managing Director', 'edumodo'),
                ]
            );

            $repeater->add_control(
                'client_say',
                [
                    'label' => __('Client Say', 'edumodo'),
                    'type' => Controls_Manager::TEXTAREA,
                    'default' => __('Lorem ipsum dolor sit amet consectetur adipisicing elit sed do eiusmod tempor incididunt ut labore et dolore Lorem ipsum dolor sit amet.', 'edumodo'),
                ]
            );

            $this->add_control(
                'edumodo_testimonial_list',
                [
                    'type' => Controls_Manager::REPEATER,
                    'fields' => array_values($repeater->get_controls()),
                    'default' => [

                        [
                            'client_name' => __('Name 1', 'edumodo'),
                            'client_designation' => __('Degree 1', 'edumodo'),
                            'client_say' => __('Lorem ipsum dolor sit amet consectetur adipisicing elit sed do eiusmod tempor incididunt ut labore et dolore Lorem ipsum dolor sit amet. It is a very good course for those who are the beginner. luck with the new studies!', 'edumodo'),
                        ],

                        [
                            'client_name' => __('Name 2', 'edumodo'),
                            'client_designation' => __('Degree 2', 'edumodo'),
                            'client_say' => __('Lorem ipsum dolor sit amet consectetur adipisicing elit sed do eiusmod tempor incididunt ut labore et dolore Lorem ipsum dolor sit amet. It is a very good course for those who are the beginner. luck with the new studies!', 'edumodo'),
                        ],

                        [
                            'client_name' => __('Name 3', 'edumodo'),
                            'client_designation' => __('Degree 3', 'edumodo'),
                            'client_say' => __('Lorem ipsum dolor sit amet consectetur adipisicing elit sed do eiusmod tempor incididunt ut labore et dolore Lorem ipsum dolor sit amet. It is a very good course for those who are the beginner. luck with the new studies!', 'edumodo'),
                        ],
                    ],
                    'title_field' => '{{{ client_name }}}',
                ]
            );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'client_image_divider_size',
                'default' => 'large',
                'separator' => 'none',
            ]
        );

    $this->end_controls_section();


    // Style Testimonial image style start
    $this->start_controls_section(
        'edumodo_testimonial_style',
        [
            'label' => __('Style', 'edumodo'),
            'tab' => Controls_Manager::TAB_STYLE,
        ]
    );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'edumodo_testimonial_style_border',
                'label' => __('Border', 'edumodo'),
                'selector' => '{{WRAPPER}} .edumodo-testi-2 .testi-img img',
            ]
        );

        $this->add_responsive_control(
            'edumodo_testimonial_style_border_radius',
            [
                'label' => esc_html__('Border Radius', 'edumodo'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .edumodo-testi-2 .testi-img img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                ],
            ]
        );
        $this->add_responsive_control(
            'edumodo_testimonial_style_padding',
            [
                'label' => __('Padding', 'edumodo'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-testi-2 .edumodo-testi-single' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

    $this->end_controls_section(); // Style Testimonial image style end


    // Style Testimonial image style start
    $this->start_controls_section(
        'edumodo_testimonial_image_style',
        [
            'label' => __('Image', 'edumodo'),
            'tab' => Controls_Manager::TAB_STYLE,
        ]
    );
        $this->add_control(
            'edumodo_testimonial_image_size',
            [
                'label' => __('Image Size', 'edumodo'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 50,
                        'max' => 300,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-testi-2 .testi-img' => 'max-width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .edumodo-testi-2 .testi-img img' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'edumodo_testimonial_image_border',
                'label' => __('Border', 'edumodo'),
                'selector' => '{{WRAPPER}} .edumodo-testi-2 .testi-img img',
            ]
        );

        $this->add_responsive_control(
            'edumodo_testimonial_image_border_radius',
            [
                'label' => esc_html__('Border Radius', 'edumodo'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .edumodo-testi-2 .testi-img img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                ],
            ]
        );

    $this->end_controls_section(); 

    $this->start_controls_section(
        'edumodo_testimonial_desc_style',
        [
            'label' => __('Description', 'edumodo'),
            'tab' => Controls_Manager::TAB_STYLE,
        ]
    );
        $this->add_control(
            'testi_desc_color',
            [
                'label' => __('Color', 'edumodo'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .testimonial-cont p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'edumodo_testimonial_desc_typography',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                'selector' => '{{WRAPPER}} .testimonial-cont p',
            ]
        );

        $this->add_responsive_control(
            'edumodo_testimonial_desc_padding',
            [
                'label' => __('Padding', 'edumodo'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-cont p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

    $this->end_controls_section(); // Style Testimonial name style end

    $this->start_controls_section(
        'edumodo_testimonial_name_style',
        [
            'label' => __('Name', 'edumodo'),
            'tab' => Controls_Manager::TAB_STYLE,
        ]
    );
        $this->add_control(
            'testi_name_color',
            [
                'label' => __('Color', 'edumodo'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .edumodo-testi-single .testimonial-cont .name' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'edumodo_testimonial_name_typography',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                'selector' => '{{WRAPPER}} .edumodo-testi-single .testimonial-cont .name',
            ]
        );

        $this->add_responsive_control(
            'edumodo_testimonial_name_padding',
            [
                'label' => __('Padding', 'edumodo'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-testi-single .testimonial-cont .name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

    $this->end_controls_section(); // Style Testimonial name style end

    // Style Testimonial designation style start
    $this->start_controls_section(
        'edumodo_testimonial_designation_style',
        [
            'label' => __('Degree', 'edumodo'),
            'tab' => Controls_Manager::TAB_STYLE,
        ]
    );

        $this->add_control(
            'edumodo_testimonial_designation_color',
            [
                'label' => __('Color', 'edumodo'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .edumodo-testi-single .testimonial-cont .degree' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'edumodo_testimonial_designation_typography',
                'scheme' => Scheme_Typography::TYPOGRAPHY_2,
                'selector' => '{{WRAPPER}} .edumodo-testi-single .testimonial-cont .degree',
            ]
        );

        $this->add_responsive_control(
            'edumodo_testimonial_designation_padding',
            [
                'label' => __('Padding', 'edumodo'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-testi-single .testimonial-cont .degree' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

    $this->end_controls_section(); // Style Testimonial designation style end


    // Style Testimonial Dots style start
    $this->start_controls_section(
        'edumodo_testimonial_dots_style',
        [
            'label' => __('Dot', 'edumodo'),
            'tab' => Controls_Manager::TAB_STYLE,
        ]
    );

        $this->start_controls_tabs('testimonial_dots_style_tabs');

            // Normal tab Start
            $this->start_controls_tab(
                'testimonial_dots_style_normal_tab',
                [
                    'label' => __('Normal', 'edumodo'),
                ]
            );
                $this->add_control(
                    'edumodo_testimonial_dot_color',
                    [
                        'label' => __('Color', 'edumodo'),
                        'type' => Controls_Manager::COLOR,
                        'default' => '',
                        'selectors' => [
                            '{{WRAPPER}} .edumodo-testi-2 button.owl-dot' => 'background-color: {{VALUE}};',
                        ],
                    ]
                );
        $this->end_controls_tab(); // Normal tab end

        // Hover tab Start
        $this->start_controls_tab(
            'testimonial_dots_style_hover_tab',
            [
                'label' => __('Active', 'edumodo'),
            ]
        );
                $this->add_control(
                    'edumodo_testimonial_dot_active_color',
                    [
                        'label' => __('Color', 'edumodo'),
                        'type' => Controls_Manager::COLOR,
                        'default' => '',
                        'selectors' => [
                            '{{WRAPPER}} .edumodo-testi-2 button.owl-dot.active' => 'background-color: {{VALUE}};',
                        ],
                    ]
                );
        $this->end_controls_tab(); // Hover tab end

    $this->end_controls_tabs();

        $this->add_responsive_control(
            'dot_size',
            [
                'label' => __('Dot Size', 'edumodo'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 5,
                        'max' => 40,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-testi-2 button.owl-dot' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'dot_position',
            [
                'label' => __('Position', 'edumodo'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 180,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-testi-2 button.owl-dot' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'dot_space_between',
            [
                'label' => __('Space Between', 'edumodo'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-testi-2 button.owl-dot' => 'margin-left: {{SIZE}}{{UNIT}}; margin-right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

    $this->end_controls_section(); // Style Testimonial dots style end

	}

    protected function render( $instance = [] ) { ?>
	<?php
        $settings   = $this->get_settings_for_display();

        $slider_settings = [
            // 'arrows' => ('yes' === $settings['slarrows']),
            // 'arrow_prev_txt' => $settings['slprevicon'],
            // 'arrow_next_txt' => $settings['slnexticon'],
            // 'dots' => ('yes' === $settings['sldots']),
            // 'autoplay' => ('yes' === $settings['slautolay']),
            // 'autoplay_speed' => absint($settings['slautoplay_speed']),
            // 'animation_speed' => absint($settings['slanimation_speed']),
            // 'pause_on_hover' => ('yes' === $settings['slpause_on_hover']),
            // 'center_mode' => ('yes' === $settings['slcentermode']),
            // 'center_padding' => absint($settings['slcenterpadding']),
        ];

        $slider_responsive_settings = [
            // 'display_columns' => $settings['slitems'],
            // 'scroll_columns' => $settings['slscroll_columns'],
            // 'tablet_width' => $settings['sltablet_width'],
            // 'tablet_display_columns' => $settings['sltablet_display_columns'],
            // 'tablet_scroll_columns' => $settings['sltablet_scroll_columns'],
            // 'mobile_width' => $settings['slmobile_width'],
            // 'mobile_display_columns' => $settings['slmobile_display_columns'],
            // 'mobile_scroll_columns' => $settings['slmobile_scroll_columns'],

        ];

        $slider_settings = array_merge($slider_settings, $slider_responsive_settings);

        if ($settings['slider_on'] == 'yes') {
            $this->add_render_attribute('testimonial_area_attr', 'class', 'edumodo-testi-2 edumodo-testimonial-activation');
            $this->add_render_attribute('testimonial_area_attr', 'data-settings', wp_json_encode($slider_settings));
        } ?>

	<script>
    jQuery(document).ready(function ($) {
        jQuery(".edumodo-testimonial-activation")
            .addClass("owl-carousel")
            .owlCarousel({
				loop:true,
				stagePadding: 10,
				margin: 30,
				responsive:{
					0:{
						items:1
					},
					600:{
						items:2
					},
					1000:{
						items:2
				}
				}
		});
    });

	</script>

        <div <?php echo $this->get_render_attribute_string('testimonial_area_attr'); ?>>
            <?php foreach ($settings['edumodo_testimonial_list'] as $testimonial) :?>
                <div class="edumodo-testi-single">
                    <div class="testimonial-cont">
                        <?php
                            if (!empty($testimonial['client_say'])) {
                                echo '<p>'.esc_html__($testimonial['client_say'], 'edumodo').'</p>';
							} ?>
							<div class="testimonial-profile">

								<?php
								if (!empty($testimonial['client_image']['url'])) {
									echo '<div class="testi-img">'.Group_Control_Image_Size::get_attachment_image_html($testimonial, 'client_imagesize', 'client_image').'</div>';
								} ?>

								<div class="testi-info">
									<?php if (!empty($testimonial['client_name'])) {
										echo '<h3 class="name">'.esc_html__($testimonial['client_name'], 'edumodo').'</h3>';
									}
									if (!empty($testimonial['client_designation'])) {
										echo '<p class="degree">'.esc_html__($testimonial['client_designation'], 'edumodo').'</p>';
									} ?>
								</div>

							</div>

                    </div>
                </div> 
            <?php endforeach; ?>
        </div> 

        <?php
    }

}
