<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Edumodo Slider Pro
 *
 * Elementor widget for edumodo slider Pro
 *
 * @since 1.0.0
 */
class Edumodo_Slider_Pro_Widget extends Widget_Base {

	public function get_name() {
		return 'edumodo-slider-pro';
	} 

	public function get_title() {
		return __( 'Edumodo Slider Pro', 'edumodo' );
	}

	public function get_icon() {
		return 'eicon-post-slider';
	}

	public function get_categories() {
		return [ 'edumodo' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
	public function get_script_depends() {
		return [ 'edumodo-slider-pro' ];
	}

	protected function _register_controls() {

	$this->start_controls_section(
		'section_content',
		[
			'label' => __( 'Slides', 'edumodo' ),
		]
	);
	$repeater = new Repeater();


//======================================================================
// Slider Background
//======================================================================
$repeater->start_controls_tabs( 'reperter_tabs_bg_title_content' );


	//======================================================================
	// Slider background repeater
	//======================================================================

$repeater->start_controls_tab( 'slider_backgroud_tab', [ 'label' => __( 'Background', 'edumodo' ) ] );

		$repeater->add_control(
			'slider_image',
			[
				'label' => __( 'Choose Image', 'edumodo' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);


$repeater->end_controls_tab();

//======================================================================
// Slider tab content
//======================================================================

$repeater->start_controls_tab( 'slider_content_tab', [ 'label' => __( 'Content', 'edumodo' ) ] );

		$repeater->add_control(
			'slider_content_id',
			[
				'label' => __( 'Content', 'edumodo' ),
				'type' => Controls_Manager::CHOOSE,
				//'label_block' => false,
				'options' => [
					'icon_slide_title' => [
						'title' => __( 'Title', 'edumodo' ),
						'icon' => 'fa fa-text-width',
					],

					'icon_slide_content' => [
						'title' => __( 'Content', 'edumodo' ),
						'icon' => 'fa fa-file-powerpoint-o',
					],
					'icon_font_image' => [
						'title' => __( 'Front Image', 'edumodo' ),
						'icon' => 'fa fa-picture-o',
					],
				],
				'default' => 'icon_slide_title',
			]
		);

	//======================================================================
	// Slider title repeater
	//======================================================================

		 $repeater->add_control(
		    'title',
		      	[
		          'label' => __( 'Slide Title', 'edumodo' ),
		          'type'  => Controls_Manager::TEXTAREA,
		          'default' => __( 'Your bright future is <br><span>Our mission</span>', 'edumodo' ),
		          'label_block' => true,
		          'condition' => [
					 'slider_content_id' => 'icon_slide_title',
				  ],
		    	]
	    );

		$repeater->add_control(
			'slider_content',
			[
				'label' => '',
				'type' => Controls_Manager::WYSIWYG,
				'default' => __( 'I am slide content. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leor', 'edumodo' ),
				'condition' => [
				    'slider_content_id' => 'icon_slide_content',
				]
			]

		);

		$repeater->add_control(
	       'slider_front_image',
		        [
		          'label' => __( 'Choose Front Image', 'edumodo' ),
		          'type'  => Controls_Manager::MEDIA,
				  'default' => [
					'url' => Utils::get_placeholder_image_src(),
				  ],
				'condition' => [
				    'slider_content_id' => 'icon_font_image',
				]
		        ]
	    );


	$repeater->end_controls_tab();

//======================================================================
// Slider tab button
//======================================================================
	$repeater->start_controls_tab( 'slider_button_tab', [ 'label' => __( 'Button', 'edumodo' ) ] );

	//======================================================================
	// Slider btn tab one
	//======================================================================
	    $repeater->add_control(
			'btn_one_enable',
			[
				'label' => __( 'Enable Button', 'edumodo' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => '',
				'label_on' => __( 'Show', 'edumodo' ),
				'label_off' => __( 'Hide', 'edumodo' ),
				'return_value' => 'yes',
			]
		);

		$repeater->add_control(
			'btn_text',
			[
				'label' => __( 'Button Text', 'edumodo' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Explore More', 'edumodo' ),
				'placeholder' => __( 'Explore More', 'edumodo' ),
				'conditions' => [
					'terms' => [
						[
							'name' => 'btn_one_enable',
							'operator' => '==',
							'value' => 'yes',
						],
					],
				],
			]
		);
		
		$repeater->add_control(
			'link',
			[
				'label' => __( 'Link', 'edumodo' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'edumodo' ),
				'default' => [
					'url' => '#',
				],
				'conditions' => [
					'terms' => [
						[
							'name' => 'btn_one_enable',
							'operator' => '==',
							'value' => 'yes',
						],
					],
				],
			]
		);

		$repeater->add_control(
			'icon',
			[
				'label' => __( 'Icon', 'edumodo' ),
				'type' => Controls_Manager::ICON,
				'label_block' => true,
				'default' => '',
				'conditions' => [
					'terms' => [
						[
							'name' => 'btn_one_enable',
							'operator' => '==',
							'value' => 'yes',
						],
					],
				],
			]
		);

		$repeater->add_control(
			'icon_align',
			[
				'label' => __( 'Icon Position', 'edumodo' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'left',
				'options' => [
					'left' => __( 'Before', 'edumodo' ),
					'right' => __( 'After', 'edumodo' ),
				],
				'condition' => [
					'icon!' => '',
					'terms' => [
						[
							'name' => 'btn_one_enable',
							'operator' => '==',
							'value' => 'yes',
						],
					],
				],
			]
		);

		$repeater->add_control(
			'icon_indent',
			[
				'label' => __( 'Icon Spacing', 'edumodo' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 50,
					],
				],
				'condition' => [
					'icon!' => '',
					'terms' => [
						[
							'name' => 'btn_one_enable',
							'operator' => '==',
							'value' => 'yes',
						],
					],
				],
				'selectors' => [
					'{{WRAPPER}} .slider-btn-area .slider-btn-one .elementor-button .elementor-align-icon-right' => 'margin-left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .slider-btn-area .slider-btn-one .elementor-button .elementor-align-icon-left' => 'margin-right: {{SIZE}}{{UNIT}};',
				],
			]
		);


	$repeater->end_controls_tabs();

		$this->add_control(
		    'slider_option',
		      [
		          'label'       => __( 'Slider Options', 'edumodo' ),
		          'type'        => Controls_Manager::REPEATER,
		          'show_label'  => true,
		          'default'     => [
		              [
		                'title' => __( 'Your bright future is <span>Our mission</span>', 'edumodo' ),
		                'slider_content' => 'I am slide content. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo',
		                'slider_image' => '',
		                'btn-text' => 'Read More',
		                'btn-link' => '#',
		                'title_animation' => 'fadeInDown',
		                'content_animation' => 'fadeInDown',
		                'btn_animation' => 'fadeInDown',
		 
		              ]
		          ],
		          'fields'      => array_values( $repeater->get_controls() ),
		          'title_field' => '{{{title}}}',
		      ]
		  );

$this->end_controls_section();

//======================================================================
// Slider Title
//======================================================================

$this->start_controls_section(
	'title_style',
		[
			'label' => __( 'Title', 'edumodo' ),
			'tab'   => Controls_Manager::TAB_STYLE,
		]
);
		$this->add_control(
			'title_color',
				[
					'label'     => __( 'Color', 'edumodo' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '#fff',
					'selectors' => [
						'{{WRAPPER}} .edumodo-hero-unit.edumodo-slider-pro .carousel .carousel-inner .item .carousel-caption .slider-title' => 'color: {{VALUE}};',
					],
				]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
				[
					'name'     => 'title_typography',
					'label'    => __( 'Typography', 'edumodo' ),
					'scheme'   => Scheme_Typography::TYPOGRAPHY_4,
					'selector' => '{{WRAPPER}} .edumodo-hero-unit.edumodo-slider-pro .carousel .carousel-inner .item .carousel-caption .slider-title',
				]
		);

		$this->add_control(
			'title_span_color',
				[
					'label'     => __( 'Span Color', 'edumodo' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '#ecb101',
					'selectors' => [
						'{{WRAPPER}} .carousel .carousel-inner .carousel-caption .slider-title span' => 'color: {{VALUE}};',
					],
				]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
				[
					'name'     => 'title_span_typography',
					'label'    => __( 'Span Typography', 'edumodo' ),
					'scheme'   => Scheme_Typography::TYPOGRAPHY_4,
					'selector' => '{{WRAPPER}} .carousel .carousel-inner .carousel-caption .slider-title span',
				]
		);

        $this->add_responsive_control(
            'title_padding',
            [
                'label' => __( 'Padding', 'edumodo' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-hero-unit.edumodo-slider-pro .carousel .carousel-inner .item .carousel-caption .slider-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );
$this->end_controls_section();

//======================================================================
// Slider Content Style
//======================================================================


$this->start_controls_section(
	'content_style',
		[
			'label' => __( 'Content', 'edumodo' ),
			'tab'   => Controls_Manager::TAB_STYLE,
		]
);

		$this->add_control(
			'content_color',
				[
					'label'     => __( 'Color', 'edumodo' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '#fff',
					'selectors' => [
						'{{WRAPPER}} .carousel .carousel-inner .carousel-caption .slider-description' => 'color: {{VALUE}};',
					],
				]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
				[
					'name'     => 'content_typography',
					'label'    => __( 'Typography', 'edumodo' ),
					'scheme'   => Scheme_Typography::TYPOGRAPHY_4,
					'selector' => '{{WRAPPER}} .carousel .carousel-inner .carousel-caption .slider-description',
				]
		);
		$this->add_responsive_control(
			'content_spacing',
				[
					'label'  => __( 'Spacing', 'edumodo' ),
					'type'   => Controls_Manager::SLIDER,
					'default' => [
		                'size' => 20,
		            ],
					'range'  => [
						'px' => [
							'min' => -20,
							'max' => 50,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .carousel .carousel-inner .carousel-caption .slider-description' => 'padding-top: {{SIZE}}{{UNIT}};',
					],
				]
			);

        $this->add_responsive_control(
            'desc_padding',
            [
                'label' => __( 'Padding', 'edumodo' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .carousel .carousel-inner .item .carousel-caption .slider-description' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

$this->end_controls_section();
//======================================================================
// Slider Global Options 
//======================================================================

$this->start_controls_section(
	'section_option',
		[
			'label' => __( 'Global Options', 'edumodo' ),
		]
);

    $this->add_responsive_control(
		'slider_height',
			[
				'label'  => __( 'Slider Height', 'edumodo' ),
				'type'   => Controls_Manager::SLIDER,
				'description'   => __( 'Default 100vh (Blank value for difault)', 'edumodo' ),
				'range'  => [
					'px' => [
						'min' => 400,
						'max' => 1500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .edumodo-hero-unit.edumodo-slider-pro .carousel .carousel-inner .item' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
	);

    $this->add_responsive_control(
		'caption_position',
			[
				'label'  => __( 'Caption Position', 'edumodo' ),
				'type'   => Controls_Manager::SLIDER,
				'default' => [
                    'size' => 200,
                ],
				'range'  => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .edumodo-hero-unit.edumodo-slider-pro .carousel .carousel-inner .item .carousel-caption' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
	);

	$this->add_responsive_control(
         'content_align',
	         [
	           'label' => __( 'Content Alignment', 'edumodo' ),
	           'type' => Controls_Manager::CHOOSE,
	           'default'   => 'left',
	           'options' => [
	             'left' => [
	               'title' => __( 'Left', 'edumodo' ),
	               'icon' => 'fa fa-align-left',
	             ],
	             'center' => [
	               'title' => __( 'Center', 'edumodo' ),
	               'icon' => 'fa fa-align-center',
	             ],
	             'right' => [
	               'title' => __( 'Right', 'edumodo' ),
	               'icon' => 'fa fa-align-right',
	             ],
	             'justify' => [
	               'title' => __( 'Justified', 'edumodo' ),
	               'icon' => 'fa fa-align-justify',
	             ],
	           ],
	           'selectors' => [
	             '{{WRAPPER}} .edumodo-hero-unit.edumodo-slider-pro .carousel .carousel-inner .item .carousel-caption' => 'text-align: {{VALUE}};',
	           ],
         ]
   );

	$this->add_control(
		'slider_interval',
		[
			'label' => __( 'Slider Interval', 'edumodo' ),
			'type' => Controls_Manager::TEXT,
			'default' => '8000',
		]
	);

	$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'item_overlay_color',
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .carousel .carousel-inner .item:before',
			]
		);

		$this->add_control(
			'background_overlay_b',
			[
				'label' => __( 'Background Overlay', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .carousel .carousel-inner .item:before' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .edumodo-hero-unit.edumodo-slider-pro .carousel .carousel-control:before' => 'background-color: {{VALUE}};',
				],
				'separator' => 'before',
				'condition' => [
					'item_overlay_color_image[id]!' => '',
				],
			]
		);
		
	$this->add_control(
		'bg_repeat',
		[
			'label'     => __( 'Background Repeat', 'edumodo' ),
			'type'      => Controls_Manager::SELECT,
			'default'   => 'no-repeat',
			'options'   => [
				'no-repeat'  => __( 'No Repeat', 'edumodo' ),
				'repeat'     => __( 'Repeat', 'edumodo' ),
				'repeat-x'   => __( 'Repeat X', 'edumodo' ),
				'repeat-y'   => __( 'Repeat Y', 'edumodo' ),
				'inherit'    => __( 'Inherit', 'edumodo' ),
			],
			'selectors' => [
				'{{WRAPPER}} .edumodo-hero-unit.edumodo-slider-pro .carousel .item' => 'background-repeat: {{VALUE}};',
			],
		]
	);

	$this->add_control(
		'bg_size',
		[
			'label'     => __( 'Background Size', 'edumodo' ),
			'type'      => Controls_Manager::SELECT,
			'default'   => 'cover',
			'options'   => [
				'cover'     => __( 'cover', 'edumodo' ),
				'contain'   => __( 'contain', 'edumodo' ),
				'inherit'   => __( 'inherit', 'edumodo' ),
			],
			'selectors' => [
				'{{WRAPPER}} .edumodo-hero-unit.edumodo-slider-pro .carousel .item' => 'background-size: {{VALUE}};',
			],
		]
	);

	$this->add_control(
		'bg_position',
		[
			'label'     => __( 'Background Position', 'edumodo' ),
			'type'      => Controls_Manager::SELECT,
			'default'   => 'center center',
			'options'   => [
				'left top'     => __( 'left top', 'edumodo' ),
				'left center'     => __( 'left center', 'edumodo' ),
				'left bottom'     => __( 'left bottom', 'edumodo' ),
				'right top'     => __( 'right top', 'edumodo' ),
				'right center'     => __( 'right center', 'edumodo' ),
				'center top'     => __( 'center top', 'edumodo' ),
				'center'     => __( 'center', 'edumodo' ),
				'center center'     => __( 'center center', 'edumodo' ),
				'center bottom'     => __( 'center bottom', 'edumodo' ),
				'50% 50%'     => __( '50% 50%', 'edumodo' ),
				'25% 75%'     => __( '25% 75%', 'edumodo' ),
				'10px 200px'     => __( '10px 200px', 'edumodo' ),
				'50px 50px'     => __( '50px 50px', 'edumodo' ),
				'initial'   => __( 'initial', 'edumodo' ),
			],
			'selectors' => [
				'{{WRAPPER}} .edumodo-hero-unit.edumodo-slider-pro .carousel .item' => 'background-position: {{VALUE}};',
			],
		]
	);

	$this->add_control(
		'bg_attachment',
		[
			'label'     => __( 'Background Attachment', 'edumodo' ),
			'type'      => Controls_Manager::SELECT,
			'default'   => 'inherit',
			'options'   => [
				'fixed'    => __( 'fixed', 'edumodo' ),
				'inherit'  => __( 'Inherit', 'edumodo' ),
			],
			'selectors' => [
				'{{WRAPPER}} .edumodo-hero-unit.edumodo-slider-pro .carousel .item' => 'background-attachment: {{VALUE}};',
			],
		]
	);



	$this->end_controls_section();
//======================================================================
// Slider Nav
//======================================================================

	$this->start_controls_section(
		'nav_section_option',
			[
				'label' => __( 'Nav Options', 'edumodo' ),
			]
	);

	$this->add_control(
		'nav_enable',
			[
				'label'     => __( 'Nav Enable/Disable', 'edumodo' ),
				'type'      => Controls_Manager::SWITCHER,
				'default'   => 'yes',
				'enable'    => __( 'Enable', 'edumodo' ),
				'disable'   => __( 'Disable', 'edumodo' ),
			]
	);

	$this->add_control(
		'arrow_enable',
			[
				'label'     => __( 'Arrow Enable/Disable', 'edumodo' ),
				'type'      => Controls_Manager::SWITCHER,
				'default'   => 'yes',
				'enable'    => __( 'Enable', 'edumodo' ),
				'disable'   => __( 'Disable', 'edumodo' ),
			]
	);

	$this->add_control(
		'nav_color',
			[
				'label'     => __( 'Nav & Arrow Icon Color', 'edumodo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#fff',
				'selectors' => [
					'{{WRAPPER}} .edumodo-hero-unit.edumodo-slider-pro .carousel .carousel-control i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .edumodo-hero-unit.edumodo-slider-pro .carousel .carousel-indicators li' => 'background-color:{{VALUE}};',
					'{{WRAPPER}} .edumodo-hero-unit.edumodo-slider-pro .carousel .carousel-control' => 'border:1px solid {{VALUE}};',
				],
			]
	);

	$this->add_control(
		'nav_bg_color',
			[
				'label'     => __( 'Nav & Arrow Bg Color', 'edumodo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#ecb101',
				'selectors' => [
					'{{WRAPPER}} .edumodo-hero-unit.edumodo-slider-pro .carousel .carousel-indicators>li.active' => 'background: {{VALUE}};',
					'{{WRAPPER}} .edumodo-hero-unit.edumodo-slider-pro .carousel .carousel-indicators li.active' => 'border:1px solid {{VALUE}};',
					'{{WRAPPER}} .edumodo-hero-unit.edumodo-slider-pro  .carousel-control:hover' => 'border-color: {{VALUE}} !important;',
					'{{WRAPPER}} .edumodo-hero-unit.edumodo-slider-pro .carousel .carousel-control:hover' => 'background-color:{{VALUE}};',
				],
			]
	);


	$this->end_controls_section();

//======================================================================
// Button style one
//======================================================================
	$this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Button', 'edumodo' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'typography',
				'scheme' => Scheme_Typography::TYPOGRAPHY_4,
				'selector' => '{{WRAPPER}} .slider-btn-area .slider-btn-one a.elementor-button, {{WRAPPER}} .slider-btn-area .slider-btn-one .elementor-button',
			]
		);

		$this->start_controls_tabs( 'tabs_button_style' );

		$this->start_controls_tab(
			'tab_button_normal',
			[
				'label' => __( 'Normal', 'edumodo' ),
			]
		);

		$this->add_control(
			'button_text_color',
			[
				'label' => __( 'Text Color', 'edumodo' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .slider-btn-area .slider-btn-one a.elementor-button, {{WRAPPER}} .slider-btn-area .slider-btn-one .elementor-button' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'background_color',
			[
				'label' => __( 'Background Color', 'edumodo' ),
				'type' => Controls_Manager::COLOR,
				'scheme' => [
					'type' => Scheme_Color::get_type(),
					'value' => Scheme_Color::COLOR_4,
				],
				'selectors' => [
					'{{WRAPPER}} .slider-btn-area .slider-btn-one a.elementor-button, {{WRAPPER}} .slider-btn-area .slider-btn-one .elementor-button' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => __( 'Hover', 'edumodo' ),
			]
		);

		$this->add_control(
			'hover_color',
			[
				'label' => __( 'Text Color', 'edumodo' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .slider-btn-area .slider-btn-one a.elementor-button:hover, {{WRAPPER}} .slider-btn-area .slider-btn-one .elementor-button:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_background_hover_color',
			[
				'label' => __( 'Background Color', 'edumodo' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .slider-btn-area .slider-btn-one a.elementor-button:hover, {{WRAPPER}} .slider-btn-area .slider-btn-one .elementor-button:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_hover_border_color',
			[
				'label' => __( 'Border Color', 'edumodo' ),
				'type' => Controls_Manager::COLOR,
				'condition' => [
					'border_border!' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .slider-btn-area .slider-btn-one a.elementor-button:hover, {{WRAPPER}} .slider-btn-area .slider-btn-one .elementor-button:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'hover_animation',
			[
				'label' => __( 'Hover Animation', 'edumodo' ),
				'type' => Controls_Manager::HOVER_ANIMATION,
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'border',
				'placeholder' => '1px',
				'default' => '1px',
				'selector' => '{{WRAPPER}} .slider-btn-area .slider-btn-one .elementor-button',
				'separator' => 'before',
			]
		);

		$this->add_control(
			'border_radius',
			[
				'label' => __( 'Border Radius', 'edumodo' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .slider-btn-area .slider-btn-one a.elementor-button, {{WRAPPER}}  .slider-btn-area .slider-btn-one .elementor-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'button_box_shadow',
				'selector' => '{{WRAPPER}} .slider-btn-area .slider-btn-one .elementor-button',
			]
		);

		$this->add_control(
			'text_padding',
			[
				'label' => __( 'Text Padding', 'edumodo' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .slider-btn-area .slider-btn-one a.elementor-button, {{WRAPPER}}  .slider-btn-area .slider-btn-one .elementor-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'button_padding',
			[
				'label' => __( 'Padding', 'edumodo' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .slider-btn-area .slider-btn-one, {{WRAPPER}}  .slider-btn-area .slider-btn-one' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);

		$this->end_controls_section();

	//======================================================================
	// Front Image Options
	//======================================================================
	$this->start_controls_section(
		'font_image_options',
			[
				'label' => __( 'Front Image', 'edumodo' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
	);
	
		$this->add_responsive_control(
			'font_image_position',
				[
					'label'  => __( 'Front Image Position', 'edumodo' ),
					'type'   => Controls_Manager::SLIDER,
					'default' => [
	                    'size' => 200,
	                ],
					'range'  => [
						'px' => [
							'min' => 0,
							'max' => 1500,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .edumodo-hero-unit.edumodo-slider-pro .carousel .carousel-inner .item .carousel-caption.carousel-front-image' => 'top: {{SIZE}}{{UNIT}};',
					],
				]
		);


		$this->add_responsive_control(
			'image_size',
			[
				'label' => __( 'Image Size', 'edumodo' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 100,
					'unit' => '%',
				],
				'tablet_default' => [
					'unit' => '%',
				],
				'mobile_default' => [
					'unit' => '%',
				],
				'size_units' => [ '%' ],
				'range' => [
					'%' => [
						'min' => 5,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .edumodo-hero-unit.edumodo-slider-pro .carousel .carousel-inner .item .carousel-caption.carousel-front-image' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'front_image_padding',
			[
				'label' => __( 'Padding', 'edumodo' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .edumodo-hero-unit.edumodo-slider-pro .carousel .carousel-inner .item .carousel-caption.carousel-front-image' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);

	$this->end_controls_section();

	}

	protected function render() {
		require EDUMODO_CORE_ROOT . '/elements/slider-pro/template/view.php';
	}


}
