<?php
/**
 * Dynamic category
 * =================
 */
add_action( 'wp_ajax_nopriv_dynamicCat', 'sensei_dynamic_cat' );
add_action( 'wp_ajax_dynamicCat', 'sensei_dynamic_cat' );
if(! function_exists('sensei_dynamic_cat')){
    function sensei_dynamic_cat(){
        $cat_id = $_REQUEST['term_id'];
        $post_num_to_show = $_REQUEST['pn'];
        $regularThumbSize = $_REQUEST['rts'];
        $coursePrice = $_REQUEST['coursePrice'];
        $courseUser = $_REQUEST['courseUser'];
        $courseHeight = $_REQUEST['courseHeight'];
        $postsColumn = $_REQUEST['postsColumn'];
        $activeCarousel = $_REQUEST['activeCarousel'];
        $excerpt_title_word = 15;
        $excerpt_desc_word = 15;


        /**
         * Argument
         * for query post
         * ================
         */
        $count = 0;
        $args = array(
            'post_type' =>  'course',
            'posts_per_page' => $post_num_to_show,
            'tax_query' => array(
                array(
                    'taxonomy' => 'course-category',
                    'field' => 'term_id',
                    'terms'    => $cat_id
                ),
            ),
        );

        $query = new WP_Query($args);
        ?>
        <div
            data-coursePrice="<?php echo $coursePrice; ?>"
            data-courseUser="<?php echo $courseUser; ?>"
            data-postsColumn="<?php echo $postsColumn; ?>"
            data-activeCarousel="<?php echo $activeCarousel; ?>"
            class="cat-post-list dynamic-cat-post-list animated fadeIn">
            <div id="lp-dynamic-course-carousel" class="edumodo-lp-course-1 edumodo-sensei-course <?php echo $activeCarousel ? 'lp-dynamic-course-active owl-carousel' : ''; ?>">
                <?php

                if($query->have_posts()):
                    while($query->have_posts()):
                        $query->the_post();

                        ?>
 
                        <div class="<?php echo $activeCarousel ? 'col-md-12 ': '' ;?>  col-sm-<?php echo $postsColumn; ?>">
                            <article id="post-<?php the_ID(); ?>" <?php post_class('lp-course-1'); ?>>
                                <?php if ( has_post_thumbnail() ):?>
                                    <figure class="lp-course-thumbnail">
                                       <div class="lp-img">
                                            <a href="<?php the_permalink(); ?>">
                                                <?php  the_post_thumbnail();?>
                                            </a>
                                       </div>
                                    <?php if($coursePrice == 'yes'): ?>
                                        <div class="author-wrapper">
                                            <div class="tx-author-img"><?php echo get_avatar( get_the_author_meta( 'ID' ), 55 ); ?></div>
                                        </div>
                                    <?php endif; ?>
                                    </figure>
                                <?php endif; ?>

                                <div class="course-content-body">

                                    <header class="entry-header">
                                        <h4 class="course-entry-title">
                                            <a href="<?php the_permalink();?>">
                                                <?php esc_html_e(wp_trim_words( get_the_title(), $excerpt_title_word, ''), 'edumodo'); ?>                         
                                            </a>
                                        </h4>       
                                    </header><!-- .entry-header -->

                                    <?php if ($query):?>
                                        <div class="entry-content">
                                            <p><?php esc_html_e(wp_trim_words( get_the_excerpt(), $excerpt_desc_word, ''), 'edumodo'); ?></p>
                                        </div><!-- .entry-content -->
                                    <?php endif; ?>

                                    <footer class="entry-footer">
                                          <div class="footer-body">
                                            <span class="lp-enroll">
                                                <i class="glyph-icon flaticon-play-button"></i>
                                                <?php echo Sensei()->course->course_lesson_count( get_the_ID() ) . '&nbsp;' . esc_html__( 'Lessons', 'edumodo' ); ?>

                                            </span>
                               
                                            <span class="sensei-er-btn">
                                                <a href="<?php the_permalink();?>"><?php esc_html_e('Enroll', 'edumodo') ?></a>   
                                            </span>
                                        </div><!-- .entry-meta -->
                                    </footer>
                                </div><!-- .course details -->

                            </article><!-- #post-## -->
                        </div>
                        <?php
                        $count++;
                    endwhile; wp_reset_postdata();
                endif;

                ?>
            </div>
        </div>
        <!--cat-post-list-->
        <?php
        //wp_reset_query();
        die();
    }
}
