<?php
// Silence is golden.

    $settings = $this->get_settings();

    // Global Options
    global $post;
     // Prefix
    $prefix = '_edumodo_';
    
    // Prefix
    $show_hide_lp_instructor = $settings['show_hide_lp_instructor'];
    $excerpt_title_word = $settings['excerpt_title_word'];
    $excerpt_desc_word = $settings['excerpt_desc_word'];

?>

    <div class="edumodo-lp-course-1 edumodo-sensei-course">
         <div class="row">
                <?php
                    $course = array(
                        'post_type'         => 'course',
                        'posts_per_page'    => $settings['posts_per_page'],
                        // 'meta_key'       => '_edumodo_course_start_date',
                        'orderby'        => $settings['orderby'],
                        'order'          => $settings['order'],
                    );

                    $course_query = new WP_Query( $course );
                        if($course_query->have_posts()):
                            while($course_query->have_posts()): 
                                $course_query->the_post(); 
                ?>

                <div class="course-content-wrapper col-md-<?php echo $settings['posts_column']; ?> col-sm-6 sensei-nth-class">
                    <article id="post-<?php the_ID(); ?>" <?php post_class('lp-course-1'); ?>>
                        <?php if ( has_post_thumbnail() ):?>
                            <figure class="lp-course-thumbnail">
                               <div class="lp-img">
                                    <a href="<?php the_permalink(); ?>">
                                        <?php  the_post_thumbnail();?>
                                    </a>
                               </div>
                            <?php if($show_hide_lp_instructor == 'yes'): ?>
                                <div class="author-wrapper">
                                    <div class="tx-author-img"><?php echo get_avatar( get_the_author_meta( 'ID' ), 55 ); ?></div>
                                </div>
                            <?php endif; ?>
                            </figure>
                        <?php endif; ?>

                        <div class="course-content-body">

                            <header class="entry-header">
                                <h4 class="course-entry-title">
                                    <a href="<?php the_permalink();?>">
                                        <?php esc_html_e(wp_trim_words( get_the_title(), $excerpt_title_word, ''), 'edumodo'); ?>                         
                                    </a>
                                </h4>       
                            </header><!-- .entry-header -->

                            <?php if ($course_query):?>
                                <div class="entry-content">
                                    <p><?php esc_html_e(wp_trim_words( get_the_excerpt(), $excerpt_desc_word, ''), 'edumodo'); ?></p>
                                </div><!-- .entry-content -->
                            <?php endif; ?>

                            <footer class="entry-footer">
                                  <div class="footer-body">
                                    <span class="lp-enroll">
                                        <i class="glyph-icon flaticon-play-button"></i>
                                        <?php echo Sensei()->course->course_lesson_count( get_the_ID() ) . '&nbsp;' . esc_html__( 'Lessons', 'edumodo' ); ?>

                                    </span>
                       
                                    <span class="sensei-er-btn">
                                        <a href="<?php the_permalink();?>"><?php esc_html_e('Enroll', 'edumodo') ?></a>   
                                    </span>
                                </div><!-- .entry-meta -->
                            </footer>
                        </div><!-- .course details -->

                    </article><!-- #post-## -->
                </div> <!-- /.col-md-4 -->

            <?php endwhile; wp_reset_postdata(); endif; ?>
        </div><!-- /.row -->     
    </div> <!-- /.div -->
