<?php


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Edumodo course
 *
 * Elementor widget for edumodo course
 *
 * @since 1.0.0
 */
class Edumodo_Widget_Sensei_Course extends Widget_Base {

	public function get_name() {
		return 'edumodo-sensei-course';
	}

	public function get_title() {
		return __( 'Sensei Courses', 'edumodo' );
	}

	public function get_icon() {
		return 'eicon-sidebar';
	}

	public function get_categories() {
		return [ 'edumodo' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function _register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'edumodo' ),
			]
		);

        $this->add_control(
            'posts_per_page',
            [
                'label' => __('Item to Show', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 8,
                'min' => -1,
                'max' => 50,
                'step' => 1,
            ]
        );

        $this->add_control(
            'posts_column',
            [
                'label' => __('Column', 'edumodo'),
                'type' => Controls_Manager::SELECT,
                'default' => '3',
                'options' => [
                    '2' => __('6 Column', 'edumodo'),
                    '3' => __('4 Column', 'edumodo'),
                    '4' => __('3 Column', 'edumodo'),
                    '6' => __('2 Column', 'edumodo'),
                    '12' => __('1 Column', 'edumodo'),
                ],
            ]
        );
        $this->add_control(
            'order',
            [
                'label' => __('Order', 'edumodo'),
                'type' => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => [
                    'ASC' => __('Ascending', 'edumodo'),
                    'DESC' => __('Descending', 'edumodo'),
                ],
            ]
        );

        $this->add_control(
            'orderby',
            [
                'label' => __('Order By', 'edumodo'),
                'type' => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'title' => __('Title', 'edumodo'),
                    'name' => __('Name', 'edumodo'),
                    'date' => __('Date', 'edumodo'),
                    'rand' => __('Random', 'edumodo'),
                ],
            ]
        ); 
        $this->add_responsive_control(
            'fixed_height',
            [
                'label' => __( 'Column Height', 'edumodo' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 150,
                        'max' => 600,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-lp-course-1 .lp-course-1' => 'max-height: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

		$this->end_controls_section();

        $this->start_controls_section(
            'edumodo_section_title_typography',
            [
                'label' => __( 'Title', 'edumodo' ),
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'edumodo_title_typography',
                'selector' => '{{WRAPPER}} .edumodo-lp-course-1 .lp-course-1 .course-content-body .course-entry-title a',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );
        $this->add_control(
            'excerpt_title_word',
            [
                'label' => __('Excerpt Title Word', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 15,
                'min' => 5,
                'max' => 150,
                'step' => 1,
            ]
        );
        $this->end_controls_section();

		$this->start_controls_section(
			'edumodo_section_desc_typography',
			[
				'label' => __( 'Content', 'edumodo' ),
			]
		);

       	$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'edumodo_desc_typography',
                'selector' => '{{WRAPPER}} .edumodo-lp-course-1 .lp-course-1 .course-content-body .entry-content',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );

        $this->add_control(
            'excerpt_desc_word',
            [
                'label' => __('Excerpt Description Word', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 15,
                'min' => 5,
                'max' => 150,
                'step' => 1,
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'section_meta',
			[
				'label' => __( 'Meta', 'edumodo' ),
			]
		);

       	$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'meta_title_typography',
                'selector' => '{{WRAPPER}} .edumodo-course-1 header a',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );

        $this->add_control(
            'show_hide_lp_instructor',
            [
                'label' => __( 'Show Instructor', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
            ]
        );

		$this->end_controls_section();

        $this->start_controls_section(
            'section_style_cat',
                [
                    'label' => __( 'Categorie', 'edumodo' ),
                    'tab'   => Controls_Manager::TAB_STYLE,
                ]
            );


        $this->add_control(
            'meta_cat_color',
            [
                'label'     => __( 'Color 1', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .edumodo-sensei-course .sensei-er-btn a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'meta_bg_color',
            [
                'label'     => __( 'Background 1', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .edumodo-sensei-course .sensei-er-btn a' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'meta_cat_color_2',
            [
                'label'     => __( 'Color 2', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .edumodo-sensei-course .sensei-nth-class:nth-child(6n+2) .sensei-er-btn a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'meta_bg_color_2',
            [
                'label'     => __( 'Background 2', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .edumodo-sensei-course .sensei-nth-class:nth-child(6n+2) .sensei-er-btn a' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'meta_cat_color_3',
            [
                'label'     => __( 'Color 3', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .edumodo-sensei-course .sensei-nth-class:nth-child(6n+3) .sensei-er-btn a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'meta_bg_color_3',
            [
                'label'     => __( 'Background 3', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .edumodo-sensei-course .sensei-nth-class:nth-child(6n+3) .sensei-er-btn a' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'meta_cat_color_4',
            [
                'label'     => __( 'Color 4', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .edumodo-sensei-course .sensei-nth-class:nth-child(6n+4) .sensei-er-btn a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'meta_bg_color_4',
            [
                'label'     => __( 'Background 4', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .edumodo-sensei-course .sensei-nth-class:nth-child(6n+4) .sensei-er-btn a' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'meta_cat_color_5',
            [
                'label'     => __( 'Color 5', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .edumodo-sensei-course .sensei-nth-class:nth-child(6n+5) .sensei-er-btn a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'meta_bg_color_5',
            [
                'label'     => __( 'Background 5', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .edumodo-sensei-course .sensei-nth-class:nth-child(6n+5) .sensei-er-btn a' => 'background-color: {{VALUE}};',
                ],
            ]
        );


        $this->end_controls_section();

  
	}

	protected function render() {
		require EDUMODO_CORE_ROOT . '/elements/sensei-course/template/view.php';
	}


}
