<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Scheme_Color;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Edumodo course
 *
 * Elementor widget for edumodo course
 *
 * @since 1.0.0
 */
class Edumodo_Widget_Sensei_Categories extends Widget_Base {

	public function get_name() {
		return 'edumodo-sensei-categories';
	}

	public function get_title() {
		return __( 'Sensei Categories', 'edumodo' );
	}

	public function get_icon() {
		return 'eicon-menu-bar';
	}

	public function get_categories() {
		return [ 'edumodo' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
//	public function get_script_depends() {
//		return [ 'edumodo-sensei-categories' ];
//	}

	protected function _register_controls() {

        $cat = array();
        $terms = get_terms( array(
            'post_type' => 'course',
            'taxonomy' => 'course-category',
            'hide_empty' => false,
            'fields'   => 'id=>name'
        ) );

        foreach ($terms as $key => $value) {
//                $cat[ucwords()] = ;
//                $cat[$key] = $value;
            $cat[$key] = $value;
        }
//        var_dump($cat);



		$this->start_controls_section(
			'section_image',
			[
				'label' => __( 'Image', 'edumodo' ),
			]
		);

        $this->add_control(
            'course_category_id',
            [
                'label'       => __( 'Course Category ID', 'edumodo' ),
                'type'        => Controls_Manager::SELECT,
                'default'     => '',
                'options' => $cat,
            ]
        );

		$this->add_control(
			'image',
			[
				'label' => __( 'Choose Image', 'edumodo' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			[
				'name' => 'image', // Actually its `image_size`.
				'label' => __( 'Image Size', 'edumodo' ),
				'default' => 'large',
			]
		);
		$this->add_control(
			'lp_catogories_bg_color',
			[
				'label'     => __( 'Background Color', 'edumodo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => 'rgba(2,179,228,0.8)',
				'selectors' => [
					'{{WRAPPER}} .lp-course-categories:before' => 'background-color: {{VALUE}};',

				],
			]
		);

		$this->add_control(
            'show_hide_lp_categories_courses',
            [
                'label' => __( 'Show Over Course', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
            ]
        );

		$this->add_control(
            'show_hide_lp_categories_lesson',
            [
                'label' => __( 'Show Over Lesson', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
            ]
        );
		$this->end_controls_section();
	}


	/**
	 * Render image widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings();

		if ( empty( $settings['image']['url'] ) ) {
			return;
		}

		$this->add_render_attribute( 'wrapper', 'class', 'elementor-image' );

		if ( ! empty( $settings['shape'] ) ) {
			$this->add_render_attribute( 'wrapper', 'class', 'elementor-image-shape-' . $settings['shape'] );
		}

        $show_hide_lp_categories_courses = $settings['show_hide_lp_categories_courses'];
        $show_hide_lp_categories_lesson = $settings['show_hide_lp_categories_lesson'];
        $category = get_term($settings['course_category_id']);

        if($settings['course_category_id']):
            $args = array(
                'post_type' => 'course',
                'tax_query' => array(
                    array(
                        'taxonomy' => 'course-category',
                        'field' => 'slug',
                        'terms' => array( $category->slug ),
                    ),
                ),
                'posts_per_page' => -1,
            );
            $loop = new WP_Query( $args );
            $course_count = count($loop->posts);
            $lesson_count = 0;
            $term_link = get_term_link( $category );

            if($loop->have_posts()):
                while($loop->have_posts()):
                    $loop->the_post();
                    $lesson_count = $lesson_count += Sensei()->course->course_lesson_count( get_the_ID() );
                endwhile; wp_reset_postdata();
            endif;
            ?>

            <div class="lp-course-categories">
                <?php echo Group_Control_Image_Size::get_attachment_image_html( $settings ); ?>
                <div class="content-body">
                    <div class="lp-course-meta">
                        <a href="<?php if($term_link == '') : echo $term_link; endif; ?>"><h2 class="lp-categories"><?php echo esc_html($category->name); ?></h2></a>
                        <?php if($show_hide_lp_categories_courses == 'yes'): ?>
                            <div class="lp-course"><span><?php esc_html_e($course_count.' Courses', 'edumodo') ; ?></span></div>
                         <?php endif; ?>
                         <?php if($show_hide_lp_categories_lesson == 'yes'): ?>
                            <div class="lp-lesson"><span><?php esc_html_e($lesson_count. ' Lesson', 'edumodo'); ?></span></div>
                        <?php endif; ?>

                    </div>
                </div>
            </div>
        <?php endif;
	}

}
