<?php
    $settings = $this->get_settings();

    // Global Options
    global $post;
     // Prefix
    $prefix = '_edumodo_';
    
    $cat_enable = $settings['cat_enable'];
    $view_enable = $settings['view_enable'];
    $order = $settings['order'];
    $orderby = $settings['orderby'];
    $meta_position = $settings['meta_position_vertical'];
    $title_word_count = $settings['title_word_count'];
    $desc_word_count = $settings['desc_word_count'];

?>

    <section class="edumodo-notice">
         <div class="row">
                <?php
                    $notice = array(
                        'post_type'         => 'notice',
                        'posts_per_page'    => $settings['posts_per_page'],
                        'orderby'        => $orderby,
                        'order'          => $order,
                    );

                    $notice_query = new WP_Query( $notice );
                        if($notice_query->have_posts()):
                            while($notice_query->have_posts()): 
                                $notice_query->the_post(); 
                ?>

                <div class="col-md-<?php echo $settings['posts_column']; ?> col-sm-6 col-xs-12">
                    <article id="post-<?php the_ID(); ?>" <?php post_class('tx-notice'); ?>>
                        <?php if ( has_post_thumbnail() ):?>
                            <figure class="post-thumbnail">
                                <a href="<?php the_permalink(); ?>">
                                    <?php  the_post_thumbnail();?>
                                </a>
                            </figure>
                        <?php endif; ?>

                        <div class="notice-details">

                            <?php if($meta_position == 'top'): ?>
                                <?php if($cat_enable == 'yes' || $view_enable == 'yes'): ?>
                                    <div class="notice-meta">
                                        <?php if($cat_enable == 'yes'): ?>
                                            <span class="post-date">
                                                <i class="glyph-icon flaticon-calendar-with-spring-binder-and-date-blocks"></i> 
                                                    <?php 
                                                        $archive_year  = get_the_time('Y'); 
                                                        $archive_month = get_the_time('m'); 
                                                        $archive_day   = get_the_time('d'); 
                                                    ?>
                                                <a href="<?php echo get_day_link( $archive_year, $archive_month, $archive_day); ?>"><?php echo get_the_date(); ?></a>   
                                            </span>
                                        <?php endif ; ?>

                                        <?php if($view_enable == 'yes'): ?>
                                            <span class="post-view">
                                                <i class="glyph-icon flaticon-binoculars"></i> 
                                                <?php echo getPostViews(get_the_ID()); ?>
                                            </span>
                                        <?php endif ; ?>
                                    </div><!-- .entry-meta -->
                                <?php endif; ?>
                            <?php endif; ?>

                            <header class="entry-header">
                                <h4 class="notice-entry-title">
                                    <a href="<?php the_permalink();?>">
                                        <?php esc_html_e(wp_trim_words( get_the_title(),$title_word_count, ''), 'edumodo'); ?>                                     
                                    </a>
                                </h4>       
                            </header><!-- .entry-header -->

                            <?php if($meta_position == 'bottom'): ?>
                                <?php if($cat_enable == 'yes' || $view_enable == 'yes'): ?>
                                    <div class="notice-meta">
                                        <?php if($cat_enable == 'yes'): ?>
                                            <span class="post-date">
                                                <i class="glyph-icon flaticon-calendar-with-spring-binder-and-date-blocks"></i> 
                                                    <?php 
                                                        $archive_year  = get_the_time('Y'); 
                                                        $archive_month = get_the_time('m'); 
                                                        $archive_day   = get_the_time('d'); 
                                                    ?>
                                                <a href="<?php echo get_day_link( $archive_year, $archive_month, $archive_day); ?>"><?php echo get_the_date(); ?></a>   
                                            </span>
                                        <?php endif ; ?>

                                        <?php if($view_enable == 'yes'): ?>
                                            <span class="post-view">
                                                <i class="glyph-icon flaticon-binoculars"></i> 
                                                <?php echo getPostViews(get_the_ID()); ?>
                                            </span>
                                        <?php endif ; ?>
                                    </div><!-- .entry-meta -->
                                <?php endif; ?>
                            <?php endif; ?>

                            <?php if ($notice_query):?>
                                <div class="entry-content">
                                    <p><?php esc_html_e(wp_trim_words( get_the_content(),$desc_word_count, ''), 'edumodo'); ?></p>
                                </div><!-- .entry-content -->
                            <?php endif; ?>
                        </div><!-- .notice details -->
                    </article><!-- #post-## -->
                </div> <!-- /.col-md-4 -->

            <?php endwhile; wp_reset_postdata(); endif; ?>
        </div><!-- /.row -->     
    </section> <!-- /.section -->
