<?php

    use Elementor\Group_Control_Border;
    use Elementor\Widget_Base;
    use Elementor\Controls_Manager;
    use Elementor\Scheme_Typography;
    use Elementor\Group_Control_Typography;
    use Elementor\Group_Control_Box_Shadow;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Edumodo Notice
 *
 * Elementor widget for edumodo Notice
 *
 * @since 1.0.0
 */
class Edumodo_Notice_1 extends Widget_Base {

	public function get_name() {
		return 'edumodo-notice-1';
	}

	public function get_title() {
		return __( 'Notice', 'edumodo' );
	}

	public function get_icon() {
		return 'eicon-document-file';
	}

	public function get_categories() {
		return [ 'edumodo' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
	public function get_script_depends() { 
		return [ 'edumodo-notice-1' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Query', 'edumodo' ),
			]
		);

            $this->add_control(
                'posts_per_page',
                [
                    'label' => __('Notice to Show', 'edumodo'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 3,
                    'min' => -1,
                    'max' => 50,
                    'step' => 1,
                ]
            );

            $this->add_control(
                'order',
                [
                    'label' => __('Order', 'edumodo'),
                    'type'  => Controls_Manager::SELECT,
                    'default' => 'ASC',
                    'options' => [
                        'ASC'  => __('Ascending', 'edumodo'),
                        'DESC' => __('Descending', 'edumodo'),
                    ],
                ]
            );

            $this->add_control(
                'orderby',
                [
                    'label' => __('Order By', 'edumodo'),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'date',
                    'options' => [
                        'title' => __('Title', 'edumodo'),
                        'name'  => __('Name', 'edumodo'),
                        'date'  => __('Date', 'edumodo'),
                        'rand'  => __('Random', 'edumodo'),
                    ],
                ]
            ); 

            $this->add_control(
                'posts_column',
                [
                    'label' => __('Column to Show', 'edumodo'),
                    'type' => Controls_Manager::SELECT,
                    'default' => '4',
                    'options' => [
                        '2'  => __('6', 'edumodo'),
                        '3'  => __('4', 'edumodo'),
                        '4'  => __('3', 'edumodo'),
                        '6'  => __('2', 'edumodo'),
                        '12' => __('1', 'edumodo'),
                    ],
                ]
            ); 


		$this->end_controls_section();

        $this->start_controls_section(
            'edumodo_section_title_typography',
            [
                'label' => __( 'Content', 'edumodo' ),
            ]
        );
            $this->add_control(
                'content_title_heading',
                    [
                        'label' => __( 'Title', 'edumodo' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                    ]
            );
            $this->add_control(
                'title_word_count',
                [
                    'label' => __('Word Count', 'edumodo'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 7,
                    'min' => 1,
                    'max' => 100,
                    'step' => 1,
                ]
            );
            $this->add_control(
                'content_desc_heading',
                    [
                        'label' => __( 'Description', 'edumodo' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                    ]
            );
            $this->add_control(
                'desc_word_count',
                [
                    'label' => __('Word Count', 'edumodo'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 15,
                    'min' => 1,
                    'max' => 300,
                    'step' => 1,
                ]
            );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_meta',
            [
                'label' => __( 'Meta', 'edumodo' ),
            ]
        );

            $this->add_control(
                'meta_position_vertical',
                [
                    'label' => __( 'Position', 'edumodo' ),
                    'type' => Controls_Manager::CHOOSE,
                    'default' => 'bottom',
                    'options' => [
                        'top' => [
                            'title' => __( 'Top', 'edumodo' ),
                            'icon' => 'eicon-v-align-top',
                        ],
                        'bottom' => [
                            'title' => __( 'Bottom', 'edumodo' ),
                            'icon' => 'eicon-v-align-bottom',
                        ],
                    ],
                    'toggle' => false,
                ]
            );
            $this->add_control(
                'content_date_heading',
                    [
                        'label' => __( 'Date', 'edumodo' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                    ]
            );

            $this->add_control(
                'cat_enable',
                [
                    'label' => __( 'Display', 'edumodo' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'edumodo' ),
                    'label_off' => __( 'Hide', 'edumodo' ),
                    'return_value' => 'yes',
                ]
            );
            $this->add_control(
                'content_count_heading',
                    [
                        'label' => __( 'View Count', 'edumodo' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                    ]
            );

            $this->add_control(
                'view_enable',
                [
                    'label' => __( 'Display', 'edumodo' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'edumodo' ),
                    'label_off' => __( 'Hide', 'edumodo' ),
                    'return_value' => 'yes',
                ]
            );


        $this->end_controls_section();



        $this->start_controls_section(
            'section_style',
            [
                'label' => __( 'Content', 'edumodo' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'content_style_heading',
                    [
                        'label' => __( 'Title', 'edumodo' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                    ]
            );

            $this->add_control(
                'title_color',
                [
                    'label'     => __( 'Color', 'edumodo' ),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => '',
                    'selectors' => [
                        '{{WRAPPER}} .edumodo-notice article.notice .notice-details .entry-header .notice-entry-title a, {{WRAPPER}} .edumodo-notice .type-notice .notice-details .entry-header .notice-entry-title a' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'notice1_title_typography',
                    'selector' => '{{WRAPPER}} .edumodo-notice article.notice .notice-details .entry-header .notice-entry-title, {{WRAPPER}} .edumodo-notice .type-notice .notice-details .entry-header .notice-entry-title',
                    'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                ]
            );
            $this->add_control(
                'title_hover_color',
                [
                    'label'     => __( 'Hover Color', 'edumodo' ),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => '',
                    'selectors' => [
                        '{{WRAPPER}} .edumodo-notice article.notice .notice-details .entry-header .notice-entry-title a:hover, {{WRAPPER}} .edumodo-notice .type-notice .notice-details .entry-header .notice-entry-title a:hover' => 'color: {{VALUE}} !important;',
                    ],
                ]
            );

            $this->add_control(
                'content_desc_style',
                    [
                        'label' => __( 'Description', 'edumodo' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                    ]
            );
            $this->add_control(
                'desc_color',
                [
                    'label'     => __( 'Color', 'edumodo' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .edumodo-notice article.notice .notice-details .entry-content p, {{WRAPPER}} .edumodo-notice .type-notice .notice-details .entry-content p' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'desc_typography',
                    'selector' => '{{WRAPPER}} .edumodo-notice article.notice .notice-details .entry-content p, {{WRAPPER}} .edumodo-notice .type-notice .notice-details .entry-content p',
                    'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                ]
            );

        $this->end_controls_section();



		$this->start_controls_section(
			'section_style_meta',
				[
					'label' => __( 'Meta', 'edumodo' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
		);

    		$this->add_control(
    			'meta_color',
    			[
    				'label'     => __( 'Color', 'edumodo' ),
    				'type'      => Controls_Manager::COLOR,
    				'default'   => '',
    				'selectors' => [
                        '{{WRAPPER}} .edumodo-notice article.notice .notice-details .notice-meta, {{WRAPPER}} .edumodo-notice .type-notice .notice-details .notice-meta' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .edumodo-notice article.notice .notice-details .notice-meta .post-date a, {{WRAPPER}} .edumodo-notice .type-notice .notice-details .notice-meta .post-date a' => 'color: {{VALUE}};',
    				],
    			]
    		);

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'meta_typography',
                    'selector' => '{{WRAPPER}} .edumodo-notice article.notice .notice-details .notice-meta, {{WRAPPER}} .edumodo-notice .type-notice .notice-details .notice-meta',
                    'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                ]
            );

		$this->end_controls_section();

       $this->start_controls_section(
            'section_style_border_shadow',
                [
                    'label' => __( 'Global', 'edumodo' ),
                    'tab'   => Controls_Manager::TAB_STYLE,
                ]
        );

            $this->add_control(
                'bg_color',
                [
                    'label' => __( 'Background Color', 'edumodo' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .edumodo-notice article.notice, {{WRAPPER}} .edumodo-notice .type-notice' => 'background-color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'content_layout_align',
                [
                    'label' => esc_html__( 'Alignment', 'edumodo' ),
                    'type'  => Controls_Manager::CHOOSE,
                    'default'   =>'left' ,
                    'options'   => [
                        'left'    => [
                            'title' => esc_html__( 'Left', 'edumodo' ),
                            'icon'  => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'edumodo' ),
                            'icon'  => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'edumodo' ),
                            'icon'  => 'eicon-text-align-left',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .edumodo-notice article.notice .notice-details, {{WRAPPER}} .edumodo-notice .type-notice .notice-details' => 'text-align: {{VALUE}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'content_padding',
                [
                    'label' => esc_html__( 'Padding', 'edumodo' ),
                    'type'  => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors'  => [
                        '{{WRAPPER}} .edumodo-notice article.notice .notice-details, {{WRAPPER}} .edumodo-notice .type-notice .notice-details' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );


            $this->add_group_control(
                Group_Control_Border::get_type(),
                    [
                        'name'  => 'border_width',
                        'label' => esc_html__( 'Border', 'edumodo' ),
                        'placeholder' => '1px',
                        'default'   => '1px',
                        'selector'  => '{{WRAPPER}} .edumodo-notice article.notice, {{WRAPPER}} .edumodo-notice .type-notice',
                        'separator' => 'before',
                      
                    ]
            );

            $this->add_responsive_control(
                'border_radius',
                    [
                        'label' => esc_html__( 'Border Radius', 'edumodo' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%' ],
                        'selectors'  => [
                            '{{WRAPPER}} .edumodo-notice article.notice, {{WRAPPER}} .edumodo-notice .type-notice' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .edumodo-notice article.notice figure, {{WRAPPER}} .edumodo-notice .type-notice figure img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} 0 0;',
                        ],
                    ]
            );


            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'box_shadow',
                    'selector' => '{{WRAPPER}} .edumodo-notice article.notice, {{WRAPPER}} .edumodo-notice .type-notice',

                ]
            );

            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [   'label' => __( 'Hover Box Shadow', 'edumodo' ),
                    'name' => 'box_shadow_hover',
                    'selector' => '{{WRAPPER}} .edumodo-notice article.notice:hover, {{WRAPPER}} .edumodo-notice .type-notice:hover',
                ]
            );

            $this->add_control(
                'content_overlay_heading',
                    [
                        'label' => __( 'Overlay', 'edumodo' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                    ]
                );
            $this->add_control(
                'overlay_color',
                [
                    'label' => __( 'Color', 'edumodo' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .edumodo-notice article.notice figure a:before, {{WRAPPER}} .edumodo-notice .type-notice figure a:before' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'content_overlay_icon_heading',
                        [
                            'label' => __( 'Icon', 'edumodo' ),
                            'type' => Controls_Manager::HEADING,
                        ]
            );
            $this->add_control(
                'overlay_icon_color',
                [
                    'label' => __( 'Color', 'edumodo' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .edumodo-notice article.notice figure a:after, {{WRAPPER}} .edumodo-notice .type-notice figure a:after' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'overlay_icon_bg_color',
                [
                    'label' => __( 'Background Color', 'edumodo' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .edumodo-notice article.notice figure a:after, {{WRAPPER}} .edumodo-notice .type-notice figure a:after' => 'background: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'icon_border_radius',
                    [
                        'label' => esc_html__( 'Border Radius', 'edumodo' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%' ],
                        'selectors'  => [
                            '{{WRAPPER}} .edumodo-notice article.notice figure a:after, {{WRAPPER}} .edumodo-notice .type-notice figure a:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                    ]
            );

        $this->end_controls_section();


	}

	protected function render() {
		require EDUMODO_CORE_ROOT . '/elements/notice-1/template/view.php';
	}


}
