<?php


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor buildetic Portfolio 1
 *
 * Elementor widget for buildetic portfolio 1
 *
 * @since 1.0.0
 */
class Edumodo_LP_Course_Search_Widget extends Widget_Base {

	public function get_name() {
		return 'edumodo-lp-course-search';
	}

	public function get_title() {
		return __( 'Course Search', 'edumodo' );
	}

	public function get_icon() {
		return 'eicon-search';
	}

	public function get_categories() {
		return [ 'edumodo' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
	public function get_script_depends() {
		return [];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Content', 'edumodo' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

	    $this->add_control(
		    'action_link',
		      	[
		          'label' => __( 'Action Link', 'edumodo' ),
		          'type'  => Controls_Manager::TEXT,
		          'default' => '#',
		          'label_block' => true,
		    	]
	    );

	    $this->add_control(
		    'btn_text',
		      	[
		          'label' => __( 'Button Text', 'edumodo' ),
		          'type'  => Controls_Manager::TEXT,
		          'default' => 'Search',
		          'label_block' => true,
		    	]
	    );

	    $this->add_control(
		    'placeholder',
		      	[
		          'label' => __( 'Placeholder', 'edumodo' ),
		          'type'  => Controls_Manager::TEXT,
		          'default' => 'What do you want to learn?',
		          'label_block' => true,
		    	]
	    );

		$this->end_controls_section();

		$this->start_controls_section(
			'section_testimoni',
			[
				'label' => __( 'Style', 'edumodo' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

	    $this->add_responsive_control(
			'froms_height',
				[
					'label'  => __( 'Height', 'edumodo' ),
					'type'   => Controls_Manager::SLIDER,
					'default' => [
	                    'size' => 50,
	                ],
					'range'  => [
						'px' => [
							'min' => 42,
							'max' => 120,
						],
					],
					'selectors' => [
						'{{WRAPPER}} form.lp-course-form-wrapper' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
		);


	    $this->add_responsive_control(
			'froms_submit_width',
				[
					'label'  => __( 'Submit Button Width', 'edumodo' ),
					'type'   => Controls_Manager::SLIDER,
					'range'  => [
						'px' => [
							'min' => 10,
							'max' => 300,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .lp-course-form-wrapper .lp-course-btn' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
		);

		$this->add_control(
			'input_color',
			[
				'label'     => __( 'Input Text', 'edumodo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .lp-course-form-wrapper .lp-course-input' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'input_border_color',
			[
				'label'     => __( 'Input Border', 'edumodo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .lp-course-form-wrapper .lp-course-input' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'input_bg_color',
			[
				'label'     => __( 'Input Background', 'edumodo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .lp-course-form-wrapper .lp-course-input' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'btn_bg_color',
			[
				'label'     => __( 'Submit Background', 'edumodo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .lp-course-form-wrapper .lp-course-btn' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'btn_bg_hover_color',
			[
				'label'     => __( 'Submit Background Hover', 'edumodo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .lp-course-form-wrapper .lp-course-btn:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'btn_border_color',
			[
				'label'     => __( 'Submit Border', 'edumodo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .lp-course-form-wrapper .lp-course-btn' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
				[
					'name'     => 'submit_typography',
					'label'    => __( 'Submit Typography', 'edumodo' ),
					'scheme'   => Scheme_Typography::TYPOGRAPHY_4,
					'selector' => '{{WRAPPER}} .lp-course-form-wrapper .lp-course-btn',
				]
		);
		
		$this->add_control(
			'input_placholder_color',
			[
				'label'     => __( 'Placeholder', 'edumodo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .lp-course-form-wrapper input::placeholder' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'btn_text_color',
			[
				'label'     => __( 'Submit Text', 'edumodo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .lp-course-form-wrapper .lp-course-btn' => 'color: {{VALUE}};',

				],
			]
		);

		$this->add_control(
			'btn_text_hover_color',
			[
				'label'     => __( 'Submit Text Hover', 'edumodo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .lp-course-form-wrapper .lp-course-btn:hover' => 'color: {{VALUE}};',

				],
			]
		);

	$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings();
?>
	<form class="lp-course-form-wrapper" action="<?php echo learn_press_get_page_link( 'courses' ); ?>" method="post">
	    <input class="lp-course-input" type="text" placeholder="<?php echo $settings['placeholder']; ?>" required>
	   <button class="lp-course-btn" type="submit"><?php echo $settings['btn_text']; ?></button>
	</form>

	

<?php 

	}


}
