<?php


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Edumodo course
 *
 * Elementor widget for edumodo course
 *
 * @since 1.0.0
 */
class Edumodo_Learnpress_Course extends Widget_Base {

	public function get_name() {
		return 'edumodo-learnpress-course';
	}

	public function get_title() {
		return __( 'Learnpress Courses', 'edumodo' );
	}

	public function get_icon() {
		return 'eicon-sidebar';
	}

	public function get_categories() {
		return [ 'edumodo' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
	public function get_script_depends() {
		return [ 'edumodo-learnpress-course' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'edumodo' ),
			]
		);

		$this->add_control(
			'lp_course_style',
			[
				'label'     => esc_html__( 'Course Layout', 'edumodo' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'style_2',
				'options'   => [
					'style_1'   => esc_html__( 'Style 1', 'edumodo' ),
					'style_2'   => esc_html__( 'Style 2', 'edumodo' ),
				],

			]
		);
        $this->add_control(
            'active_carousel',
            [
                'label' => __( 'Active Carousel', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
            ]
        );
        
        $this->add_control(
            'carousel_nav_visible',
            [
                'label' => __( 'Nav Always Visible', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
                'condition' => [
                    'active_carousel' => 'yes',
                ],
            ]
        );
        
        $this->add_control(
            'posts_per_page',
            [
                'label' => __('Item to Show', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 6,
                'min' => 1,
                'max' => 50,
                'step' => 1,
            ]
        );

        $this->add_control(
            'posts_column',
            [
                'label' => __('Column', 'edumodo'),
                'type' => Controls_Manager::SELECT,
                'default' => '4',
                'options' => [
                    '2' => __('6 Column', 'edumodo'),
                    '3' => __('4 Column', 'edumodo'),
                    '4' => __('3 Column', 'edumodo'),
                    '6' => __('2 Column', 'edumodo'),
                    '12' => __('1 Column', 'edumodo'),
                ],
            ]
        );
    $this->add_responsive_control(
            'image_fixed_height',
            [
                'label' => __( 'Height', 'edumodo' ),
                'description'   => __( 'Field blank is default', 'edumodo' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 900,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-course-1 article.tx-course, .type-tx-course article.tx-course' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .edumodo-lp-course-1 .lp-course-1' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

		$this->start_controls_section(
			'edumodo_section_title_typography',
			[
				'label' => __( 'Title', 'edumodo' ),
			]
		);

       	$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'edumodo_title_typography',
                'selector' => '{{WRAPPER}} .edumodo-lp-course-1 .lp-course-1 .course-content-body .course-entry-title a, .edumodo-course-1 article.tx-course .course-details .entry-header .course-entry-title',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );

        $this->add_control(
            'excerpt_title_word',
            [
                'label' => __('Excerpt Title Word', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 7,
                'min' => 1,
                'max' => 50,
                'step' => 1,
            ]
        );

		$this->end_controls_section();

        $this->start_controls_section(
            'section_meta_price',
            [
                'label' => __( 'Price', 'edumodo' ),
            ]
        );

        $this->add_control(
            'lp_course_price',
            [
                'label' => __( 'Show Price', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
            ]
        );

        $this->add_control(
            'lp_course_price_top',
            [
                'label' => __( 'Show Top Price', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
                'condition' => [
                    'lp_course_style' => 'style_1',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'edumodo_meta_price_typography',
                'selector' => '{{WRAPPER}} .edumodo-course-1 article.tx-course span.addon-price, .edumodo-lp-course-1 span.addon-price',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );
    
        $this->end_controls_section();

        $this->start_controls_section(
            'section_meta_cat',
            [
                'label' => __( 'Categories', 'edumodo' ),
            ]
        );
        
        $this->add_control(
            'lp_course_cat',
            [
                'label' => __( 'Show Categories', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'edumodo_meta_cat_typography',
                'selector' => '{{WRAPPER}} .edumodo-course-1 article.tx-course .course-details .course-meta .post-date a, .edumodo-lp-course-1 .lp-cat .cat-links a',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_meta_enroll',
            [
                'label' => __( 'Enrolled', 'edumodo' ),
            ]
        );
        $this->add_control(
            'lp_course_students_er',
            [
                'label' => __( 'Show Enrolled', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'edumodo_meta_enroll_typography',
                'selector' => '{{WRAPPER}} .edumodo-course-1 article.tx-course .course-details .course-meta span.post-view',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );
        
        $this->end_controls_section();

		$this->start_controls_section(
			'section_meta_instructor',
			[
				'label' => __( 'Instructor', 'edumodo' ),
                'condition' => [
                    'lp_course_style' => 'style_1',
                ],
			]
		);
        
        $this->add_control(
            'show_hide_lp_instructor',
            [
                'label' => __( 'Show Instructor', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
            ]

        );

		$this->end_controls_section();
		$this->start_controls_section(
			'section_desc_typography',
			[
				'label' => __( 'Description', 'edumodo' ),
			]
		);

       	$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'desc_typography',
                'selector' => '{{WRAPPER}} .edumodo-lp-course-1 .lp-course-1 .entry-content  p, .edumodo-course-1 article.tx-course .course-details .entry-content p',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );

        $this->add_control(
            'excerpt_desc_word',
            [
                'label' => __('Excerpt Description Word', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 15,
                'min' => 5,
                'max' => 150,
                'step' => 1,
            ]
        );

		$this->end_controls_section();

        $this->start_controls_section(
            'section_style_color',
                [
                    'label' => __( 'Color', 'edumodo' ),
                    'tab'   => Controls_Manager::TAB_STYLE,
                ]
            );

        $this->add_control(
            'overlay_color',
            [
                'label'     => __( 'Overlay', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .enter-related-course .edumodo-related-course-1 article.tx-course figure a:before, .edumodo-course-1 article.tx-course figure a:before' => 'background: {{VALUE}};',
                    '{{WRAPPER}} .edumodo-course-1 article.tx-course figure a:after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_title',
                [
                    'label' => __( 'Title', 'edumodo' ),
                    'tab'   => Controls_Manager::TAB_STYLE,
                ]
            );

        $this->add_control(
            'title_color',
            [
                'label'     => __( 'Color', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#333',
                'selectors' => [
                    '{{WRAPPER}} .edumodo-lp-course-1 .lp-course-1 .course-content-body .course-entry-title a, .edumodo-course-1 article.tx-course .course-details .entry-header .course-entry-title a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_desc',
                [
                    'label' => __( 'Description', 'edumodo' ),
                    'tab'   => Controls_Manager::TAB_STYLE,
                ]
            );

        $this->add_control(
            'desc_color',
            [
                'label'     => __( 'Color', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .edumodo-lp-course-1 .lp-course-1 .course-content-body .entry-content, .edumodo-course-1 article.tx-course .course-details .entry-content p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_price',
                [
                    'label' => __( 'Price', 'edumodo' ),
                    'tab'   => Controls_Manager::TAB_STYLE,
                ]
            );

        $this->add_control(
            'price_color',
            [
                'label'     => __( 'Color', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .edumodo-course-1 article.tx-course span.addon-price' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->add_control(
            'price_bg_color',
            [
                'label'     => __( 'Background', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'condition' => [
                    'lp_course_style' => 'style_1',
                ],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-lp-course-1 .addon-price-wapper' => 'background: {{VALUE}};',
                ]
            ]
        );

        $this->end_controls_section();

		$this->start_controls_section(
			'section_style_cat',
				[
					'label' => __( 'Categorie', 'edumodo' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);


        $this->add_control(
            'meta_cat_color',
            [
                'label'     => __( 'Color 1', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .edumodo-course-1 article.tx-course .course-details .course-meta .post-date a, .type-tx-course article.tx-course .course-details .course-meta .post-date a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'meta_bg_color',
            [
                'label'     => __( 'Background 1', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .edumodo-course-1 article.tx-course .course-details .course-meta .post-date a, .type-tx-course article.tx-course .course-details .course-meta .post-date a' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'meta_cat_color_2',
            [
                'label'     => __( 'Color 2', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .edumodo-course-1 div:nth-child(6n+2)  article.tx-course .course-details .course-meta .post-date a, .type-tx-course article.tx-course .course-details .course-meta .post-date a' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .edumodo-lp-course-1 div.col-md-4:nth-child(6n+2) .lp-cat .cat-links a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'meta_bg_color_2',
            [
                'label'     => __( 'Background 2', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .edumodo-course-1 div:nth-child(6n+2) article.tx-course .course-details .course-meta .post-date a, .type-tx-course article.tx-course .course-details .course-meta .post-date a' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .edumodo-lp-course-1 div.col-md-4:nth-child(6n+2) .lp-cat .cat-links a' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'meta_cat_color_3',
            [
                'label'     => __( 'Color 3', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .edumodo-course-1 div:nth-child(6n+3)  article.tx-course .course-details .course-meta .post-date a, .type-tx-course article.tx-course .course-details .course-meta .post-date a' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .edumodo-lp-course-1 div.col-md-4:nth-child(6n+3) .lp-cat .cat-links a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'meta_bg_color_3',
            [
                'label'     => __( 'Background 3', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .edumodo-course-1 div:nth-child(6n+3) article.tx-course .course-details .course-meta .post-date a, .type-tx-course article.tx-course .course-details .course-meta .post-date a' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .edumodo-lp-course-1 div.col-md-4:nth-child(6n+3) .lp-cat .cat-links a' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'meta_cat_color_4',
            [
                'label'     => __( 'Color 4', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .edumodo-course-1 div:nth-child(6n+4)  article.tx-course .course-details .course-meta .post-date a, .type-tx-course article.tx-course .course-details .course-meta .post-date a' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .edumodo-lp-course-1 div.col-md-4:nth-child(6n+4) .lp-cat .cat-links a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'meta_bg_color_4',
            [
                'label'     => __( 'Background 4', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .edumodo-course-1 div:nth-child(6n+4) article.tx-course .course-details .course-meta .post-date a, .type-tx-course article.tx-course .course-details .course-meta .post-date a' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .edumodo-lp-course-1 div.col-md-4:nth-child(6n+4) .lp-cat .cat-links a' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'meta_cat_color_5',
            [
                'label'     => __( 'Color 5', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .edumodo-course-1 div:nth-child(6n+5)  article.tx-course .course-details .course-meta .post-date a, .type-tx-course article.tx-course .course-details .course-meta .post-date a' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .edumodo-lp-course-1 div.col-md-4:nth-child(6n+5) .lp-cat .cat-links a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'meta_bg_color_5',
            [
                'label'     => __( 'Background 5', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .edumodo-course-1 div:nth-child(6n+5) article.tx-course .course-details .course-meta .post-date a, .type-tx-course article.tx-course .course-details .course-meta .post-date a' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .edumodo-lp-course-1 div.col-md-4:nth-child(6n+5) .lp-cat .cat-links a' => 'background-color: {{VALUE}};',
                ],
            ]
        );


		$this->end_controls_section();

        $this->start_controls_section(
            'section_style_enroll',
                [
                    'label' => __( 'Enroll', 'edumodo' ),
                    'tab'   => Controls_Manager::TAB_STYLE,
                ]
            );

        $this->add_control(
            'enroll_color',
            [
                'label'     => __( 'Color', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .edumodo-course-1 article.tx-course .course-details .course-meta .post-view i, .type-tx-course article.tx-course .course-details .course-meta .post-view i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .edumodo-course-1 article.tx-course .course-details .course-meta .post-view, .type-tx-course article.tx-course .course-details .course-meta .post-view' => 'color: {{VALUE}};',

                    '{{WRAPPER}} .edumodo-lp-course-1 .course-meta.addons-course-meta span.post-view' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->end_controls_section();
	}

	protected function render() {
		require EDUMODO_CORE_ROOT . '/elements/learnpress-course/template/view.php';
	}


}
