<?php
    $settings = $this->get_settings();
    global $post;
    $prefix = '_edumodo_';
    $excerpt_title_word = $settings['excerpt_title_word'];
    $read_more_button = $settings['read_more_button'];
    $posts_per_page = $settings['posts_per_page'];
    $cat_multi_slug           = edumodo_array_get($settings, 'cat_dynamic_multiple_id');

?>
<div class="row">
    <div class="edumodo-course-1 edumodo-ld-course">
        <?php
    
            $course = array(
                'post_type'         => 'sfwd-courses',
                'posts_per_page'         =>  $posts_per_page,
                'post_status'       => 'publish',
                'tax_query'         => array(
                    array(
                        'taxonomy'  => 'ld_course_category',
                        'field'     => 'slug',
                        'terms'     => $cat_multi_slug
                    )
                )
            );

            $course_query = new WP_Query( $course );
                if($course_query->have_posts()):
                    while($course_query->have_posts()): 
                        $course_query->the_post(); 
    
                    global $post; $post_id = $post->ID;

                    $course_id = $post_id;
                    $user_id   = get_current_user_id();

                    $enable_video = get_post_meta( $post->ID, '_learndash_course_grid_enable_video_preview', true );
                    $embed_code   = get_post_meta( $post->ID, '_learndash_course_grid_video_embed_code', true );
                    $button_text  = get_post_meta( $post->ID, '_learndash_course_grid_custom_button_text', true );

                    // Retrive oembed HTML if URL provided
                    if ( preg_match( '/^http/', $embed_code ) ) {
                        $embed_code = wp_oembed_get( $embed_code, array( 'height' => 600, 'width' => 400 ) );
                    }

                    $button_text = isset( $button_text ) && ! empty( $button_text ) ? $button_text : __( 'See more...', 'edumodo' );

                    $button_text = apply_filters( 'learndash_course_grid_custom_button_text', $button_text, $post_id );

                    $options = get_option('sfwd_cpt_options');
                    $currency = null;

                    if ( ! is_null( $options ) ) {
                        if ( isset($options['modules'] ) && isset( $options['modules']['sfwd-courses_options'] ) && isset( $options['modules']['sfwd-courses_options']['sfwd-courses_paypal_currency'] ) )
                        $currency = $options['modules']['sfwd-courses_options']['sfwd-courses_paypal_currency'];
                    }

                    if( is_null( $currency ) )
                        $currency = 'USD';

                    $course_options = get_post_meta($post_id, "_sfwd-courses", true);
                    $price = $course_options && isset($course_options['sfwd-courses_course_price']) ? $course_options['sfwd-courses_course_price'] : __( 'Free', 'edumodo' );
                    $short_description = @$course_options['sfwd-courses_course_short_description'];

                    $has_access   = sfwd_lms_has_access( $course_id, $user_id );
                    $is_completed = learndash_course_completed( $user_id, $course_id );

                    if( $price == '' )
                        $price .= __( 'Free', 'edumodo' );

                    if ( is_numeric( $price ) ) {
                        if ( $currency == "USD" )
                            $price = '$' . $price;
                        else
                            $price .= ' ' . $currency;
                    }

                    $class       = '';
                    $ribbon_text = '';

                    if ( $has_access && ! $is_completed ) {
                        $class = 'ld_course_grid_price ribbon-enrolled';
                        $ribbon_text = __( 'Enrolled', 'edumodo' );
                    } elseif ( $has_access && $is_completed ) {
                        $class = 'ld_course_grid_price';
                        $ribbon_text = __( 'Completed', 'edumodo' );
                    } else {
                        $class = ! empty( $course_options['sfwd-courses_course_price'] ) ? 'ld_course_grid_price price_' . $currency : 'ld_course_grid_price free';
                        $ribbon_text = $price;
                    }

        ?>

        <div class="ld_course_grid col-md-<?php echo $settings['posts_column']; ?> col-sm-6">
            <article id="post-<?php the_ID(); ?>" <?php post_class('thumbnail course'); ?>>
                
                <?php if ( $post->post_type == 'sfwd-courses' ) : ?>
                <div class="<?php echo esc_attr( $class ); ?>">
                    <?php echo esc_attr( $ribbon_text ); ?>
                </div>
                <?php endif; ?>

                <?php if ( 1 == $enable_video && ! empty( $embed_code ) ) : ?>
                <div class="ld_course_grid_video_embed">
                <?php echo $embed_code; ?>
                </div>
                <?php elseif( has_post_thumbnail() ) :?>
                <a href="<?php the_permalink(); ?>" rel="bookmark">
                    <?php the_post_thumbnail('course-thumb'); ?>
                </a>
                <?php else :?>
                <a href="<?php the_permalink(); ?>" rel="bookmark">
                    <img alt="" src="<?php echo plugins_url( 'no_image.jpg', LEARNDASH_COURSE_GRID_FILE); ?>"/>
                </a>
                <?php endif;?>
                <div class="caption">
                    <h3 class="entry-title">  <?php esc_html_e(wp_trim_words( get_the_title(), $excerpt_title_word, ''), 'edumodo'); ?></h3>
                    <?php if(!empty($short_description)) { ?>
                    <p class="entry-content"><?php echo htmlspecialchars_decode( do_shortcode( $short_description ) ); ?></p>
                    <?php  } ?>
                    <?php  $read_more_button = $settings['read_more_button']; ?>
                    <?php if($read_more_button == 'yes'): ?>
                        <p class="ld_course_grid_button">
                            <a class="btn btn-primary" role="button" href="<?php the_permalink(); ?>" rel="bookmark"><?php echo esc_attr( $button_text ); ?></a>
                        </p>  
                    <?php endif; ?>
                     <?php  $progress_bar_enable = $settings['progress_bar_enable']; ?>
                    <?php if($progress_bar_enable == 'yes'): ?>
                        <?php if ( isset( $shortcode_atts['progress_bar'] ) && $shortcode_atts['progress_bar'] == 'true' ) : ?>
                        <p><?php echo do_shortcode( '[learndash_course_progress course_id="' . get_the_ID() . '" user_id="' . get_current_user_id() . '"]' ); ?></p>
                        <?php endif; ?>
                    <?php endif; ?>
                </div><!-- .entry-header -->
            </article><!-- #post-## -->
        </div>
        <?php endwhile; wp_reset_postdata(); endif; ?>
    </div>          
</div>







