<?php


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Edumodo course
 *
 * Elementor widget for edumodo course
 *
 * @since 1.0.0
 */
class Edumodo_Learndesh_Course extends Widget_Base {

	public function get_name() {
		return 'edumodo-learndash-course';
	}

	public function get_title() {
		return __( 'Learndash Courses', 'edumodo' );
	}

	public function get_icon() {
		return 'eicon-sidebar';
	}

	public function get_categories() {
		return [ 'edumodo' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
	public function get_script_depends() {
		return [ 'edumodo-learndash-course' ];
	}

	protected function _register_controls() {
        
        $terms = get_terms(array(
            'post_type' => 'sfwd-courses',
            'taxonomy' => 'ld_course_category',
            'hide_empty' => false,
        ));
        $cat_names = array('');
        foreach ($terms as $t):
            $cat_names[$t->slug] = $t->name;
        endforeach;

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'edumodo' ),
			]
		);
        $this->add_control(
            'cat_dynamic_multiple_id',
            [
                'label' => __( 'Category List', 'edumodo' ),
                'type' => Controls_Manager::SELECT2,
                'options' => $cat_names,
                'multiple' => true,
            ]
        );
        $this->add_control(
            'posts_per_page',
            [
                'label' => __('Item to Show', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 6,
                'min' => 1,
                'max' => 50,
                'step' => 1,
            ]
        );

        $this->add_control(
            'posts_column',
            [
                'label' => __('Column', 'edumodo'),
                'type' => Controls_Manager::SELECT,
                'default' => '4',
                'options' => [
                    '2' => __('6 Column', 'edumodo'),
                    '3' => __('4 Column', 'edumodo'),
                    '4' => __('3 Column', 'edumodo'),
                    '6' => __('2 Column', 'edumodo'),
                    '12' => __('1 Column', 'edumodo'),
                ],
            ]
        );
        $this->add_control(
            'order',
            [
                'label' => __('Order', 'edumodo'),
                'type' => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => [
                    'ASC' => __('Ascending', 'edumodo'),
                    'DESC' => __('Descending', 'edumodo'),
                ],
            ]
        );

        $this->add_control(
            'orderby',
            [
                'label' => __('Order By', 'edumodo'),
                'type' => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'title' => __('Title', 'edumodo'),
                    'name' => __('Name', 'edumodo'),
                    'date' => __('Date', 'edumodo'),
                    'rand' => __('Random', 'edumodo'),
                ],
            ]
        );  
        $this->add_responsive_control(
            'image_fixed_height_enable',
            [
                'label' => __( 'Custom Column Height', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
            ]
        );

        $this->add_responsive_control(
            'image_fixed_height',
            [
                'label' => __( 'Column Height', 'edumodo' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 300,
                        'max' => 700,
                    ],
                ],
                'condition' => [
                    'image_fixed_height_enable' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-ld-course .thumbnail' => 'max-height: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __('Title Typography', 'edumodo'),
                'name' => 'edumodo_title_typography',  
                'selector' => '{{WRAPPER}} .edumodo-ld-course .ld_course_grid .entry-title',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );

        $this->add_control(
            'excerpt_title_word',
            [
                'label' => __('Excerpt Title Word', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 7,
                'min' => 1,
                'max' => 50,
                'step' => 1,
            ]
        );

        $this->add_control(
            'read_more_button',
            [
                'label' => __( 'Button Show/Hide', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
            ]
        );

        $this->add_control(
            'progress_bar_enable',
            [
                'label' => __( 'Progress Bar Show/Hide', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
            ]
        );

		$this->end_controls_section();


		$this->start_controls_section(
			'section_style',
				[
					'label' => __( 'Color', 'edumodo' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);

		$this->add_control(
			'title_color',
			[
				'label'     => __( 'Title Color', 'edumodo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .edumodo-ld-course .ld_course_grid .entry-title' => 'color: {{VALUE}};',
				],
			]
		);

        

        $this->add_control(
            'desc_color',
            [
                'label'     => __( 'Content Color', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .edumodo-ld-course p.entry-content' => 'color: {{VALUE}};',
                ],
            ]
        );
		

        $this->add_control(
            'price_meta',
            [
                'label'     => __( 'Price Color', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .learned-ld-course .thumbnail.course .ld_course_grid_price' => 'background-color: {{VALUE}};',
                ],
            ]
        );

		$this->end_controls_section();

	}

	protected function render() {
		require EDUMODO_CORE_ROOT . '/elements/learndash-course/template/view.php';
	}


}
