<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Utils;
use Elementor\Group_Control_Box_Shadow;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor edumodo Portfolio 1
 *
 * Elementor widget for edumodo portfolio 1
 *
 * @since 1.0.0
 */
class Edumodo_LD_Dynamic_Category_Config extends Widget_Base {

	public function get_name() {
		return 'edumodo-ld-dynamic-category';
	}

	public function get_title() {
		return __( 'LearnDash Dynamic Category', 'edumodo' );
	}

	public function get_icon() {
		return 'eicon-tabs';
	}

	public function get_categories() {
		return [ 'edumodo' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	public function get_script_depends() {
		return [];
	}

	protected function _register_controls() {

        $terms = get_terms( array(
            'post_type' => 'sfwd-courses',
            'taxonomy' => 'ld_course_category',
            'hide_empty' => false,
        ) );
        $cat_names = array('');
        foreach( $terms as $t ):
            $cat_names[$t->slug] = $t->name;
        endforeach;

		$this->start_controls_section(
			'section_general',
			[
				'label' => __( 'Dynamic Tab', 'edumodo' ),
			]
		);

        $this->add_control(
            'cat_dynamic_multiple_id',
            [
                'label' => __( 'Category List', 'edumodo' ),
                'type' => Controls_Manager::SELECT2,
                'options' => $cat_names,
                'multiple' => true,
            ]
        );
        $this->add_control(
            'course_thumbnail_size',
            [
                'label'       => __( 'Thumbnail Size', 'edumodo' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'large',
                'options' => [
                    'medium'  => __( 'Medium', 'edumodo' ),
                    'medium_large'  => __( 'Medium Large', 'edumodo' ),
                    'large'  => __( 'Large', 'edumodo' ),
                    'full'  => __( 'Full', 'edumodo' ),
                ],
            ]
        );
        $this->add_control(
            'post_num_to_show',
            [
                'label'   => __( 'Number of Post to Show', 'edumodo' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 5,
                'min'     => -1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'posts_column',
            [
                'label' => __('Column', 'edumodo'),
                'type' => Controls_Manager::SELECT,
                'default' => '4',
                'options' => [
                    '2' => __('6 Column', 'edumodo'),
                    '3' => __('4 Column', 'edumodo'),
                    '4' => __('3 Column', 'edumodo'),
                    '6' => __('2 Column', 'edumodo'),
                    '12' => __('1 Column', 'edumodo'),
                ],
            ]
        );
        $this->add_control(
            'active_carousel',
            [
                'label' => __( 'Active Carousel', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
            ]
        );

        $this->add_control(
            'carousel_nav_visible',
            [
                'label' => __( 'Nav Always Visible', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
                'condition' => [
                    'active_carousel' => 'yes',
                ],
            ]
        );
        
        $this->add_control(
            'hide_tab_menu',
            [
                'label' => __( 'Hide Tab Menu', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
            ]
        );

        $this->add_control(
            'lp_course_price',
            [
                'label' => __( 'Show Price', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_responsive_control(
            'fixed_height',
            [
                'label' => __( 'Fixed Height', 'edumodo' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 600,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} article.course' => 'max-height: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

		$this->end_controls_section();

        $this->start_controls_section(
            'tab_section_style',
                [
                    'label' => __( 'Tab', 'edumodo' ),
                    'tab'   => Controls_Manager::TAB_STYLE,
                ]
            );

        $this->add_responsive_control(
            'tab_align',
            [
                'label'   => __('Content Alignment', 'edumodo'),
                'type'    => Controls_Manager::CHOOSE,
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .dynamic-category-wrapper' => 'text-align: {{UNIT}};',
                ],
                'options' => [
                    'left'   => [
                        'title' => __('Left', 'edumodo'),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'edumodo'),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right'  => [
                        'title' => __('Right', 'edumodo'),
                        'icon'  => 'fa fa-align-right',
                    ],
                ],

            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
                [   
                    'label' => __( 'Tab Typography', 'edumodo' ),
                    'name' => 'tab_typography',
                    'selector' => '{{WRAPPER}} .dynamic-category-wrapper .multiple-cat .cat-item',
                    'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                ]
        );

        $this->add_control(
            'tab_color',
            [
                'label'     => __( 'Tab Color', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dynamic-category-wrapper .cat-item.active:after ' => 'color: {{VALUE}};',
                   
                ],
            ]
        );
        
        $this->add_control(
            'tab_active_color',
            [
                'label'     => __( 'Tab Active Color', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dynamic-category-wrapper .multiple-cat .cat-item.active' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .dynamic-category-body .owl-nav .owl-carousel-left, .dynamic-category-body .owl-nav .owl-carousel-right' => 'color: {{VALUE}};',
                     '{{WRAPPER}} .dynamic-category-wrapper .multiple-cat .cat-item.active:after' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'tab_loding_color',
            [
                'label'     => __( 'Loading Color', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .lds-ellipsis div' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'tab_overlay_color',
            [
                'label'     => __( 'Overlay Color', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dynamic-cat-post-list .ajax-content' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'tab_spacing',
            [
                'label' => __( 'Tab Spacing', 'edumodo' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .dynamic-category-wrapper' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'tab_cat_spacing',
            [
                'label' => __( 'Category Spacing', 'edumodo' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 80,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .dynamic-category-wrapper .multiple-cat .cat-item' => 'padding-left: {{SIZE}}{{UNIT}}; padding-right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_wapper_style',
                [
                    'label' => __( 'Layout', 'edumodo' ),
                    'tab' => Controls_Manager::TAB_STYLE,
                ]
            );

        $this->add_control(
            'layout_background_color',
            [
                'label' => __( 'Background Color', 'edumodo' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} article.course' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'layout_border_width',
            [
                'label' => __( 'Border Width', 'edumodo' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 10,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} article.course' => 'border-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
    $this->add_control(
        'layout_border_color',
        [
            'label' => __( 'Border Color', 'edumodo' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} article.course' => 'border-color: {{VALUE}};',
            ],
        ]
    );
        $this->add_control(
            'layout_border_radius',
            [
                'label' => __( 'Border Radius', 'edumodo' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} article.course' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'body_box_shadow',
                'selector' => '{{WRAPPER}} article.course',
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'title_section_style',
                [
                    'label' => __( 'Title', 'edumodo' ),
                    'tab'   => Controls_Manager::TAB_STYLE,
                ]
            );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
                [   
                    'label' => __( 'Title Typography', 'edumodo' ),
                    'name' => 'title_typography',
                    'selector' => '{{WRAPPER}} .course a.course-title-link',
                    'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                ]
        );

            $this->start_controls_tabs('title_style_tabs');

                $this->start_controls_tab(
                    'title_style_normal_tab',
                    [
                        'label' => __( 'Normal', 'edumodo' ),
                    ]
                );

                    $this->add_control(
                        'title_color',
                        [
                            'label' => __( 'Color', 'edumodo' ),
                            'type' => Controls_Manager::COLOR,
                            'default'=>'',
                            'selectors' => [
                                '{{WRAPPER}} .course a.course-title-link' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                $this->end_controls_tab(); // Normal Tab end

                $this->start_controls_tab(
                    'title_style_hover_tab',
                    [
                        'label' => __( 'Hover', 'edumodo' ),
                    ]
                );
                $this->add_control(
                    'title_hover_color',
                    [
                        'label' => __( 'Color', 'edumodo' ),
                        'type' => Controls_Manager::COLOR,
                        'default'=>'',
                        'selectors' => [
                            '{{WRAPPER}} .course a.course-title-link:hover' => 'color: {{VALUE}}',
                        ],
                    ]
                );

                $this->end_controls_tab(); // Hover Tab end

            $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
            'price_section_style',
                [
                    'label' => __( 'Price', 'edumodo' ),
                    'tab'   => Controls_Manager::TAB_STYLE,
                ]
            );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
                [   
                    'label' => __( 'Typography', 'edumodo' ),
                    'name' => 'price_typography',
                    'selector' => '{{WRAPPER}} .thumbnail.course .ld_course_grid_price',
                    'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                ]
        );

        $this->add_control(
            'price_color',
            [
                'label'     => __( 'Price Color', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thumbnail.course .ld_course_grid_price' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'price_bg_color',
            [
                'label'     => __( 'Price Background Color', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thumbnail.course .ld_course_grid_price' => 'Background: {{VALUE}};',
                    '{{WRAPPER}} .thumbnail.course .ld_course_grid_price:before' => 'border-top-color: {{VALUE}}; border-right-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'read_more_section_style',
                [
                    'label' => __( 'Read More', 'edumodo' ),
                    'tab'   => Controls_Manager::TAB_STYLE,
                ]
            );

        $this->add_control(
            'read_more_color',
            [
                'label'     => __( 'Read More', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} #ld_course_list .btn, .ld_course_grid_button .btn' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} #ld_course_list .btn-primary, .ld_course_grid_button .btn-primary' => 'border-color: {{VALUE}} !important;',
                    '{{WRAPPER}} #ld_course_list .btn-primary:hover, .ld_course_grid_button .btn-primary:hover' => 'border-color: {{VALUE}} !important; Background: {{VALUE}} !important;',
                ],
            ]
        );

        $this->end_controls_section();

	}

	protected function render() {
		require EDUMODO_CORE_ROOT . '/elements/ld-dynamic-category/template/view.php';
	}


}
