<?php
// Silence is golden.

    $settings = $this->get_settings();

    // Global Options
    global $post;
     // Prefix
    $prefix = '_edumodo_';

    $show_hide_post_date = $settings['show_hide_post_date'];
    $show_hide_post_cat = $settings['show_hide_post_cat'];
    $latest_title_word = $settings['latest_title_word'];
    $excerpt_word = $settings['latest_excerpt_word'];
    $btn_enable = $settings['button_enable'];
    $btn_text = $settings['btn_text'];

?>

    <div class="edumodo-latest-posts kindergarten">
         <div class="row">
                <?php
                    $blog = array(
                        'post_type'         => 'post',
                        'posts_per_page'    => $settings['posts_per_page'],
                        'ignore_sticky_posts' => 1
                    );

                    $blog_query = new WP_Query( $blog );
                        if($blog_query->have_posts()):
                            while($blog_query->have_posts()): 
                                $blog_query->the_post(); 
                ?>

                <div class="col-md-<?php echo $settings['posts_column']; ?> col-sm-6 blog-content-wrapper">
                    <article id="post-<?php the_ID(); ?>" <?php post_class('latest-posts-2'); ?>>


                            <figure class="post-thumbnail">
                                <a href="<?php the_permalink(); ?>">
                                    <?php  the_post_thumbnail();?>
                                </a>
                            </figure>

                        <div class="post-content-body">
                                
                            <header class="entry-header">
                                <h4 class="post-entry-title">
                                    <a href="<?php the_permalink();?>">
                                       <?php echo wp_trim_words( get_the_title(), $latest_title_word, ''); ?>      
                                    </a>
                                </h4>       
                            </header>
                            <?php if ($show_hide_post_date or $show_hide_post_cat) : ?>
                            <div class="entry-meta">
                                <?php if ($show_hide_post_date) : ?>
                                  <div class="post-date">
                                    <?php 
                                        $archive_year  = get_the_time('Y'); 
                                        $archive_month = get_the_time('m'); 
                                        $archive_day   = get_the_time('d'); 
                                    ?>
                                <a href="<?php echo get_day_link( $archive_year, $archive_month, $archive_day); ?>"><?php echo get_the_date('M j, Y'); ?></a>   
                                </div>
                                <?php endif; ?>
                                <?php if ($show_hide_post_cat) : ?>
                                <div class="post-cat">
                                    <?php the_category(); ?>
                                </div>
                                <?php endif; ?>
                            </div>
                            <?php endif; ?>

                            <div class="entry-content">
                                 <p><?php echo wp_trim_words(get_the_excerpt(), $excerpt_word , ''); ?></p>
                            </div>
                            <?php if ($btn_enable == 'yes' && $btn_text) : ?>
                            <footer class="blog-entry-footer">
                                <div class="blog-btn">
                                    <a href="<?php the_permalink();?>"><?php esc_html_e( $btn_text, 'edumodo') ?></a>   
                                </div>
                            </footer>
                            <?php endif; ?>
                        </div>
               
                    </article>
                </div> 

            <?php endwhile; wp_reset_postdata(); endif; ?>
        </div>  
    </div> 
