<?php
// Silence is golden.

    $settings = $this->get_settings();

    // Global Options
    global $post;
     // Prefix
    $prefix = '_edumodo_';

    $show_hide_post_author = $settings['show_hide_post_date'];
    $show_hide_date = $settings['show_hide_post_author'];
    $latest_title_word = $settings['latest_title_word'];
    $excerpt_word = $settings['latest_excerpt_word'];
    $btn_enable = $settings['button_enable'];
    $btn_text = $settings['btn_text'];


    $blog = array(
        'post_type'         => 'post',
        'posts_per_page'    => $settings['posts_per_page'],
        'ignore_sticky_posts' => 1
    );


?>

        <div class="edumodo-latest-posts">
            <div class="row">
                <?php

                    $blog_query = new WP_Query( $blog );
                        if($blog_query->have_posts()):
                            while($blog_query->have_posts()): 
                                $blog_query->the_post(); 
                ?>

                <div class="edumodo-blog-content-wrapper col-md-<?php echo $settings['posts_column']; ?> col-sm-6">
                    <article id="post-<?php the_ID(); ?>" <?php post_class('latest-posts-1'); ?>>
                        <figure class="post-thumbnail">
                            <a href="<?php the_permalink(); ?>">
                                <?php  the_post_thumbnail();?>
                            </a>
                        </figure>

                        <div class="post-content-body">
                            <header class="entry-header">
                                <div class="entry-meta">
                                    <?php if ($show_hide_post_author == 'yes') : ?>
                                        
                                        <span class="post-author">
                                            <i class="glyph-icon flaticon-user-2"></i> <a href="<?php get_the_author_link(); ?>"><?php the_author(); ?></a>
                                        </span>
                                    <?php endif ?>
                                    <?php if ($show_hide_date == 'yes') : ?>
                                        <span class="post-date">
                                            <?php 
                                                $archive_year  = get_the_time('Y'); 
                                                $archive_month = get_the_time('m'); 
                                                $archive_day   = get_the_time('d'); 
                                            ?>
                                            <i class="glyph-icon flaticon-calendar-with-spring-binder-and-date-blocks"></i>
                                            <a href="<?php echo get_day_link( $archive_year, $archive_month, $archive_day); ?>">
                                                <?php echo get_the_date('M j, Y'); ?>
                                            </a>   
                                        </span>
                                    <?php endif; ?>
                                </div>
                                <h4 class="post-entry-title">
                                    <a href="<?php the_permalink();?>">
                                       <?php echo wp_trim_words( get_the_title(), $latest_title_word, ''); ?>      
                                    </a>
                                </h4>       
                            </header><!-- .entry-header -->

                            <div class="entry-content">
                                 <p><?php echo wp_trim_words(get_the_excerpt(), $excerpt_word , ''); ?></p>
                            </div><!-- .entry-content -->

                            <?php if ($btn_enable == 'yes' && $btn_text ) : ?>
                                <footer class="blog-entry-footer">
                                    <span class="blog-btn">
                                        <a href="<?php the_permalink();?>"><?php esc_html_e( $btn_text, 'edumodo') ?><i class="glyph-icon flaticon-double-angle-pointing-to-right"></i></a>   
                                    </span>
                                </footer>
                            <?php endif; ?>    
                        </div><!-- .blog details -->
               
                    </article><!-- #post-## -->
                </div> <!-- /.col-md-4 -->

            <?php endwhile; wp_reset_postdata(); endif; ?>
        </div><!-- /.row -->     
    </div> <!-- /.div -->
