<?php
    use Elementor\Group_Control_Box_Shadow;
    use Elementor\Widget_Base;
    use Elementor\Controls_Manager;
    use Elementor\Scheme_Typography;
    use Elementor\Group_Control_Typography;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Edumodo Latest Post
 *
 * Elementor widget for edumodo latest post
 *
 * @since 1.0.0
 */
class Edumodo_Latest_Post extends Widget_Base {

	public function get_name() {
		return 'edumodo-latest-posts';
	}

	public function get_title() {
		return __( 'Latest Blog Posts', 'edumodo' );
	}

	public function get_icon() {
		return 'eicon-post-content';
	}

	public function get_categories() {
		return [ 'edumodo' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
	public function get_script_depends() {
		return [ 'edumodo-latest-posts' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Query', 'edumodo' ),
			]
		);

            $this->add_control(
                'blog_layout',
                [
                    'label' => __('Select Layout', 'edumodo'),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'layout_1',
                    'options' => [
                        'layout_1' => __('Layout 1', 'edumodo'),
                        'layout_2' => __('Layout 2', 'edumodo'),
                        // 'layout_3' => __('Layout 3', 'edumodo'),
                    ],
                ]
            );

            $this->add_control(
                'posts_per_page',
                [
                    'label' => __('Item to Show', 'edumodo'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 3,
                    'min' => -1,
                    'max' => 50,
                    'step' => 1,
                ]
            );

            $this->add_control(
                'items_order',
                [
                    'label' => esc_html__( 'Order', 'edumodo' ),
                    'type'  => Controls_Manager::SELECT,
                    'default'  => 'ASC',
                    'options'  => [
                        'ASC'  => esc_html__( 'Asscending', 'edumodo' ),
                        'DSC'  => esc_html__( 'Descending', 'edumodo' ),
                    ],
                ]
            );
            $this->add_control(
                'items_orderby',
                [
                    'label' => esc_html__( 'Orderby', 'edumodo' ),
                    'type'  => Controls_Manager::SELECT,
                    'default' => 'title',
                    'options' => [
                        'title'  => esc_html__( 'Title', 'edumodo' ),
                        'date'   => esc_html__( 'Date', 'edumodo' ),
                        'rand'   => esc_html__( 'Count', 'edumodo' ),
                        'ID'     => esc_html__( 'Id', 'edumodo' ),
                        'name'   => esc_html__( 'Name', 'edumodo' ),
                        'comment_count'  => esc_html__( 'Comment', 'edumodo' ),
                        'meta_value'     => esc_html__( 'Meta', 'edumodo' ),
                    ],
                ]
            );



            $this->add_control(
                'posts_column',
                [
                    'label' => __('Columns to Show', 'edumodo'),
                    'type' => Controls_Manager::SELECT,
                    'default' => '4',
                    'options' => [
                        '2'     => __('6', 'edumodo'),
                        '3'     => __('4', 'edumodo'),
                        '4'     => __('3', 'edumodo'),
                        '6'     => __('2', 'edumodo'),
                        '12'    => __('', 'edumodo'),
                    ],
                ]
            );

		$this->end_controls_section();

		$this->start_controls_section(
			'edumodo_section_title_typography',
			[
				'label' => __( 'Content', 'edumodo' ),
			]
		);
            $this->add_control(
                'content_author_heading',
                    [
                        'label' => __( 'Author', 'edumodo' ),
                        'type' => Controls_Manager::HEADING,
                        // 'separator' => 'before',
                        'condition' => [
                            'blog_layout' => 'layout_1',
                        ],
                    ]
            );

            $this->add_control(
                'show_hide_post_author',
                [
                    'label' => __( 'Display', 'edumodo' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'edumodo' ),
                    'label_off' => __( 'Hide', 'edumodo' ),
                    'return_value' => 'yes',
                    'condition' => [
                        'blog_layout' => 'layout_1',
                    ],
                    'separator' => 'after',
                ]
            );

            $this->add_control(
                'content_date_heading',
                    [
                        'label' => __( 'Date', 'edumodo' ),
                        'type' => Controls_Manager::HEADING,
                        // 'separator' => 'before',
                    ]
            );
            $this->add_control(
                'show_hide_post_date',
                [
                    'label' => __( 'Display', 'edumodo' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'edumodo' ),
                    'label_off' => __( 'Hide', 'edumodo' ),
                    'return_value' => 'yes',
                ]

            );
            $this->add_control(
                'content_category_heading',
                    [
                        'label' => __( 'Category', 'edumodo' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                        'condition' => [
                            'blog_layout' => 'layout_2',
                        ],
                    ]
            );

            $this->add_control(
                'show_hide_post_cat',
                [
                    'label' => __( 'Display', 'edumodo' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'edumodo' ),
                    'label_off' => __( 'Hide', 'edumodo' ),
                    'return_value' => 'yes',
                    'condition' => [
                         'blog_layout' => 'layout_2',
                    ],
                ]

            );


            $this->add_control(
                'content_title_heading',
                    [
                        'label' => __( 'Title', 'edumodo' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                    ]
            );


            $this->add_control(
                'latest_title_word',
                [
                    'label' => __('Word Count', 'edumodo'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 7,
                    'min' => 1,
                    'max' => 50,
                    'step' => 1,
                ]
            );

            $this->add_control(
                'content_desc_heading',
                    [
                        'label' => __( 'Description', 'edumodo' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                    ]
            );
            $this->add_control(
                'latest_excerpt_word',
                [
                    'label' => __('Word Count', 'edumodo'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 15,
                    'min' => 1,
                    'max' => 300,
                    'step' => 1,
                ]
            );


		$this->end_controls_section();


		$this->start_controls_section(
			'section_read_more',
			[
				'label' => __( 'Button', 'edumodo' ),
			]
		);

          $this->add_control(
            'button_enable',
            [
                'label' => __( 'Display', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
            ]

        );

            $this->add_control(
                'btn_text',
                [
                    'label' => __( 'Text', 'edumodo' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Read More', 'edumodo' ),
                    'placeholder' => __( 'Read More', 'edumodo' ),
                    'condition' => [
                        'button_enable' => 'yes',
                    ]
                ]
            );

		$this->end_controls_section();

        // Style
        $this->start_controls_section(
            'section_style',
                [
                    'label' => __( 'Content', 'edumodo' ),
                    'tab'   => Controls_Manager::TAB_STYLE,
                ]
        );
            $this->add_control(
                'content_style_meta_heading',
                    [
                        'label' => __( 'Author & Date', 'edumodo' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                    ]
            );

            $this->add_control(
                'latest_post_date_color',
                 [
                     'label'     => __( 'Color', 'edumodo' ),
                     'type'      => Controls_Manager::COLOR,
                     'selectors' => [
                         '{{WRAPPER}} .edumodo-latest-posts .latest-posts-1 .post-content-body .entry-meta, {{WRAPPER}} .edumodo-latest-posts .latest-posts-1 .post-content-body .entry-meta a, {{WRAPPER}} .edumodo-latest-posts.kindergarten .latest-posts-2 .post-content-body .entry-meta .post-date a' => 'color: {{VALUE}};',
                     ],
                 ]
            );
        
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'meta_typography',
                    'selector' => '.edumodo-latest-posts .latest-posts-1 .post-content-body .entry-meta, .edumodo-latest-posts .latest-posts-1 .post-content-body .entry-meta i, .edumodo-latest-posts .latest-posts-1 .post-content-body .entry-meta a, .edumodo-latest-posts.kindergarten .latest-posts-2 .post-content-body .entry-meta',
                    'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                ]
            );


            $this->add_control(
                'content_style_heading',
                    [
                        'label' => __( 'Title', 'edumodo' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                    ]
            );

            $this->add_control(
                'title_color',
                [
                    'label'     => __( 'Color', 'edumodo' ),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => '',
                    'selectors' => [
                        '{{WRAPPER}} .edumodo-latest-posts .latest-posts-1 .post-content-body .post-entry-title a' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .edumodo-latest-posts.kindergarten .latest-posts-2 .post-content-body .post-entry-title a' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'edumodo_title_typography',
                    'selector' => '{{WRAPPER}} .edumodo-latest-posts .latest-posts-1 .post-content-body .post-entry-title, {{WRAPPER}} .edumodo-latest-posts.kindergarten .latest-posts-2 .post-content-body .post-entry-title',
                    'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                ]
            );
            $this->add_control(
                'title_hover_color',
                [
                    'label'     => __( 'Hover Color', 'edumodo' ),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => '',
                    'selectors' => [
                        '{{WRAPPER}} .edumodo-latest-posts .latest-posts-1 .post-content-body .post-entry-title a:hover, {{WRAPPER}} .edumodo-latest-posts.kindergarten .latest-posts-2 .post-content-body .post-entry-title a:hover' => 'color: {{VALUE}} !important;',
                    ],
                ]
            );


            $this->add_responsive_control(
                'title_margin',
                [
                    'label' => __( 'Spacing', 'edumodo' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'allowed_dimensions' =>['top', 'bottom'],
                    'size_units' => [ 'px', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .edumodo-latest-posts .latest-posts-1 .post-content-body .post-entry-title, {{WRAPPER}} .edumodo-latest-posts.kindergarten .latest-posts-2 .post-content-body .post-entry-title' => 'margin: {{TOP}}{{UNIT}} 0 {{BOTTOM}}{{UNIT}} 0;',
                    ],
                ]
            );

            $this->add_control(
                'content_desc_style',
                    [
                        'label' => __( 'Description', 'edumodo' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                    ]
            );
            $this->add_control(
                'letest_desc_color',
                [
                    'label'     => __( 'Color', 'edumodo' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .edumodo-latest-posts .latest-posts-1 .post-content-body .entry-content,
                        {{WRAPPER}} .edumodo-latest-posts.kindergarten .latest-posts-2 .post-content-body .entry-content' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'desc_typography',
                    'selector' => '{{WRAPPER}} .edumodo-latest-posts .latest-posts-1 .post-content-body .entry-content, {{WRAPPER}} .edumodo-latest-posts.kindergarten .latest-posts-2 .post-content-body .entry-content',
                    'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                ]
            );

            $this->add_responsive_control(
                'desc_margin',
                [
                    'label' => __( 'Spacing', 'edumodo' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'allowed_dimensions' =>['top', 'bottom'],
                    'size_units' => [ 'px', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .edumodo-latest-posts .latest-posts-1 .post-content-body .entry-content, {{WRAPPER}} .edumodo-latest-posts.kindergarten .latest-posts-2 .post-content-body .entry-content' => 'margin: {{TOP}}{{UNIT}} 0 {{BOTTOM}}{{UNIT}} 0;',
                    ],
                ]
            );

            $this->add_control(
                'content_global_style',
                    [
                        'label' => __( 'Global', 'edumodo' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                    ]
            );

            $this->add_control(
                'bg_color',
                [
                    'label'     => __( 'Background', 'edumodo' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .edumodo-latest-posts .latest-posts-1, {{WRAPPER}} .edumodo-latest-posts.kindergarten .latest-posts-2' => 'background-color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name'    => 'layout_box_shadow',
                    'label'     => esc_html__( 'Normal Box Shadow', 'widgetkit-pro' ),
                    'selector' => '{{WRAPPER}} .edumodo-latest-posts .latest-posts-1, {{WRAPPER}} .edumodo-latest-posts.kindergarten .latest-posts-2',
                ]
            );

            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name'    => 'layout_hover_box_shadow',
                    'label'     => esc_html__( 'Hover Box Shadow', 'widgetkit-pro' ),
                    'selector' => '{{WRAPPER}} .edumodo-latest-posts .latest-posts-1:hover, {{WRAPPER}} .edumodo-latest-posts.kindergarten .latest-posts-2:hover',
                ]
            );


            $this->add_responsive_control(
                'content_padding',
                [
                    'label'      => __('Padding', 'reptro'),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .edumodo-latest-posts .latest-posts-1 .post-content-body, {{WRAPPER}} .edumodo-latest-posts.kindergarten .latest-posts-2 .post-content-body' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'content_border_radius',
                [
                    'label' => esc_html__( 'Radius', 'widgetkit-pro' ),
                    'type'  => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .edumodo-latest-posts .latest-posts-1, {{WRAPPER}} .edumodo-latest-posts.kindergarten .latest-posts-2' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow:hidden;',
                        '{{WRAPPER}} .edumodo-latest-posts .latest-posts-1 .post-thumbnail a img, {WRAPPER}} .edumodo-latest-posts.kindergarten .latest-posts-2 figure.post-thumbnail img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} 0 0; ',
                        
                    ],
                ]
            );

            $this->add_responsive_control(
                'content_layout_align',
                [
                    'label' => esc_html__( 'Alignment', 'edumodo' ),
                    'type'  => Controls_Manager::CHOOSE,
                    'default'   =>'' ,
                    'options'   => [
                        'left'    => [
                            'title' => esc_html__( 'Left', 'edumodo' ),
                            'icon'  => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'edumodo' ),
                            'icon'  => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'edumodo' ),
                            'icon'  => 'eicon-text-align-left',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .edumodo-latest-posts .latest-posts-1 .post-content-body' => 'text-align: {{VALUE}};',
                    ],
                    'condition' => [
                         'blog_layout' => 'layout_1',
                    ],
                ]
            );


    
        $this->end_controls_section();

        $this->start_controls_section(
            'section_button_style',
                [
                    'label' => __( 'Button', 'edumodo' ),
                    'tab'   => Controls_Manager::TAB_STYLE,
                    'condition' => [
                        'button_enable' => 'yes',
                    ],
                ]
        );
            $this->add_control(
                'read_more_btn_color',
                 [
                     'label'     => __( 'Color', 'edumodo' ),
                     'type'      => Controls_Manager::COLOR,
                     'selectors' => [
                            '{{WRAPPER}} .edumodo-latest-posts .latest-posts-1 .post-content-body .blog-btn a' => 'color: {{VALUE}};',
                         '{{WRAPPER}} .edumodo-latest-posts.kindergarten .latest-posts-2 .post-content-body .blog-btn a' => 'color: {{VALUE}};',
                     ],
                    'condition' => [
                        'button_enable' => 'yes',
                    ],
                 ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [   
                    'label' => __( 'Typography', 'edumodo' ),
                    'name' => 'read_more_btn_typography',
                    'selector' => '.edumodo-latest-posts .latest-posts-1 .post-content-body .blog-btn, .edumodo-latest-posts.kindergarten .latest-posts-2 .post-content-body .blog-btn',
                    'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                    'condition' => [
                        'button_enable' => 'yes',
                    ],
                ]
            );


            $this->add_control(
                'read_more_btn_hover_color',
                 [
                     'label'     => __( 'Hover Color', 'edumodo' ),
                     'type'      => Controls_Manager::COLOR,
                     'selectors' => [
                            '{{WRAPPER}} .edumodo-latest-posts .latest-posts-1 .post-content-body .blog-btn a:hover' => 'color: {{VALUE}};',
                         '{{WRAPPER}} .edumodo-latest-posts.kindergarten .latest-posts-2 .post-content-body .blog-btn a:hover' => 'color: {{VALUE}} !important;',
                     ],
                    'condition' => [
                        'button_enable' => 'yes',
                    ],
                 ]
            );

            $this->add_responsive_control(
                'btn_margin',
                [
                    'label' => __( 'Spacing', 'edumodo' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'allowed_dimensions' =>['top', 'bottom'],
                    'size_units' => [ 'px', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .edumodo-latest-posts .latest-posts-1 .post-content-body .blog-btn' => 'margin: {{TOP}}{{UNIT}} 0 {{BOTTOM}}{{UNIT}} 0;',
                        '{{WRAPPER}} .edumodo-latest-posts.kindergarten .latest-posts-2 .post-content-body .blog-btn' => 'padding: {{TOP}}{{UNIT}} 0 {{BOTTOM}}{{UNIT}} 0;',
                    ],
                    'condition' => [
                        'button_enable' => 'yes',
                    ],
                ]
            );

            $this->add_responsive_control(
                'icon_size',
                [
                    'label' => __( 'Icon Size', 'edumodo' ),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 600,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .edumodo-latest-posts .latest-posts-1 .post-content-body .blog-btn i' => 'font-size: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'button_enable' => 'yes',
                         'blog_layout' => 'layout_1',
                    ],
                ]
            );

        $this->end_controls_section();

	}

	protected function render() {
		require EDUMODO_CORE_ROOT . '/elements/latest-post/template/view.php';
	}


}
