<?php

//tribe_events
//tribe_venue
//tribe_organizer

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Edumodo Event 1
 *
 * Elementor widget for edumodo Event 1
 *
 * @since 1.0.0
 */
class Edumodo_Event_Config extends Widget_Base {

	public function get_name() {
		return 'edumodo-event';
	}

	public function get_title() {
		return __( 'Event One', 'edumodo' );
	}

	public function get_icon() {
		return ' eicon-call-to-action';
	}

	public function get_categories() {
		return [ 'edumodo' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
//	public function get_script_depends() {
//		return [ 'edumodo-blog-1' ];
//	}

	protected function _register_controls() {
        $this->start_controls_section(
            'section_title',
            [
                'label' => __( 'Query', 'edumodo' ),
            ]
        );
        // $this->add_control(
        //     'posts_column',
        //     [
        //         'label' => __('Query Type', 'edumodo'),
        //         'type' => Controls_Manager::SELECT,
        //         'default' => '4',
        //         'options' => [
        //             'specific-event' => esc_html__('Specific Event', 'edumodo'),
        //             'latest-event' => esc_html__('Latest Event', 'edumodo'),
        //         ],
        //     ]
        // );
        $this->add_control(
            'posts_per_page',
            [
                'label' => __('Event to Show', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 3,
                'min' => 1,
                'max' => 20,
                'step' => 1,
            ]
        );
        $this->add_control(
            'event_column',
            [
                'label' => __('Column to Show', 'edumodo'),
                'type' => Controls_Manager::SELECT,
                'default' => '4',
                'options' => [
                    '2' => esc_html__('6', 'edumodo'),
                    '3' => esc_html__('4', 'edumodo'),
                    '4' => esc_html__('3', 'edumodo'),
                    '6' => esc_html__('2', 'edumodo'),
                    '12' => esc_html__('1', 'edumodo'),
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_content',
            [
                'label' => __( 'Content', 'edumodo' ),
            ]
        );

        $this->add_control(
            'content_thumbnail_heading',
                [
                'label' => __( 'Thumbnail', 'edumodo' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                ]
        );

        $this->add_control(
            'show_thumbnail',
            [
                'label' => __( 'Display', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'thumbnail_size',
            [
                'label'       => __( 'Size', 'edumodo' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'large',
                'options' => [
                    'thumbnail'  => __( 'Thumbnail', 'edumodo' ),
                    'medium'  => __( 'Medium', 'edumodo' ),
                    'medium_large'  => __( 'Medium Large', 'edumodo' ),
                    'large'  => __( 'Large', 'edumodo' ),
                    'full'  => __( 'Full', 'edumodo' ),
                ],
                'condition'   => [
                    'show_thumbnail' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'thumbnail_position',
                [
                    'label' => __( 'Position', 'edumodo' ),
                    'type' => Controls_Manager::CHOOSE,
                    'default' => 'bottom',
                    'options' => [
                        'top' => [
                            'title' => __( 'Top', 'edumodo' ),
                            'icon' => 'eicon-v-align-top',
                        ],
                        'middle' => [
                            'title' => __( 'Middle', 'edumodo' ),
                            'icon' => 'eicon-h-align-center',
                        ],
                        'bottom' => [
                            'title' => __( 'Bottom', 'edumodo' ),
                            'icon' => 'eicon-v-align-bottom',
                        ],
                    ],
                    'toggle' => false,
                    'condition'   => [
                        'show_thumbnail' => 'yes',
                    ],
                ]
            );

        $this->add_control(
            'content_title_heading',
                [
                'label' => __( 'Title', 'edumodo' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                ]
        );

        $this->add_control(
            'title_word',
            [
                'label' => __('Word Count', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 4,
                'min' => 1,
                'max' => 20,
                'step' => 1,
            ]
        );

        $this->add_control(
            'content_description_heading',
                [
                'label' => __( 'Description', 'edumodo' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                ]
        );

        $this->add_control(
            'excerpt_word',
            [
                'label' => __('Word Count', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 20,
                'min' => 5,
                'max' => 100,
                'step' => 1,
            ]
        );
        $this->end_controls_section();


        $this->start_controls_section(
            'section_button',
            [
                'label' => __( 'Button', 'edumodo' ),
            ]
        );

            $this->add_control(
                'show_button',
                [
                    'label' => __( 'Display', 'edumodo' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'edumodo' ),
                    'label_off' => __( 'Hide', 'edumodo' ),
                    'return_value' => 'yes',
                ]
            );
            $this->add_control(
                'button_text',
                    [
                        'label' => __( 'Text', 'edumodo' ),
                        'type' => Controls_Manager::TEXT,
                        'default' => __( 'Read More', 'edumodo'),
                        'condition'   => [
                            'show_button' => 'yes',
                        ],
                    ]
            );



        $this->end_controls_section();

        $this->start_controls_section(
            'section_meta',
            [
                'label' => __( 'Meta', 'edumodo' ),
            ]
        );
            $this->add_control(
                'meta_position',
                    [
                        'label' => __( 'Position', 'edumodo' ),
                        'type' => Controls_Manager::CHOOSE,
                        'default' => 'top',
                        'options' => [
                            'top' => [
                                'title' => __( 'Top', 'edumodo' ),
                                'icon' => 'eicon-v-align-top',
                            ],
                            'middle' => [
                                'title' => __( 'Bottom Title', 'edumodo' ),
                                'icon' => 'eicon-h-align-center',
                            ],
                            'bottom' => [
                                'title' => __( 'Bottom', 'edumodo' ),
                                'icon' => 'eicon-v-align-bottom',
                            ],
                        ],
                        'toggle' => false,
                    ]
             );
        $this->end_controls_section();


        $this->start_controls_section(
            'section_style',
            [
                'label' => __( 'Content', 'edumodo' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'content_title_styling',
                    [
                    'label' => __( 'Title', 'edumodo' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    ]
            );


            $this->add_control(
                'title_color',
                [
                    'label'     => __( 'Color', 'edumodo' ),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => '#fff',
                    'selectors' => [
                        '{{WRAPPER}} .edumodo-event-1 .event-wrapper .e-event-title h2' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'selector' => '{{WRAPPER}} .edumodo-event-1 .event-wrapper .e-event-title h2',
                    'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                ]
            );


            $this->add_control(
                'title_hover_color',
                [
                    'label'     => __( 'Hover Color', 'edumodo' ),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => '',
                    'selectors' => [
                        '{{WRAPPER}} .edumodo-event-1 .event-wrapper .e-event-title:hover h2' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'content_description_styling',
                    [
                    'label' => __( 'Description', 'edumodo' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    ]
            );
            $this->add_control(
                'content_color',
                [
                    'label'     => __( 'Color', 'edumodo' ),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => '#fff',
                    'selectors' => [
                        '{{WRAPPER}} .edumodo-event-1 .event-wrapper .e-single-event .e-event-description' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'content_typography',
                    'selector' => '{{WRAPPER}} .edumodo-event-1 .event-wrapper .e-single-event .e-event-description',
                    'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                ]
            );

            $this->add_control(
                'content_global_style',
                    [
                    'label' => __( 'Global', 'edumodo' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    ]
            );
            $this->add_responsive_control(
                'content_padding',
                [
                    'label' => esc_html__( 'Padding', 'edumodo' ),
                    'type'  => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors'  => [
                        '{{WRAPPER}} .edumodo-event-1 .event-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'content_layout_align',
                [
                    'label' => esc_html__( 'Alignment', 'edumodo' ),
                    'type'  => Controls_Manager::CHOOSE,
                    'default'   =>'' ,
                    'options'   => [
                        'left'    => [
                            'title' => esc_html__( 'Left', 'edumodo' ),
                            'icon'  => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'edumodo' ),
                            'icon'  => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'edumodo' ),
                            'icon'  => 'eicon-text-align-left',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .edumodo-event-1 .event-wrapper' => 'text-align: {{VALUE}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'content_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'edumodo' ),
                    'type'  => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors'  => [
                        '{{WRAPPER}} .edumodo-event-1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow:hidden;',
                    ],
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_button',
            [
                'label' => __( 'Button', 'edumodo' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition'   => [
                    'show_button' => 'yes',
                ],
            ]
        );
            $this->add_control(
                'button_color',
                [
                    'label'     => __( 'Color', 'edumodo' ),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => '',
                    'selectors' => [
                        '{{WRAPPER}} .edumodo-event-1 .event-wrapper .e-single-event .link-to-main-post' => 'color: {{VALUE}};',
                    ],
                    'condition'   => [
                        'show_button' => 'yes',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'button_typography',
                    'selector' => '{{WRAPPER}} .edumodo-event-1 .event-wrapper .e-single-event .link-to-main-post',
                    'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                    'condition'   => [
                        'show_button' => 'yes',
                    ],
                ]
            );

            $this->add_control(
                'button_hover_color',
                [
                    'label'     => __( 'Hover Color', 'edumodo' ),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => '',
                    'selectors' => [
                        '{{WRAPPER}} .edumodo-event-1 .event-wrapper .e-single-event .link-to-main-post:hover' => 'color: {{VALUE}};',
                    ],
                    'condition'   => [
                        'show_button' => 'yes',
                    ],
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_meta',
            [
                'label' => __( 'Meta', 'edumodo' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'meta_color',
            [
                'label'     => __( 'Color', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .edumodo-event-1 .event-wrapper .e-single-event .e-event-time' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'meta_typography',
                'selector' => '{{WRAPPER}} .edumodo-event-1 .event-wrapper .e-single-event .e-event-time',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );
        $this->end_controls_section();
	}

	protected function render() {
        $settings = $this->get_settings();
        $number_of_post = $settings['posts_per_page'];
        $title_word = $settings['title_word'];
        $excerpt_word = $settings['excerpt_word'];
        // $column_number = 12 / $number_of_post;
        $show_thumbnail = $settings['show_thumbnail'];
        $thumbnail_position = $settings['thumbnail_position'];

        $show_button = $settings['show_button'];
        $button_text = $settings['button_text'];

        $meta_position = $settings['meta_position'];


        $args = array(
            'post_type' => 'tribe_events',
            'posts_per_page' => $number_of_post,
            'ignore_sticky_posts' => 1,

        );

        $query = new WP_Query($args);

        if($query->have_posts() and class_exists( 'Tribe__Events__Main' ) ):?>
            <div class="edumodo-event-1">
                <div class="row">
                    <?php while($query->have_posts()):
                        $query->the_post();
                        $event_color = get_post_meta(get_the_ID(),  '_edumodo_event_color');
                        $time_format = get_option( 'time_format', Tribe__Date_Utils::TIMEFORMAT );
                        $time_range_separator = tribe_get_option( 'timeRangeSeparator', ' - ' );

                        $start_datetime = tribe_get_start_date();
                        $start_date = tribe_get_start_date( null, false );
                        $start_time = tribe_get_start_date( null, false, $time_format );
                        $start_ts = tribe_get_start_date( null, false, Tribe__Date_Utils::DBDATEFORMAT );

                        $end_datetime = tribe_get_end_date();
                        $end_date = tribe_get_display_end_date( null, false );
                        $end_time = tribe_get_end_date( null, false, $time_format );
                        $end_ts = tribe_get_end_date( null, false, Tribe__Date_Utils::DBDATEFORMAT );
                    ?>

                    <div class="col-md-<?php echo $settings['event_column'];?> col-sm-6"
                        <?php if($event_color[0]):?>
                        style="
                                background-color:<?php echo $event_color[0]; ?>
                                ">
                        <?php endif;?>
                        <div class="event-wrapper">
                            <div class="e-single-event">
                                <?php if($show_thumbnail == 'yes' && $thumbnail_position == 'top' ): ?>
                                    <div class="featured-image e-featured-image image-<?php echo $thumbnail_position; ?>">
                                        <a href="<?php the_permalink() ?>">
                                            <?php if(has_post_thumbnail()): ?>
                                                <?php the_post_thumbnail($settings['thumbnail_size']); ?>
                                            <?php endif; ?>
                                        </a>
                                    </div>
                                <?php endif; ?>

                                <?php if($start_date && $meta_position == 'top' ):?>
                                    <div class="e-event-time date-<?php echo $meta_position; ?>">
                                        <i class="glyph-icon flaticon-calendar-with-spring-binder-and-date-blocks"></i>
                                        <span><?php echo $start_date; ?></span>
                                    </div>
                                <?php endif;?>
                         
                                <a href="<?php the_permalink() ?>" class="edumodo-title e-event-title">
                                    <h2><?php echo wp_trim_words(get_the_title(), $title_word, ''); ?></h2>
                                </a>


                                <?php if($start_date && $meta_position == 'middle' ):?>
                                    <div class="e-event-time date-<?php echo $meta_position; ?>">
                                        <i class="glyph-icon flaticon-calendar-with-spring-binder-and-date-blocks"></i>
                                        <span><?php echo $start_date; ?></span>
                                    </div>
                                <?php endif;?>

                                <?php if($show_thumbnail == 'yes' && $thumbnail_position == 'middle' ): ?>
                                    <div class="featured-image e-featured-image image-<?php echo $thumbnail_position; ?>">
                                        <a href="<?php the_permalink() ?>">
                                            <?php if(has_post_thumbnail()): ?>
                                                <?php the_post_thumbnail($settings['thumbnail_size']); ?>
                                            <?php endif; ?>
                                        </a>
                                    </div>
                                <?php endif; ?>

                                <div class="event-description e-event-description">
                                    <?php echo wp_trim_words(get_the_excerpt(), $excerpt_word , ''); ?>
                                </div>
                                <?php if($show_thumbnail == 'yes' && $thumbnail_position == 'bottom' ): ?>
                                    <div class="featured-image e-featured-image image-<?php echo $thumbnail_position; ?>">
                                        <a href="<?php the_permalink() ?>">
                                            <?php if(has_post_thumbnail()): ?>
                                                <?php the_post_thumbnail($settings['thumbnail_size']); ?>
                                            <?php endif; ?>
                                        </a>
                                    </div>
                                <?php endif; ?>

                                <?php if ($show_button == 'yes'): ?>
                                    <a href="<?php the_permalink() ?>" class="link-to-main-post">
                                        <?php echo $button_text; ?>
                                        <i class="glyph-icon fa fa-angle-double-right"></i>
                                    </a>
                                    
                                <?php endif; ?>

                                <?php if($start_date && $meta_position == 'bottom' ):?>
                                    <div class="e-event-time date-<?php echo $meta_position; ?>">
                                        <i class="glyph-icon flaticon-calendar-with-spring-binder-and-date-blocks"></i>
                                        <span><?php echo $start_date; ?></span>
                                    </div>
                                <?php endif;?>
                                </div>
                            </div>
                        </div>
                 
                    <?php endwhile; wp_reset_postdata();?>
                    </div>
                </div>

            <?php else: ?>
                <p> <?php _e( 'Sorry no post found. Please active & add event under The Event Calender Plugin' ); ?> </p>
           <?php  endif; 
	}
}
