<?php
/**
 * Tag name == Event-1 (for Less file)
 */
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Box_Shadow;

if (!defined('ABSPATH')) {
    exit;
}
// Exit if accessed directly

/**
 * tgx event Two
 *
 * Elementor widget for Event Two.
 *
 * @since 1.0.0
 */
class Widget_Event_Two extends Widget_Base
{

    public function get_name()
    {
        return 'widget-event-two';
    }

    public function get_title()
    {
        return __('Event Two', 'edumodo');
    }

    public function get_icon()
    {
        return ' eicon-call-to-action';
    }

    public function get_categories()
    {
        return ['edumodo'];
    }

    /**
     * A list of scripts that the widgets is depended in
     *
     * @since 1.3.0
     **/
    /*
    public function get_script_depends() {
    return [ 'imagesloaded' ];
    }
     */
    public function get_all_event_name_and_id()
    {
        $args = array(
            'post_type' => 'tribe_events',
        );
        $q = new WP_Query($args);
    }

    protected function _register_controls()
    {
        $args = array(
            'post_type'      => 'tribe_events',
            'posts_per_page' => -1,
        );
        $query       = new WP_Query($args);
        $event_names = array();
        $i = 0;
        foreach ($query->posts as $p):
            
            if ( 0 === $i ) {
                $event_names [0] = esc_html__( 'Select Events', 'edumodo' );
            }
            $event_names[$p->ID] = $p->post_title;
         $i++; endforeach;
       

        /* slides content title subtitle button and button link */
        $this->start_controls_section(
            'section_tab',
            [
                'label' => __('Query', 'edumodo'),
            ]
        );
        $this->add_control(
            'event_style',
            [
                'label'   => __('Style', 'edumodo'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'style_1',
                'options' => [
                    'style_1' => __('Style 1', 'edumodo'),
                    'style_2' => __('Style 2', 'edumodo'),
                ],
            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label' => __('Event to Show', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 3,
                'min' => 1,
                'max' => 20,
                'step' => 1,
            ]
        );

        $this->add_control(
            'event_id',
            [
                'label'   => __('Event ID', 'edumodo'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'default',
                'options' => $event_names,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_event_date',
            [
                'label' => __('Date', 'edumodo'),
            ]
        );

            $this->add_control(
                'show_date',
                [
                    'label' => __( 'Display', 'edumodo' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'edumodo' ),
                    'label_off' => __( 'Hide', 'edumodo' ),
                    'return_value' => 'yes',
                ]
            );

            $this->add_control(
                'date_position',
                [
                    'label'       => __( 'Position', 'edumodo' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'bottom-right',
                    'options' => [
                        'top-left'  => __( 'Top Left', 'edumodo' ),
                        'bottom-left'  => __( 'Bottom Left', 'edumodo' ),
                        'top-right'  => __( 'Top Right', 'edumodo' ),
                        'bottom-right'  => __( 'Bottom Right', 'edumodo' ),
                    ],
                    'condition'   => [
                        'show_date' => 'yes',
                        'event_style' => 'style_1',
                    ],
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Content', 'edumodo'),
            ]
        );
            $this->add_control(
                'content_thumbnail_heading',
                    [
                        'label' => __( 'Thumbnail', 'edumodo' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                        'condition'   => [
                            'event_style' => 'style_1',
                        ],
                    ]
            );


            $this->add_control(
                'image_position',
                    [
                        'label' => __( 'Position', 'edumodo' ),
                        'type' => Controls_Manager::CHOOSE,
                        'default' => 'left',
                        'options' => [
                            'left' => [
                                'title' => __( 'Left', 'edumodo' ),
                                'icon' => 'eicon-h-align-left',
                            ],
                            'right' => [
                                'title' => __( 'Right', 'edumodo' ),
                                'icon' => 'eicon-h-align-right',
                            ],
                        ],
                        'toggle' => false,
                    ]
            );

            $this->add_control(
                'content_title_heading',
                    [
                    'label' => __( 'Title', 'edumodo' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    ]
            );
            $this->add_control(
                'excerpt_title_word',
                [
                    'label'   => __('Word Count', 'edumodo'),
                    'type'    => Controls_Manager::NUMBER,
                    'default' => 12,
                    'min'     => 1,
                    'max'     => 80,
                    'step'    => 1,
                ]
            );
            $this->add_control(
                'content_description_heading',
                    [
                    'label' => __( 'Description', 'edumodo' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    ]
            );
            $this->add_control(
                'excerpt_desc_word',
                [
                    'label'   => __('Word Count', 'edumodo'),
                    'type'    => Controls_Manager::NUMBER,
                    'default' => 15,
                    'min'     => 1,
                    'max'     => 150,
                    'step'    => 1,
                ]
            );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_event_meta',
            [
                'label' => __('Meta', 'edumodo'),
            ]
        );
            $this->add_control(
                'show_meta',
                [
                    'label' => __( 'Display', 'edumodo' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'edumodo' ),
                    'label_off' => __( 'Hide', 'edumodo' ),
                    'return_value' => 'yes',
                ]
            );

            $this->add_control(
                'meta_position',
                    [
                        'label' => __( 'Position', 'edumodo' ),
                        'type' => Controls_Manager::CHOOSE,
                        'default' => 'bottom',
                        'options' => [
                            'top' => [
                                'title' => __( 'Top', 'edumodo' ),
                                'icon' => 'eicon-v-align-top',
                            ],
                            'bottom' => [
                                'title' => __( 'Bottom', 'edumodo' ),
                                'icon' => 'eicon-v-align-bottom',
                            ],
                        ],
                        'toggle' => false,
                        'condition'   => [
                            'show_meta' => 'yes',
                        ],
                    ]
             );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_date',
            [
                'label' => __('Date', 'edumodo'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition'   => [
                    'show_date' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'date_color',
            [
                'label'     => __('Color', 'edumodo'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .event-style-1 .event-wrapper .event-featured-image .events-date' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .event-style-1 .class-widget-event .row.event-wrapper .event-featured-image .events-date .only-day'        => 'color: {{VALUE}};',
                    '{{WRAPPER}} .event-style-1 .class-widget-event .row.event-wrapper .event-featured-image .events-date .only-month-year' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .event-style-2 .ed-event-left .events-date' => 'color: {{VALUE}};',
                ],
                'condition'   => [
                    'show_date' => 'yes',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'date_typography',
                'selector' => '{{WRAPPER}} .edumodo-event-2 .event-wrapper .event-featured-image .events-date .only-day, {{WRAPPER}} .event-style-2 .ed-event-left .events-date .only-day',
                'scheme'   => Scheme_Typography::TYPOGRAPHY_3,
                'condition'   => [
                    'show_date' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'date_bg_color',
            [
                'label'     => __('Background', 'edumodo'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .event-style-1 .event-wrapper .event-featured-image .events-date' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .event-style-2 .ed-event-left'     => 'background-color: {{VALUE}};',
                ],
                'condition'   => [
                    'show_date' => 'yes',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'month_year_typography',
                'label'    => __('Month Typography', 'edumodo'),
                'selector' => '{{WRAPPER}} .event-style-1 .event-wrapper .event-featured-image .events-date .only-month-year, {{WRAPPER}} .event-style-2 .ed-event-left .events-date .only-month-year',
                'scheme'   => Scheme_Typography::TYPOGRAPHY_3,
                'condition'   => [
                    'show_date' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'date_radius',
                [
                    'label'      => __('Border Radius', 'edumodo'),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .event-style-1 .event-wrapper .event-featured-image .events-date, {{WRAPPER}} .event-style-2 .ed-event-left' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition'   => [
                        'show_date' => 'yes',
                    ],
                ]
            );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_style_content',
            [
                'label' => __('Content', 'edumodo'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
           $this->add_control(
                'style_image_heading',
                    [
                        'label' => __( 'Image', 'edumodo' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                        'condition' => [
                            'event_style' => 'style_1',
                        ],
                    ]
            );

            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'image_box_shadow',
                    'selector' => '{{WRAPPER}} .event-style-1 .event-wrapper .event-featured-image .featured-image',
                    'condition' => [
                        'event_style' => 'style_1',
                    ],
                ]
            );

            $this->add_responsive_control(
                'image_radius',
                [
                    'label'      => __('Radius', 'edumodo'),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .event-style-1 .event-wrapper .event-featured-image .featured-image, {{WRAPPER}} .edumodo-event-2 .event-wrapper .event-featured-image .featured-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'event_style' => 'style_1',
                    ],
                    'separator' => 'after',
                ]
            );

            $this->add_control(
                'style_title_heading',
                    [
                    'label' => __( 'Title', 'edumodo' ),
                    'type' => Controls_Manager::HEADING,
                    
                    ]
            );

            $this->add_control(
                'title_color',
                [
                    'label'     => __('Color', 'edumodo'),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => '',
                    'selectors' => [
                        '{{WRAPPER}} .event-style-1 .event-wrapper .event-content .event-title .tgx-post-title' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .event-style-2 .ed-event-content a .ed-event-title' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typo',
                    'selector' => '{{WRAPPER}} .event-style-1 .event-wrapper .event-content .event-title .tgx-post-title, 
                    {{WRAPPER}} .event-style-2 .ed-event-content a .ed-event-title',
                    'scheme'   => Scheme_Typography::TYPOGRAPHY_3,
                ]
            );
            $this->add_control(
                'title_hover_color',
                [
                    'label'     => __('Hover Color', 'edumodo'),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => '',
                    'selectors' => [
                        '{{WRAPPER}} .event-style-1 .event-wrapper .event-content .event-title .tgx-post-title:hover' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .event-style-2 .ed-event-content a:hover .ed-event-title' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'title_spacing',
                [
                    'label'      => __('Spacing', 'edumodo'),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'allowed_dimensions' => ['top', 'bottom' ],
                    'selectors'  => [
                        '{{WRAPPER}} .event-style-1 .event-wrapper .event-content .event-title' => 'margin: {{TOP}}{{UNIT}} 0 {{BOTTOM}}{{UNIT}} 0;',
                        '{{WRAPPER}} .event-style-2 .ed-event-content a .ed-event-title' => 'margin: {{TOP}}{{UNIT}} 0 {{BOTTOM}}{{UNIT}} 0;',
                    ],
                ]
            );

            $this->add_control(
                'style_description_heading',
                    [
                    'label' => __( 'Description', 'edumodo' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    ]
            );

            $this->add_control(
                'desc_color',
                [
                    'label'     => __('Color', 'edumodo'),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => '',
                    'selectors' => [
                        '{{WRAPPER}} .event-style-1 .event-wrapper .event-content .event-excerpt, {{WRAPPER}} .event-style-2 .ed-event-excerpt' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typo',
                    'selector' => '{{WRAPPER}} .event-style-1 .event-wrapper .event-content .event-excerpt, {{WRAPPER}} .event-style-2 .ed-event-excerpt',
                    'scheme'   => Scheme_Typography::TYPOGRAPHY_3,
                ]
            );

            $this->add_control(
                'content_global_style',
                    [
                    'label' => __( 'Global', 'edumodo' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    ]
            );

            $this->add_control(
                'content_bg_color',
                [
                    'label'     => __('Background Color', 'edumodo'),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => '',
                    'selectors' => [
                        '{{WRAPPER}} .event-style-1 .event-wrapper' => 'background-color: {{VALUE}};',
                        '{{WRAPPER}} .event-style-2 .ed-event-right' => 'background-color: {{VALUE}};',
                    ],
                ]
            );


            $this->add_responsive_control(
                'margin',
                [
                    'label'      => __('Padding', 'edumodo'),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .event-style-1 .event-wrapper .event-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .event-style-2 .ed-event-right' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'padding',
                [
                    'label'      => __('Margin', 'edumodo'),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'allowed_dimensions' =>['top', 'bottom'],
                    'size_units' => ['px', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .event-style-1 .event-wrapper' => 'margin: {{TOP}}{{UNIT}} 0 {{BOTTOM}}{{UNIT}} 0;',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'content_box_shadow',
                    'selector' => '{{WRAPPER}} .event-style-2, {{WRAPPER}} .event-style-1 .event-wrapper'
                ]
            );

            $this->add_responsive_control(
                'content_radius',
                [
                    'label'      => __('Border Radius', 'edumodo'),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .event-style-1 .event-wrapper, {{WRAPPER}} .event-style-2 .ed-event-right' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};overflow:hidden;',
                        '{{WRAPPER}} .event-style-1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};overflow:hidden;',
                    ],
                ]
            );

            $this->add_responsive_control(
                'content_padding',
                    [
                        'label'      => __('Event Height', 'edumodo'),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 800,
                                'step' => 5,
                            ],
                            '%' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => 200,
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .event-style-2 .ed-event-column' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                        'condition' => [
                            'event_style' => 'style_2',
                        ],
                    ]
                );


        $this->end_controls_section();


        $this->start_controls_section(
            'section_style_meta',
            [
                'label' => __('Meta', 'edumodo'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition'   => [
                    'show_meta' => 'yes',
                ],
            ]
        );

            $this->add_control(
                'meta_color',
                [
                    'label'     => __('Color', 'edumodo'),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => '',
                    'selectors' => [
                        '{{WRAPPER}} .event-style-1 .event-wrapper .event-content .event-meta' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .event-style-2 .ed-event-content .event-meta' => 'color: {{VALUE}};',
                    ],
                    'condition'   => [
                        'show_meta' => 'yes',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'meta_typo',
                    'selector' => '{{WRAPPER}} .event-style-1 .event-wrapper .event-content .event-meta, {{WRAPPER}} .event-style-2 .ed-event-content .event-meta',
                    'scheme'   => Scheme_Typography::TYPOGRAPHY_3,
                    'condition'   => [
                        'show_meta' => 'yes',
                    ],
                ]
            );
            $this->add_responsive_control(
                'meta_spacing',
                [
                    'label'      => __('Spacing', 'edumodo'),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'allowed_dimensions' => ['top', 'bottom' ],
                    'selectors'  => [
                        '{{WRAPPER}} .event-style-1 .event-wrapper .event-content .event-meta, {{WRAPPER}} .event-style-2 .ed-event-content .event-meta' => 'margin: {{TOP}}{{UNIT}} 0 {{BOTTOM}}{{UNIT}} 0;',
                    ],
                    'condition'   => [
                        'show_meta' => 'yes',
                    ],
                ]
            );

        $this->end_controls_section();


    }

    protected function render()
    {

        $settings = $this->get_settings();
        if ($settings['event_style'] == 'style_1'):
            require EDUMODO_CORE_ROOT . '/elements/event-two/template/style1.php';
        elseif ($settings['event_style'] == 'style_2'):
            require EDUMODO_CORE_ROOT . '/elements/event-two/template/style2.php';
        endif;
    }

    protected function _content_template()
    {

    }
}
