<?php
/*
Plugin Name: Edumodo Core
Description: Huge collection of custom widgets, neatly bundled into a single plugin. It's also a framework to code your own widgets to help you make any kind of page.
Version: 3.1.0
Text Domain: edumodo
Domain Path: edumodo/languages
Author: ThemesGrove
Author URI: https://themexpert.com/
Plugin URI: https://themexpert.com/wordpress-plugins
License: GPL3
License URI: https://www.gnu.org/licenses/gpl-3.0.txt
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}
define('EDUMODO_CORE_VERSION', '2.6.4');
/**
 *
 * Plugin DocRoot absolute path without trailing slash
 *
 */

define('EDUMODO_BUNDLE_BASE_FILE', __FILE__);
define('EDUMODO_CORE_ROOT', untrailingslashit(plugin_dir_path(__FILE__)));

// helper functions
require_once EDUMODO_CORE_ROOT . '/elements/helper-functions.php';

// Some Includes functions
require_once EDUMODO_CORE_ROOT . '/includes/query-functions.php';

/**
 * Load plugin
 *
 * Load the text domain and hook up the CPTs
 *
 */

function edumodo_core_load(){

    // Let's add some CPTs
    Edumodo_CPT_Course::init();
    Edumodo_CPT_Teacher::init();
    Edumodo_CPT_Notice::init();
    Edumodo_CPT_Testimonial::init();

    // Let's add some sohrtcode
    Edumodo_Shortcode_Course_Info::init();
    Edumodo_Shortcode_Testimonial::init();
    Edumodo_Shortcode_Related_Posts::init();
    Edumodo_Shortcode_Recent_Post::init();
    Edumodo_Shortcode_Course_Teacher::init();
    Edumodo_Shortcode_Course_Enroll::init();
    Edumodo_Shortcode_Follow_Us::init();
    Edumodo_Shortcode_QuickInfo::init();
    Edumodo_Shortcode_Mailchimp::init();

}

add_action('plugins_loaded', 'edumodo_core_load');

/**
 *
 * Meta boxes
 *
 */

// Edumodo metabox
require_once EDUMODO_CORE_ROOT . '/metaboxes/theme-metabox.php';
// Page metabox
require_once EDUMODO_CORE_ROOT . '/metaboxes/theme-page-metabox.php';
// Event Metabox
require_once EDUMODO_CORE_ROOT . '/metaboxes/theme-event-metabox.php';
// Attached posts for course teacher
require_once EDUMODO_CORE_ROOT . '/libs/cmb2-attached-posts/cmb2-attached-posts-field.php';
// Blog Post Metabox
require_once EDUMODO_CORE_ROOT . '/libs/cmb2-conditionals/cmb2-conditionals.php';
// Post metabox
require_once EDUMODO_CORE_ROOT . '/metaboxes/theme-blog-post-metabox.php';

/**
 *
 * Post types
 *
 */

// Course post types
require_once EDUMODO_CORE_ROOT . '/post-types/custom-course.php';
// Teachers post types
require_once EDUMODO_CORE_ROOT . '/post-types/custom-teacher.php';
// Notice post types
require_once EDUMODO_CORE_ROOT . '/post-types/custom-notice.php';
// Testimonial post types
require_once EDUMODO_CORE_ROOT . '/post-types/custom-testimonial.php';

/**
 *
 *  Shortcode
 *
 */

require_once EDUMODO_CORE_ROOT . '/shortcodes/shortcode-course-info.php';
require_once EDUMODO_CORE_ROOT . '/shortcodes/shortcode-testimonial.php';
require_once EDUMODO_CORE_ROOT . '/shortcodes/shortcode-related-posts.php';
require_once EDUMODO_CORE_ROOT . '/shortcodes/shortcode-recent-post.php';
require_once EDUMODO_CORE_ROOT . '/shortcodes/shortcode-course-teacher.php';
require_once EDUMODO_CORE_ROOT . '/shortcodes/shortcode-enroll-btn.php';
require_once EDUMODO_CORE_ROOT . '/shortcodes/shortcode-follow-us.php';
require_once EDUMODO_CORE_ROOT . '/shortcodes/shortcode-quick-info.php';
require_once EDUMODO_CORE_ROOT . '/shortcodes/shortcode-mailchimp.php';

/**
 *
 *  Custom Widgets
 *
 */

// Recent Posts
require_once EDUMODO_CORE_ROOT . '/widget/recent-post.php';

//Custom Elements
require_once EDUMODO_CORE_ROOT . '/elements/slider/plugin.php';
require_once EDUMODO_CORE_ROOT . '/elements/slider-pro/plugin.php';
require_once EDUMODO_CORE_ROOT . '/elements/latest-post/plugin.php';
require_once EDUMODO_CORE_ROOT . '/elements/post-grid/plugin.php';
require_once EDUMODO_CORE_ROOT . '/elements/static-testimonial/plugin.php';
require_once EDUMODO_CORE_ROOT . '/elements/testimonial/plugin.php';

// Learnpress Elements
function edumodo_check_learnpress_plugin_active(){
    if (class_exists('LearnPress')) {
        require_once EDUMODO_CORE_ROOT . '/elements/learnpress-course/plugin.php';
        require_once EDUMODO_CORE_ROOT . '/elements/dynamic-category/plugin.php';
        require_once EDUMODO_CORE_ROOT . '/elements/dynamic-category/ajax_functions.php';
        require_once EDUMODO_CORE_ROOT . '/elements/learnpress-categories/plugin.php';
        require_once EDUMODO_CORE_ROOT . '/elements/lp-course-search/widget.php';        
    }
}
add_action('plugins_loaded', 'edumodo_check_learnpress_plugin_active');

// Woocommerce Elements
function edumodo_check_woocommerce_plugin_active(){
    if (class_exists('WooCommerce')) {
        require_once EDUMODO_CORE_ROOT . '/elements/woo-latest-product/plugin.php';
        require_once EDUMODO_CORE_ROOT . '/elements/woo-product-categorie/plugin.php';
    }
}
add_action('plugins_loaded', 'edumodo_check_woocommerce_plugin_active');

// Sensei Elements
function edumodo_check_sensei_plugin_active(){
    if (class_exists('Sensei_Bootstrap')) {
        require_once EDUMODO_CORE_ROOT . '/elements/sensei-course/plugin.php';
        require_once EDUMODO_CORE_ROOT . '/elements/sensei-categories/plugin.php';
        
        require_once EDUMODO_CORE_ROOT . '/elements/sensei-dynamic-category/plugin.php';
        require_once EDUMODO_CORE_ROOT . '/elements/sensei-dynamic-category/ajax_functions.php';

    }
}
add_action('plugins_loaded', 'edumodo_check_sensei_plugin_active');

// LearnDesh Elements
function edumodo_check_learndash_plugin_active(){
    if (class_exists('SFWD_LMS')) {
        require_once EDUMODO_CORE_ROOT . '/elements/learndash-course/plugin.php';
        require_once EDUMODO_CORE_ROOT . '/elements/ld-dynamic-category/plugin.php';
        require_once EDUMODO_CORE_ROOT . '/elements/ld-dynamic-category/ajax_functions.php';        
    }
}
add_action('plugins_loaded', 'edumodo_check_learndash_plugin_active');

// Custom Elements
require_once EDUMODO_CORE_ROOT . '/elements/tx-course/plugin.php';
require_once EDUMODO_CORE_ROOT . '/elements/teacher-1/plugin.php';
require_once EDUMODO_CORE_ROOT . '/elements/teacher-2/plugin.php';
require_once EDUMODO_CORE_ROOT . '/elements/notice-1/plugin.php';
require_once EDUMODO_CORE_ROOT . '/elements/video-popup/widget.php';
require_once EDUMODO_CORE_ROOT . '/elements/countdown/widget.php';

// Event calender elements
require_once EDUMODO_CORE_ROOT . '/elements/event/plugin.php';
require_once EDUMODO_CORE_ROOT . '/elements/event-two/plugin.php';

if (!function_exists('edumodo_plugin_js')) {
    function edumodo_plugin_js(){

        wp_enqueue_style('edumodo-youtube-popup', plugin_dir_url(__FILE__) . 'dist/css/youtube-popup.css');
        wp_enqueue_style('edumodo-core-plugin-css', plugin_dir_url(__FILE__) . 'dist/css/dynamic-category.css');
        wp_enqueue_style('edumodo-event-css', plugin_dir_url(__FILE__) . 'dist/css/event.css');
        wp_enqueue_style('edumodo-core-blog-css', plugin_dir_url(__FILE__) . 'dist/css/blog.css');
        wp_enqueue_style('edumodo-core-blog-grid-css', plugin_dir_url(__FILE__) . 'dist/css/blog-grid.css');
        wp_enqueue_style('edumodo-core-css', plugin_dir_url(__FILE__) . 'dist/css/core.css');

        wp_enqueue_script('edumodo-countdownTimer', plugin_dir_url(__FILE__) . 'dist/js/jquery.countdownTimer.js', array('jquery'), EDUMODO_CORE_VERSION, true);
        wp_enqueue_script('edumodo-youtube-popup', plugin_dir_url(__FILE__) . 'dist/js/youtube-popuo.js', array('jquery'), EDUMODO_CORE_VERSION, true);
        wp_enqueue_script('edumodo_dynamic_category', plugin_dir_url(__FILE__) . 'dist/js/dynamic_category.js', array('jquery'), EDUMODO_CORE_VERSION, true);
        wp_enqueue_script('jquery-slick', plugin_dir_url(__FILE__) . 'dist/js/slick.js', array('jquery'), EDUMODO_CORE_VERSION, true);
        wp_enqueue_script('edubin-core-scripts', plugin_dir_url(__FILE__) . 'dist/js/core.js', array('jquery'), EDUMODO_CORE_VERSION, true);

        wp_localize_script('edumodo_dynamic_category', 'ajaxpagination', array('ajaxurl' => admin_url('admin-ajax.php')));
    }
}
add_action('wp_enqueue_scripts', 'edumodo_plugin_js');
