<?php 

$post_id = edumodo_get_id();
    // Global Options
global $edumodo_options;
    // Prefix
$prefix = '_edumodo_';
    // view counter
setPostViews(get_the_ID());
    // Page title enable
$title_enable = get_post_meta($post_id, $prefix . 'title_enable', true);

    // sidebar position
$sidebar_details   = edumodo_array_get($edumodo_options, 'details-sidebar-select') ? $edumodo_options['details-sidebar-select'] : '';

    // LearnDash single course page
$learndash_single_layout_select   = edumodo_array_get($edumodo_options, 'learndash_single_layout_select') ? $edumodo_options['learndash_single_layout_select'] : '';
$learndash_single_sidebar_style   = edumodo_array_get($edumodo_options, 'learndash_single_sidebar_style') ? $edumodo_options['learndash_single_sidebar_style'] : '';
$enable_learndash_single_related_courses   = edumodo_array_get($edumodo_options, 'enable_learndash_single_related_courses') ? $edumodo_options['enable_learndash_single_related_courses'] : '';
$related_see_more_text   = edumodo_array_get($edumodo_options, 'related_see_more_text') ? $edumodo_options['related_see_more_text'] : '';
$enable_learndash_single_related_dsc   = edumodo_array_get($edumodo_options, 'enable_learndash_single_related_dsc') ? $edumodo_options['enable_learndash_single_related_dsc'] : '';
$learndash_single_related_dsc_length   = edumodo_array_get($edumodo_options, 'learndash_single_related_dsc_length') ? $edumodo_options['learndash_single_related_dsc_length'] : '';
$enable_learndash_single_last_update   = edumodo_array_get($edumodo_options, 'enable_learndash_single_last_update') ? $edumodo_options['enable_learndash_single_last_update'] : '';
$enable_learndash_single_tags   = edumodo_array_get($edumodo_options, 'enable_learndash_single_tags') ? $edumodo_options['enable_learndash_single_tags'] : '';
?>
<?php 
global $post; $post_id = $post->ID;
$course_id = $post_id;
$user_id   = get_current_user_id();
$current_id = $post->ID;

$enable_video = get_post_meta( $post->ID, '_learndash_course_grid_enable_video_preview', true );
$embed_code   = get_post_meta( $post->ID, '_learndash_course_grid_video_embed_code', true );
$button_text  = get_post_meta( $post->ID, '_learndash_course_grid_custom_button_text', true );

                            // Retrive oembed HTML if URL provided
if ( preg_match( '/^http/', $embed_code ) ) {
    $embed_code = wp_oembed_get( $embed_code, array( 'height' => 600, 'width' => 400 ) );
}

$button_text = isset( $button_text ) && ! empty( $button_text ) ? $button_text : __( 'See more...', 'edumodo' );

$button_text = apply_filters( 'learndash_course_grid_custom_button_text', $button_text, $post_id );

$options = get_option('sfwd_cpt_options');
$currency = null;

if ( ! is_null( $options ) ) {
    if ( isset($options['modules'] ) && isset( $options['modules']['sfwd-courses_options'] ) && isset( $options['modules']['sfwd-courses_options']['sfwd-courses_paypal_currency'] ) )
        $currency = $options['modules']['sfwd-courses_options']['sfwd-courses_paypal_currency'];
}

if( is_null( $currency ) )
    $currency = 'USD';

$course_options = get_post_meta($post_id, "_sfwd-courses", true);
$price = $course_options && isset($course_options['sfwd-courses_course_price']) ? $course_options['sfwd-courses_course_price'] : __( 'Free', 'edumodo' );
$short_description = @$course_options['sfwd-courses_course_short_description'];

$has_access   = sfwd_lms_has_access( $course_id, $user_id );
$is_completed = learndash_course_completed( $user_id, $course_id );

if( $price == '' )
    $price .= __( 'Free', 'edumodo' );

if ( is_numeric( $price ) ) {
    if ( $currency == "USD" )
        $price = '$' . $price;
    else
        $price .= ' ' . $currency;
}

$class       = '';
$ribbon_text = '';

if ( $has_access && ! $is_completed ) {
    $class = 'ld_course_grid_price ribbon-enrolled';
    $ribbon_text = __( 'Enrolled', 'edumodo' );
} elseif ( $has_access && $is_completed ) {
    $class = 'ld_course_grid_price';
    $ribbon_text = __( 'Completed', 'edumodo' );
} else {
    $class = ! empty( $course_options['sfwd-courses_course_price'] ) ? 'ld_course_grid_price price_' . $currency : 'ld_course_grid_price free';
    $ribbon_text = $price;
}

?>
<div class="ld_course_grid col-md-4 col-sm-6">
    <article <?php post_class(); ?>>
        <div class="ld_course_grid_price ribbon-enrolled">
         <?php echo $ribbon_text; ?>   
     </div>

     <?php if (has_post_thumbnail()): ?>
        <figure class="post-thumbnail">
            <a href="<?php the_permalink(); ?>">
                <?php the_post_thumbnail();?>
            </a>
        </figure>
    <?php endif ?>
    
    <div class="caption">
        <h3 class="entry-title"><?php the_title(); ?></h3>
        <?php if ($short_description): ?>
            <p class="entry-content"><?php echo esc_html_e($short_description), 'edumodo'; ?></p>
        <?php endif ?>
        <p class="ld_course_grid_button"><a class="btn btn-primary" role="button" href="<?php the_permalink()?>" rel="bookmark"><?php esc_html_e( $related_see_more_text, 'edumodo' ); ?></a></p>
    </div><!-- .entry-header -->
</article><!-- #post-## -->
</div>