<?php
/**
 * Template part for displaying teacher
  posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Edumodo
 */
    // Global Options
    global $edumodo_options;

    $prefix = '_edumodo_';

    $teacher_img_links = get_post_meta( $post->ID, $prefix . 'teacher_img', true );
    $designation = get_post_meta( $post->ID, $prefix . 'teacher_designation', true );
    $email = get_post_meta( $post->ID, $prefix . 'teacher_email', true );
    $phone = get_post_meta( $post->ID, $prefix . 'teacher_phone', true );
    $website = get_post_meta( $post->ID, $prefix . 'teacher_website', true );
    $teacher_facebook = get_post_meta( $post->ID, $prefix . 'teacher_facebook_link', true );
    $teacher_twitter = get_post_meta( $post->ID, $prefix . 'teacher_twitter_link', true );
    $teacher_linkedin = get_post_meta( $post->ID, $prefix . 'teacher_linkedin_link', true );

?>

    <div class="edumodo-teacher-1">
        <div class="col-md-3 col-sm-6">
            <div class="teacher-2">
                <div class="teacher-container">
                    <!-- First teacher Block -->
                    <div class="teacher-each-wrap">
                        <div class="teacher-block">

                            <?php if ($teacher_img_links) : ?>
                            <div class="teacher-image">                    
                                <img src="<?php echo $teacher_img_links; ?>" alt="<?php the_title(); ?>">   
                            </div>
                            <?php endif; ?>

                                <div class="teacher-social">
                                  <?php if ($teacher_facebook) : ?>
                                          <a class="teacher-facebook" href="<?php echo $teacher_facebook; ?>"><i class="glyph-icon flaticon-facebook-logo"></i></a>
                                  <?php endif; ?>

                                  <?php if ($teacher_twitter) : ?>
                                          <a class="teacher-twitter" href="<?php echo $teacher_twitter; ?>"><i class="glyph-icon flaticon-twitter"></i> </a>
                                  <?php endif; ?>

                                  <?php if ($teacher_linkedin) : ?>
                                           <a class="teacher-linkedin" href="<?php echo $teacher_linkedin; ?>"><i class="glyph-icon flaticon-linkedin-logo"></i> </a>
                                  <?php endif; ?>
                                </div>  

                            <div class="teacher-info">
                                <div class="name">
                                 <a href="<?php the_permalink(); ?>">
                                        <h4 class="teacher-title"><?php the_title(); ?></h4>
                                 </a>
                                    <?php if ( ! empty( $designation ) ) : ?>
                                        <span class="teacher-designation"><?php echo $designation; ?></span>
                                    <?php endif; ?>
                                </div>
                            </div><!-- end .hover content -->           
                        </div>

                    </div><!-- end .teacher wrap -->
                </div><!-- end .tema container -->
            </div> <!-- end .div -->
        </div>
                

     
    </div> <!-- /.div -->


		
		
