<?php
/**
 * The template for displaying archive pages
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Edumodo
 */
    $post_id = edumodo_get_id();
    // Global Options
    global $edumodo_options;
    // sidebar position
    $sidebar_position = $edumodo_options['default-sidebar-select'];
    $tx_course_per_page = $edumodo_options['tx_course_per_page'];

get_header(); ?>


            <div id="primary" class="content-area">
                <main id="main" class="site-main">

                    <?php do_action('edumodo-enable-or-disable-header-section'); ?>

                    <div class="container">
                        <div class="row">

                              <?php 

                                    $paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
                                    $q = new WP_Query([
                                        'post_type' => 'tx-course',
                                        'posts_per_page' => get_option('posts_per_page'),
                                         get_query_var( 'taxonomy' ) => get_query_var( 'term' ),
                                        'paged' => $paged
                                    ]);
                                    $temp_query = $wp_query;
                                    $wp_query = null;
                                    $wp_query = $q;

                                    if ( $q->have_posts() ) :
                                        while ( $q->have_posts() ) : $q->the_post(); ?>
                                          
                                            <?php  get_template_part( 'template-parts/content', 'tx-course');  ?>
                                    <?php endwhile;
                                    endif;

                                    // Reset postdata
                                    wp_reset_postdata();

                                    // pagination goes here..

                                    // Reset main query object
                                    $wp_query = NULL;
                                    $wp_query = $temp_query;
                                    ?>


                        </div><!-- .row -->
                    </div><!-- .container -->
                </main><!-- #main -->
            </div><!-- #primary -->

<?php
get_footer();
