
<div class="txw-box">
    <div class="txw-box-header">
        <h2 class="box-title"><?php esc_html_e( 'Theme Updates', 'edumodo' ); ?></h2>
    </div>
    <div class="txw-box-body">
        <p><?php esc_html_e( 'Please login using your ThemeForest account to enable Theme Updates. We update themes when a new feature is added or a bug is fixed. It is highly recommended to enable Theme Updates.', 'edumodo' ); ?></p>
        <p>When an update becomes available it will show in the Dashboard with an option to install.</p>
        <p>
            <em>On the next page you will be asked to Login with your ThemeForest account and grant
                permissions to enable Automatic Updates. If you have any questions please <a
                        href="https://www.themexpert.com/envato" target="_blank">contact us</a>.</em>
        </p>

	    <?php if ( function_exists( 'envato_market' ) ) { ?>
		    <?php
		    $option = envato_market()->get_options();

		    $my_items = array();
		    if ( $option && ! empty( $option['items'] ) ) {
			    foreach ( $option['items'] as $item ) {
				    if ( ! empty( $item['oauth'] ) && ! empty( $item['token_data']['expires'] ) && $item['oauth'] == $this->envato_username && $item['token_data']['expires'] >= time() ) {
					    // token exists and is active
					    $my_items[] = $item;
				    }
			    }
		    }
		    if ( count( $my_items ) ) {
			    ?>
                <p>Thanks! Theme updates have been enabled for the following items: </p>
                <ul>
				    <?php foreach ( $my_items as $item ) { ?>
                        <li><?php echo esc_html( $item['name'] ); ?></li>
				    <?php } ?>
                </ul>
                <p>When an update becomes available it will show in the Dashboard with an option to install.</p>
                <p>Change settings from the 'Envato Market' menu in the WordPress Dashboard.</p>

			    <?php
		    } else {

			    do_action('tx_envato_login_template');
			    do_action('tx_envato_login_field');

		    } ?>
	    <?php } else { ?>
            Please ensure the Envato Market plugin has been installed correctly.
	    <?php } ?>
    </div>
</div>
