<?php

/**
 * Class TX_System_Status.
 */
class TX_Main_Dashboard extends TX_Admin_Sub_Page {
	/**
	 * @var string
	 */
	public $key_page = 'dashboard';

	/**
	 * @var array
	 */
	public static $boxes = null;

	/**
	 * Get all boxes.
	 */
	public static function all_boxes() {
		if ( self::$boxes === null ) {
			self::$boxes = array(
				'appearance'    => array(
					'id'    => 'appearance',
					'title' => __( 'Appearance', 'edumodo' ),
				),
				'documentation' => array(
					'id'    => 'documentation',
					'title' => __( 'Help & Support', 'edumodo' ),
				),
			);

		}

		return apply_filters( 'tx_dashboard_all_boxes', self::$boxes );
	}

	/**
	 * TX_System_Status constructor.
	 */
	protected function __construct() {
		parent::__construct();

		$this->init_hooks();
	}

	/**
	 * Initialize hooks.
	 */
	private function init_hooks() {
		add_action( 'wp_ajax_tx_dashboard_order_boxes', array( $this, 'handle_order_boxes_dashboard' ) );
		add_filter( 'tx_dashboard_sub_pages', array( $this, 'add_sub_page' ) );
		add_action( 'tx_dashboard_boxes_left', array( $this, 'render_boxes_left' ) );
		add_action( 'tx_dashboard_boxes_right', array( $this, 'render_boxes_right' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
	}


	/**
	 * Handle ajax order.
	 */
	public function handle_order_boxes_dashboard() {
		$post_data = wp_parse_args( $_POST, array(
			'left'  => array(),
			'right' => array(),
		) );

		update_option( 'tx_dashboard_order_boxes', $post_data );

		wp_send_json_success( $post_data );
	}

	/**
	 * Set global temporary list boxes
	 */
	private function all_boxes_temp() {
		global $render_boxes;

		if ( $render_boxes === null ) {
			$render_boxes = self::all_boxes();
		}
	}

	/**
	 * Render box with key.
	 *
	 * @param $key
	 */
	private function render_box( $key ) {
		$this->all_boxes_temp();
		global $render_boxes;

		if ( empty( $render_boxes[ $key ] ) ) {
			return;
		}

		$box  = $render_boxes[ $key ];
		$args = wp_parse_args( $box, array(
			'id'       => '',
			'title'    => '',
			'lock'     => false,
			'template' => '',
		) );

		if ( empty( $args['template'] ) ) {
			$args['template'] = $args['id'];
		}

		TX_Dashboard::get_template( 'boxes/master.php', $args );

		/**
		 * Only once render box.
		 */
		unset( $render_boxes[ $key ] );
	}

	/**
	 * Render boxes with order.
	 *
	 * @param $boxes
	 */
	private function render_boxes( $boxes ) {
		foreach ( $boxes as $box ) {
			$this->render_box( $box );
		}
	}

	/**
	 * Render boxes on the left.
	 */
	public function render_boxes_left() {
		$boxes_default = array(
			'documentation'
		);

		$order = (array) get_option( 'tx_dashboard_order_boxes', array() );
		$boxes = isset( $order['left'] ) ? $order['left'] : $boxes_default;

		$this->render_boxes( $boxes );
	}

	/**
	 * Render boxes on the right.
	 */
	public function render_boxes_right() {
		$boxes_default = array(
			'appearance'
		);

		$order = (array) get_option( 'tx_dashboard_order_boxes', array() );
		$boxes = isset( $order['right'] ) ? $order['right'] : $boxes_default;

		$this->render_boxes( $boxes );

		/**
		 * Render others boxes have not rendered.
		 */
		global $render_boxes;
		foreach ( $render_boxes as $key => $box ) {
			$this->render_box( $key );
		}
	}

	/**
	 * Add sub page.
	 *
	 * @param $sub_pages
	 *
	 * @return mixed
	 */
	public function add_sub_page( $sub_pages ) {
		$sub_pages['dashboard'] = array(
			'title' => __( 'Dashboard', 'edumodo' ),
		);

		return $sub_pages;
	}

	/**
	 * Enqueue scripts.
	 */
	public function enqueue_scripts() {
		if ( ! self::is_myself() ) {
			return;
		}
	}
}
