<?php

/**
 * Class TX_Admin_Settings
 */
class TX_Admin_Settings extends TX_Singleton {
	/**
	 * @var string
	 */
	private static $key_option = 'tx_wizard_admin_settings';

	/**
	 * @var array
	 */
	private static $settings = null;

	/**
	 * TX_Admin_Settings constructor.
	 */
	protected function __construct() {
	}

	/**
	 * Get all settings.
	 *
	 * @return array
	 */
	private static function get_settings() {
		if ( self::$settings === null ) {
			self::$settings = get_option( self::$key_option, array() );
		}

		return (array) self::$settings;
	}

	/**
	 * Update settings.
	 *
	 * @param $settings array
	 */
	private static function update_settings( $settings ) {
		self::$settings = $settings;
		update_option( self::$key_option, $settings );
	}

	/**
	 * Get setting by key.
	 *
	 * @param $key
	 * @param $default
	 *
	 * @return mixed
	 */
	public static function get( $key, $default ) {
		$settings = self::get_settings();
		if ( ! isset( $settings[ $key ] ) ) {
			return $default;
		}

		return $settings[ $key ];
	}

	/**
	 * Set settings.
	 *
	 * @param $key
	 * @param $value
	 */
	public static function set( $key, $value ) {
		$settings         = self::get_settings();
		$settings[ $key ] = $value;
		self::update_settings( $settings );
	}
}
