<?php
/**
 * Declaring widgets
 *
 *
 * @package Edumodo
 */
function edumodo_widgets_init() {
    register_sidebar( array(
        'name'          => esc_html__( 'Main Sidebar', 'edumodo' ),
        'id'            => 'sidebar-1',
        'description'   => esc_html__( 'Add yuo main blog widget in here', 'edumodo' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
     
    register_sidebar( array(
        'name'          => esc_html__( 'Header Top', 'edumodo' ),
        'id'            => 'widget-header-top',
        'description'   => 'Add header top area widget in here',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widget-title hidden">',
        'after_title'   => '</h3>',
    ) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer 1', 'edumodo' ),
		'id'            => 'footer-sidebar-1',
		'description'   => 'Footer 1 widget in here',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
	) );

    register_sidebar( array(
        'name'          => esc_html__( 'Footer 2', 'edumodo' ),
        'id'            => 'footer-sidebar-2',
        'description'   => 'Footer 2 widget in here',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );

    register_sidebar( array(
        'name'          => esc_html__( 'Footer 3', 'edumodo' ),
        'id'            => 'footer-sidebar-3',
        'description'   => 'Footer 3 widget in here',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );

    register_sidebar( array(
        'name'          => esc_html__( 'Footer 4', 'edumodo' ),
        'id'            => 'footer-sidebar-4',
        'description'   => 'Add your footer 4 widget in here',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );

    register_sidebar( array(
        'name'          => esc_html__( 'TX Course Single Page', 'edumodo' ),
        'id'            => 'course-sidebar-1',
        'description'   => 'Add your TX Course single page widget in here',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );


    register_sidebar( array(
        'name'          => esc_html__( 'Notice Single', 'edumodo' ),
        'id'            => 'notice-sidebar-1',
        'description'   => 'Add your notice single page in widget here',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );

}
add_action( 'widgets_init', 'edumodo_widgets_init' );

// LearnPress 
if(class_exists('LearnPress')){
    function edumodo_learnpress_widgets_init() {
        register_sidebar( array(
            'name'          => esc_html__( 'LearnPress Login Popup', 'edumodo' ),
            'id'            => 'lp-login-register',
            'description'   => 'Add your LearnPress login popup widget in here',
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h3 class="widget-title">',
            'after_title'   => '</h3>',
        ) );
    }

add_action( 'widgets_init', 'edumodo_learnpress_widgets_init' );
}

// LearnDash
 if( class_exists( 'SFWD_LMS' ) ) {
    function edumodo_learndash_widgets_init() {
        register_sidebar( array(
            'name'          => esc_html__( 'LearnDash Single Right', 'edumodo' ),
            'id'            => 'ld-course-sidebar-1',
            'description'   => 'Add your LearnDash LMS course single page right widget in here',
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h3 class="widget-title">',
            'after_title'   => '</h3>',
        ) );
    }

add_action( 'widgets_init', 'edumodo_learndash_widgets_init' );
}

// Mega Menu

function edumodo_mega_menu_widgets_init() {
    register_sidebar( array(
        'name'          => esc_html__( 'Mega Menu 1', 'edumodo' ),
        'id'            => 'mega-menu-1',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
    register_sidebar( array(
        'name'          => esc_html__( 'Mega Menu 2', 'edumodo' ),
        'id'            => 'mega-menu-2',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
    register_sidebar( array(
        'name'          => esc_html__( 'Mega Menu 3', 'edumodo' ),
        'id'            => 'mega-menu-3',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
    register_sidebar( array(
        'name'          => esc_html__( 'Mega Menu 4', 'edumodo' ),
        'id'            => 'mega-menu-4',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
}
add_action( 'widgets_init', 'edumodo_mega_menu_widgets_init' );


