<?php


function edumodo_register_required_plugins($plugins) {
    /*
     * Array of plugin arrays. Required keys are name and slug.
     * If the source is NOT from the .org repo, then source is also required.
     */

    $template_directory = get_template_directory();

    $plugins = array(
        array(
            'name'     => esc_html('Edumodo Core'),
            'slug'     => 'edumodo-core',
            'source'   =>  get_template_directory() . '/plugin/edumodo-core.zip', // The plugin source.
            'required' => true,
            'version'  => '2.6.0',
        ),
        array(
            'name'     => esc_html__('Elementor Page Builder', 'edumodo'),
            'slug'     => 'elementor',
            'required' => true,
        ),
        array(
            'name'     => esc_html('Revolution Slider'),
            'slug'     => 'revslider',
            'source'   =>  get_template_directory() . '/plugin/revslider.zip', // The plugin source.
            'required' => false,
            //'version'  => '5.4.8',
        ),
        array(
            'name'     => esc_html__('Redux FrameWork', 'edumodo'),
            'slug'     => 'redux-framework',
            'required' => true,
        ),
        array(
            'name'     => esc_html__('CMB2', 'edumodo'),
            'slug'     => 'cmb2',
            'required' => true,
        ),
        array(
            'name'     => esc_html__('WPForms', 'edumodo'),
            'slug'     => 'wpforms-lite',
            'required' => true,
        ),
        array(
            'name'     => esc_html('WooCommerce'),
            'slug'     => 'woocommerce',
            'required' => false
        ),
        array(
            'name'     => esc_html('The Events Calender'),
            'slug'     => 'the-events-calendar',
            'required' => false
        ),
        array(
            'name'     => esc_html__('WidgetKit for Elementor', 'edumodo'),
            'slug'     => 'widgetkit-for-elementor',
            'required' => false,
        ),
        array(
            'name'     => esc_html('LearnPress - WordPress LMS'),
            'slug'     => 'learnpress',
            'required' => false,
        ),
        array(
            'name'     => esc_html('LearnPress – Course Review'),
            'slug'     => 'learnpress-course-review',
            'required' => false,
        ),
    );

    return $plugins;

}

add_filter( 'tx_wizard_get_all_plugins_require', 'edumodo_register_required_plugins' );
