<?php

/**
 * Display related courses for sidebar
 */
if (!function_exists('edumodo_learndash_related_courses')) {
	function edumodo_learndash_related_courses() { ?>

		<?php 
		$prefix = '_edumodo_';
		global $post, $edumodo_options; 
		$post_id = $post->ID; 
		$course_id = $post_id;
		$user_id   = get_current_user_id();
		$current_id = $post->ID;

		$enable_video = get_post_meta( $post->ID, '_learndash_course_grid_enable_video_preview', true );
		$embed_code   = get_post_meta( $post->ID, '_learndash_course_grid_video_embed_code', true );
		$button_text  = get_post_meta( $post->ID, '_learndash_course_grid_custom_button_text', true );

		$img_category  = get_post_meta( get_the_ID(), '_edumodo_header_img', true ); 
		$enable_learndash_single_related_courses   = edumodo_array_get($edumodo_options, 'enable_learndash_single_related_courses') ? $edumodo_options['enable_learndash_single_related_courses'] : '';
		$learndash_single_related_count   = edumodo_array_get($edumodo_options, 'learndash_single_related_count') ? $edumodo_options['learndash_single_related_count'] : '';
		$enable_learndash_single_related_dsc   = edumodo_array_get($edumodo_options, 'enable_learndash_single_related_dsc') ? $edumodo_options['enable_learndash_single_related_dsc'] : '';
		$learndash_single_related_dsc_length   = edumodo_array_get($edumodo_options, 'learndash_single_related_dsc_length') ? $edumodo_options['learndash_single_related_dsc_length'] : '';
		$related_see_more_text   = edumodo_array_get($edumodo_options, 'related_see_more_text') ? $edumodo_options['related_see_more_text'] : '';
    // Retrive oembed HTML if URL provided
		if ( preg_match( '/^http/', $embed_code ) ) {
			$embed_code = wp_oembed_get( $embed_code, array( 'height' => 600, 'width' => 400 ) );
		}

		$button_text = isset( $button_text ) && ! empty( $button_text ) ? $button_text : __( 'See more...', 'edumodo' );

		$button_text = apply_filters( 'learndash_course_grid_custom_button_text', $button_text, $post_id );

		$options = get_option('sfwd_cpt_options');
		$currency = null;

		if ( ! is_null( $options ) ) {
			if ( isset($options['modules'] ) && isset( $options['modules']['sfwd-courses_options'] ) && isset( $options['modules']['sfwd-courses_options']['sfwd-courses_paypal_currency'] ) )
				$currency = $options['modules']['sfwd-courses_options']['sfwd-courses_paypal_currency'];
		}

		if( is_null( $currency ) )
			$currency = 'USD';

		$course_options = get_post_meta($post_id, "_sfwd-courses", true);
		$price = $course_options && isset($course_options['sfwd-courses_course_price']) ? $course_options['sfwd-courses_course_price'] : __( 'Free', 'edumodo' );
		$short_description = @$course_options['sfwd-courses_course_short_description'];

		$has_access   = sfwd_lms_has_access( $course_id, $user_id );
		$is_completed = learndash_course_completed( $user_id, $course_id );

		if( $price == '' )
			$price .= __( 'Free', 'edumodo' );

		if ( is_numeric( $price ) ) {
			if ( $currency == "USD" )
				$price = '$' . $price;
			else
				$price .= ' ' . $currency;
		}

		$class       = '';
		$ribbon_text = '';

		if ( $has_access && ! $is_completed ) {
			$class = 'ld_course_grid_price ribbon-enrolled';
			$ribbon_text = __( 'Enrolled', 'edumodo' );
		} elseif ( $has_access && $is_completed ) {
			$class = 'ld_course_grid_price';
			$ribbon_text = __( 'Completed', 'edumodo' );
		} else {
			$class = ! empty( $course_options['sfwd-courses_course_price'] ) ? 'ld_course_grid_price price_' . $currency : 'ld_course_grid_price free';
			$ribbon_text = $price;
		}


		$tags = wp_get_post_terms($post_id, 'post_tag');

		if ( $tags & 1 == $enable_learndash_single_related_courses) : ?>    
			<aside id="secondary" class="widget-area">
				<div class="widget ld-related-course-widget">
					<div class="leaarndash-releted-course-two">
						<h3 class="widget-title rl-course-title ld"><?php esc_html_e( 'Related Courses', 'edumodo' ); ?> </h3>
						<div class="lp-related-course">

							<?php 

							$tag_ids = array();
							foreach ( $tags as $individual_tag ) array_push($tag_ids,$individual_tag->term_id);

							$args2 = array(
								'post_type'        => 'sfwd-courses',
								'tax_query' => array( 
									array( 'taxonomy' => 'post_tag', 
										'field' => 'id',
										'terms' => $tag_ids
									)
								),
								'post__not_in'     => array( $post_id ),
                                        'posts_per_page'   => $learndash_single_related_count, // Number of related posts that will be shown.

                                    );
							$my_query = new WP_Query( $args2 );

							if ( $my_query->have_posts() ) {
								while ( $my_query->have_posts() ) {
									$my_query->the_post(); ?>       

									<div class="single-course">
										<div class="ld-course-thumbnail">
											<a href="<?php the_permalink()?>" rel="bookmark" title="<?php the_title(); ?>">
												<?php the_post_thumbnail('small'); ?>
											</a>
										</div>
										<div class="content-body">
											<a href="<?php the_permalink()?>"> 
												<h4 class="title"><?php the_title(); ?></h4> 
											</a>
										</div>
										<div class="course-footer">
											<div class="lp-enroll"><?php echo $ribbon_text; ?></div>
										</div>
									</div>
								<?php }
							}
							wp_reset_query(); ?>

						</div> 
					</div>
				</div>
			</aside>
		<?php endif;  ?>

	<?php }
}

/**
 * Display related courses for sidebar
 */
if (!function_exists('edumodo_learndash_related_courses_grid')) {
	function edumodo_learndash_related_courses_grid() { ?>

		<?php 
		$prefix = '_edumodo_';
		global $post, $edumodo_options; 
		$post_id = $post->ID; 
		$course_id = $post_id;
		$user_id   = get_current_user_id();
		$current_id = $post->ID;

		$enable_video = get_post_meta( $post->ID, '_learndash_course_grid_enable_video_preview', true );
		$embed_code   = get_post_meta( $post->ID, '_learndash_course_grid_video_embed_code', true );
		$button_text  = get_post_meta( $post->ID, '_learndash_course_grid_custom_button_text', true );

		$img_category  = get_post_meta( get_the_ID(), '_edumodo_header_img', true ); 
		$enable_learndash_single_related_courses   = edumodo_array_get($edumodo_options, 'enable_learndash_single_related_courses') ? $edumodo_options['enable_learndash_single_related_courses'] : '';
		$learndash_single_related_count   = edumodo_array_get($edumodo_options, 'learndash_single_related_count') ? $edumodo_options['learndash_single_related_count'] : '';
		$enable_learndash_single_related_dsc   = edumodo_array_get($edumodo_options, 'enable_learndash_single_related_dsc') ? $edumodo_options['enable_learndash_single_related_dsc'] : '';
		$learndash_single_related_dsc_length   = edumodo_array_get($edumodo_options, 'learndash_single_related_dsc_length') ? $edumodo_options['learndash_single_related_dsc_length'] : '';
		$related_see_more_text   = edumodo_array_get($edumodo_options, 'related_see_more_text') ? $edumodo_options['related_see_more_text'] : '';
    // Retrive oembed HTML if URL provided
		if ( preg_match( '/^http/', $embed_code ) ) {
			$embed_code = wp_oembed_get( $embed_code, array( 'height' => 600, 'width' => 400 ) );
		}

		$button_text = isset( $button_text ) && ! empty( $button_text ) ? $button_text : __( 'See more...', 'edumodo' );

		$button_text = apply_filters( 'learndash_course_grid_custom_button_text', $button_text, $post_id );

		$options = get_option('sfwd_cpt_options');
		$currency = null;

		if ( ! is_null( $options ) ) {
			if ( isset($options['modules'] ) && isset( $options['modules']['sfwd-courses_options'] ) && isset( $options['modules']['sfwd-courses_options']['sfwd-courses_paypal_currency'] ) )
				$currency = $options['modules']['sfwd-courses_options']['sfwd-courses_paypal_currency'];
		}

		if( is_null( $currency ) )
			$currency = 'USD';

		$course_options = get_post_meta($post_id, "_sfwd-courses", true);
		$price = $course_options && isset($course_options['sfwd-courses_course_price']) ? $course_options['sfwd-courses_course_price'] : __( 'Free', 'edumodo' );
		$short_description = @$course_options['sfwd-courses_course_short_description'];

		$has_access   = sfwd_lms_has_access( $course_id, $user_id );
		$is_completed = learndash_course_completed( $user_id, $course_id );

		if( $price == '' )
			$price .= __( 'Free', 'edumodo' );

		if ( is_numeric( $price ) ) {
			if ( $currency == "USD" )
				$price = '$' . $price;
			else
				$price .= ' ' . $currency;
		}

		$class       = '';
		$ribbon_text = '';

		if ( $has_access && ! $is_completed ) {
			$class = 'ld_course_grid_price ribbon-enrolled';
			$ribbon_text = __( 'Enrolled', 'edumodo' );
		} elseif ( $has_access && $is_completed ) {
			$class = 'ld_course_grid_price';
			$ribbon_text = __( 'Completed', 'edumodo' );
		} else {
			$class = ! empty( $course_options['sfwd-courses_course_price'] ) ? 'ld_course_grid_price price_' . $currency : 'ld_course_grid_price free';
			$ribbon_text = $price;
		}

		$tags = wp_get_post_terms($post_id, 'post_tag');

		if ( $tags & 1 == $enable_learndash_single_related_courses) : ?>    
			<div class="leaarndash-releted-course">
				<h2 class="rl-course-title ld"><?php esc_html_e( 'Related Courses', 'edumodo' ); ?> </h2>
				<div class="row">
					<div class="lp-related-course clearfix">

						<?php 

						$tag_ids = array();
						foreach ( $tags as $individual_tag ) array_push($tag_ids,$individual_tag->term_id);

						$args2 = array(
							'post_type'        => 'sfwd-courses',
							'tax_query' => array( 
								array( 'taxonomy' => 'post_tag', 
									'field' => 'id',
									'terms' => $tag_ids
								)
							),
							'post__not_in'     => array( $post_id ),
	                                'posts_per_page'   => 3, // Number of related posts that will be shown.

	                            );
						$my_query = new WP_Query( $args2 );

						if ( $my_query->have_posts() ) {
							while ( $my_query->have_posts() ) {
								$my_query->the_post(); ?>       

								<div class="course-content-wrapper col-md-4">
									<article class="lp-course-1">

										<figure class="lp-course-thumbnail">
											<a href="<?php the_permalink()?>" rel="bookmark" title="<?php the_title(); ?>">
												<?php the_post_thumbnail('small'); ?>
											</a>
										</figure>

										<div class="course-content-body">

											<header class="entry-header">
												<h4 class="course-entry-title">
													<a href="<?php the_permalink()?>">
														<?php the_title(); ?>
													</a>
												</h4>       
											</header>
											<?php if ($enable_learndash_single_related_dsc): ?>
												<div class="ld-r-description">
													<?php echo wp_trim_words( $short_description, $learndash_single_related_dsc_length ); ?>
												</div>
											<?php endif ?>
											<footer class="lp-entry-footer">
												<div class="footer-body">
													<span class="lp-enroll">
														<?php echo $ribbon_text; ?>
													</span>

													<span class="lp-enroll-btn">
														<a href="<?php the_permalink()?>"><?php esc_html_e( $related_see_more_text, 'edumodo' ); ?></a> 
													</span>
												</div>
											</footer>

										</div>
									</article>
								</div>
							<?php }
						}
						wp_reset_query(); ?>

					</div> 
				</div>
			</div>
		<?php endif;  ?>

	<?php }
}
