<?php

/**
 * Getting Option values for Header
 * @package Edumodo
 */

$post_id = edumodo_get_id();
// Global Options
global $edumodo_options;
// Prefix
$prefix = '_edumodo_';
// Header variation
$header_variation   = edumodo_array_get($edumodo_options, 'select_header') ? $edumodo_options['select_header'] : '';
$enable_scroll_top   = edumodo_array_get($edumodo_options, 'enable_scroll_top') ? $edumodo_options['enable_scroll_top'] : '';
$enable_preloader   = edumodo_array_get($edumodo_options, 'enable_preloader') ? $edumodo_options['enable_preloader'] : '';

?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-svg">
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">

<?php wp_head(); ?>
</head>


<body <?php body_class(); ?>>
    
<!-- Preloader -->
<?php if ($enable_preloader == true) : ?>
<div class="edumodo-preloader">
    <span class="edumodoloader">
        <span class="edumodoloader-inner"></span>
    </span>
</div>  
<?php endif; ?>

<!-- Back to top button -->
<?php if ($enable_scroll_top == true ) : ?>
    <a id="scrollTop"></a>
<?php endif; ?>

<div id="tx-site-container" class="tx-site-container <?php if(! is_home() && ! is_front_page()) : echo "inner-page-class"; else : endif; ?>">
    <div class="tx-site-pusher">
        <div class="tx-site-content"><!-- this is the wrapper for the content -->
            <div class="tx-site-content-inner">
                <div id="page" class="site">
                <?php 
                    if( isset($_GET['head']) && $_GET['head'] == 'v1' ) {
                        get_template_part( 'template-parts/header/header', 'v1' );
                    }
                    elseif( isset($_GET['head']) && $_GET['head'] == 'v2' ) {
                        get_template_part( 'template-parts/header/header', 'v2' );
                    }
                    elseif( isset($_GET['head']) && $_GET['head'] == 'v3' ) {
                        get_template_part( 'template-parts/header/header', 'v3' );
                    }
                    elseif( isset($_GET['head']) && $_GET['head'] == 'v4' ) {
                        get_template_part( 'template-parts/header/header', 'v4' );
                    }
                    elseif( isset($_GET['head']) && $_GET['head'] == 'v5' ) {
                        get_template_part( 'template-parts/header/header', 'v5' );
                    }
                    elseif( isset($_GET['head']) && $_GET['head'] == 'v6' ) {
                        get_template_part( 'template-parts/header/header', 'v6' );
                    }
                    elseif( isset($_GET['head']) && $_GET['head'] == 'v7' ) {
                        get_template_part( 'template-parts/header/header', 'v7' );
                    }
                    elseif( isset($_GET['head']) && $_GET['head'] == 'v8' ) {
                        get_template_part( 'template-parts/header/header', 'v8' );
                    }
                    elseif( isset($_GET['head']) && $_GET['head'] == 'v9' ) {
                        get_template_part( 'template-parts/header/header', 'v9' );
                    }
                    elseif( isset($_GET['head']) && $_GET['head'] == 'v10' ) {
                        get_template_part( 'template-parts/header/header', 'v10' );
                    }
                    // elseif( isset($_GET['head']) && $_GET['head'] == 'v11' ) {
                    //     get_template_part( 'template-parts/header/header', 'v11' );
                    // }
                     else {
                        switch ( $header_variation ) {
                            case 'header_1':
                                get_template_part( 'template-parts/header/header', 'v1' );
                                break;
                            case 'header_2':
                                get_template_part( 'template-parts/header/header', 'v2' );
                                break;
                            case 'header_3':
                                get_template_part( 'template-parts/header/header', 'v3' );
                                break;
                            case 'header_4':
                                get_template_part( 'template-parts/header/header', 'v4' );
                                break;
                            case 'header_5':
                                get_template_part( 'template-parts/header/header', 'v5' );
                                break;
                            case 'header_6':
                                get_template_part( 'template-parts/header/header', 'v6' );
                                break;
                            case 'header_7':
                                get_template_part( 'template-parts/header/header', 'v7' );
                                break;
                            case 'header_8':
                                get_template_part( 'template-parts/header/header', 'v8' );
                                break;
                            case 'header_9':
                                get_template_part( 'template-parts/header/header', 'v9' );
                                break;
                            case 'header_10':
                                get_template_part( 'template-parts/header/header', 'v10' );
                                break;
                            case 'header_11':
                                get_template_part( 'template-parts/header/header', 'v11' );
                                break;
                            default:
                                get_template_part( 'template-parts/header/header', 'v1' );
                        }
                    }
                ?>
            <div id="content" class="site-content fixed-header-margin">
