<?php
/**
 * Default Events Template
 * This file is the basic wrapper template for all the views if 'Default Events Template'
 * is selected in Events -> Settings -> Template -> Events Template.
 *
 * Override this template in your own theme by creating a file at [your-theme]/tribe-events/default-template.php
 *
 * @package TribeEventsCalendar
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

$post_id = edumodo_get_id();
// Prefix
$prefix = '_edumodo_';
// Page title enable
$title_enable = get_post_meta($post_id, $prefix . 'title_enable', true);

get_header();

?>
<?php if ('enable' == $title_enable): ?>
    <?php do_action('edumodo-enable-or-disable-header-section'); ?>
<?php else: ?>
    <div class="page-details-blank"></div>
<?php endif; ?>

<div id="tribe-events-pg-template" class="tribe-events-pg-template i-override-default-template <?php echo is_single() ? 'single-event-template' : '' ?>">
	<?php tribe_events_before_html(); ?>
	<?php tribe_get_view(); ?>
	<?php tribe_events_after_html(); ?>
</div> <!-- #tribe-events-pg-template -->
<?php
get_footer();
