<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Edumodo
 */
    $post_id = edumodo_get_id();
    // Global Options
    global $edumodo_options;
    // Prefix
    $prefix = '_edumodo_';

    // Social url
    $facebook_url = $edumodo_options['facebook'];
    $twitter_url = $edumodo_options['twitter'];
    $instagram_url = $edumodo_options['instagram'];
    $linkedin_url = $edumodo_options['linkedin'];
    $gogle_plus_url = $edumodo_options['gogle_plus'];
    $youtube_url = $edumodo_options['youtube'];
    $skype_url = $edumodo_options['skype'];
    // logo option
    $top_number   = edumodo_array_get($edumodo_options, 'top_number') ? $edumodo_options['top_number'] : '';
    $top_email   = edumodo_array_get($edumodo_options, 'top_email') ? $edumodo_options['top_email'] : '';
    $top_btn_link   = edumodo_array_get($edumodo_options, 'top_btn_link') ? $edumodo_options['top_btn_link'] : '';
    $top_btn_text   = edumodo_array_get($edumodo_options, 'top_btn_text') ? $edumodo_options['top_btn_text'] : '';

    $edumodo_logo   = edumodo_array_get($edumodo_options, 'edumodo_logo') ? $edumodo_options['edumodo_logo']['url'] : '';
     // Transparant Logo
    $edumodo_logo_2   = edumodo_array_get($edumodo_options, 'edumodo_logo_2') ? $edumodo_options['edumodo_logo_2']['url'] : '';
    // Header
    $enable_sticky_active   = edumodo_array_get($edumodo_options, 'enable_sticky_active') ? $edumodo_options['enable_sticky_active'] : '';
    $enable_transparent_active   = edumodo_array_get($edumodo_options, 'enable_transparent_active') ? $edumodo_options['enable_transparent_active'] : '';
//    $enable_mega_menu   = edumodo_array_get($edumodo_options, 'enable_mega_menu') ? $edumodo_options['enable_mega_menu'] : '';
 
?>

    <header class="edumodo-header-1 <?php if ($enable_sticky_active == true) : echo 'sticky-active'; endif; ?> <?php if ($enable_transparent_active == true and is_front_page()) : echo 'transparent-active'; endif; ?>">

        <div id="tophead" class="tophead-v6 hidden-xs">
           <div class="container">
              <div class="row">
                 <div class="col-sm-12">

                    <div class="tophead-contact">
                       <ul class="top-lists">
                          <li> <i class="glyph-icon flaticon-telephone-handle-silhouette"></i><a class="top-phone" href="tel:<?php echo esc_html($top_number); ?>"><?php echo esc_html($top_number); ?></a></li>
                          <li class="topbar-icon-seperator">|</li>
                          <li> <i class="glyph-icon flaticon-message-closed-envelope"></i><a class="top-email" href="mailto:<?php echo esc_html($top_email); ?>"> <?php echo esc_html($top_email); ?></a></li>
                       </ul>
                    </div>

                    <div class="tophead-right top-v4"> 
                        <?php if ($facebook_url):?>
                                <a target="_blank" href="<?php echo esc_url($facebook_url); ?>">
                                    <i class="glyph-icon flaticon-facebook-logo"></i>
                                </a>
                            <?php endif; ?>

                            <?php if ($twitter_url):?>
                                <a target="_blank" href="<?php echo esc_url($twitter_url); ?>">
                                    <i class="glyph-icon flaticon-twitter"></i>
                                </a>
                            <?php endif; ?>

                                
                            <?php if ($instagram_url):?>
                                <a target="_blank" href="<?php echo esc_url($instagram_url); ?>">
                                    <i class="glyph-icon flaticon-instagram-1"></i>
                                </a>
                            <?php endif; ?>

                            <?php if ($linkedin_url):?>
                                <a target="_blank" href="<?php echo esc_url($linkedin_url); ?>">
                                    <i class="glyph-icon flaticon-linkedin-logo"></i>
                                </a>
                            <?php endif; ?>

                            <?php if ($youtube_url):?>
                                <a target="_blank" href="<?php echo esc_url($youtube_url); ?>">
                                    <i class="glyph-icon flaticon-youtube-logo"></i>
                                </a>
                            <?php endif; ?>

                            <?php if ($skype_url):?>
                                <a target="_blank" href="<?php echo esc_url($skype_url); ?>">
                                    <i class="glyph-icon flaticon-skype-logo"></i>
                                </a>
                            <?php endif; ?>
                        </div>
                    <div class="clear"></div>
                 </div>
              </div>
           </div>
        </div>

        <div id="edumodo-mainnav" class="navbar-v1 edumodo-mainnav">
            <div class="container">

                <div class="row">
                    <div class="nav-logo-align">
                   <div class="col-xs-8 col-sm-9 col-md-4 logo">
                        <div class="navbar-header">     

                            <div class="logo-wrapper">
                                <?php 
                                    if ($edumodo_logo or $edumodo_logo_2) : ?>
                                        <a class="logo" href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>">
                                            <?php 
                                                if(has_custom_logo()) :
                                                    the_custom_logo();
                                                endif; 
                                            ?>
                                            <img class="logo-transparent" src="<?php echo esc_url($edumodo_logo_2); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>">
                                            <img class="logo-default" src="<?php echo esc_url($edumodo_logo); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>">
                                        </a>
                                    <?php else:?>
                                    <h2 class="site-title">
                                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>">
                                            <?php bloginfo( 'name' ); ?>
                                        </a>
                                    </h2>
                                    <h6 class="site-description"><?php bloginfo( 'description' ); ?></h6>
                                <?php endif; ?>
                            </div>


                        </div>
                    </div>

                        <div class="col-xs-4 col-sm-3 col-md-8 pull-right text-right hidden-xs hidden-sm">
                            <?php
                                wp_nav_menu( array(
                                    'menu'              => 'primary',
                                    'theme_location'    => 'primary',
                                    'depth'             => 0,
                                    'menu_class'        => 'navigation-main hidden-sm hidden-xs',
                                   // 'fallback_cb'       => 'edumodo_link_to_menu_editor',
                                    'fallback_cb'       => 'tx_megamenu_navwalker::fallback',
                                    'walker'            => new tx_megamenu_navwalker()
                                ));
                            ?>
                        </div>

                        <div class="col-xs-4 col-sm-3 pull-right text-right visible-xs visible-sm hidden-md hidden-lg">
                            <div id="mobile-menu-wrapper" class="mmenu-wrapper">
                                <div class="mmenu-icon">
                                    <a href="#mmenu" class="micon"><i class="glyph-icon flaticon-bars"></i></a>

                                </div>
                                <nav id="mmenu">
                                    <?php
                                        wp_nav_menu(array(
                                            'menu' => 'mobile_menu',
                                            'theme_location' => 'mobile_menu',
                                        ));
                                    ?>
                                </nav>
                            </div>

                        </div>

                    </div>
                </div>
            </div>
        </div>
    </header><!-- #masthead -->

