<?php
/**
 * Template for displaying course content within the loop.
 *
 * This template can be overridden by copying it to yourtheme/learnpress/content-single-course.php
 *
 * @author  ThimPress
 * @package LearnPress/Templates
 * @version 3.0.0
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

if ( post_password_required() ) {
	echo get_the_password_form();

	return;
}
	// view counter
	setPostViews(get_the_ID());
/**
 * @deprecated
 */
do_action( 'learn_press_before_main_content' );
do_action( 'learn_press_before_single_course' );
do_action( 'learn_press_before_single_course_summary' ); 
// Global Options
global $edumodo_options;
// Prefix
$prefix = '_edumodo_';
$enable_single_related_courses = $edumodo_options['enable_single_related_courses'];
$enroll_btn_popup   = edumodo_array_get($edumodo_options, 'enroll_btn_popup') ? $edumodo_options['enroll_btn_popup'] : '';
$edumodo_lp_category   = edumodo_array_get($edumodo_options, 'edumodo_lp_category') ? $edumodo_options['edumodo_lp_category'] : '';
$edumodo_lp_excerpt_length   = edumodo_array_get($edumodo_options, 'edumodo_lp_excerpt_length') ? $edumodo_options['edumodo_lp_excerpt_length'] : '';


?>

<div class="lpcourse-course-wapper">

		<div class="lpcourse-top">
			<div class="<?php if ( has_post_thumbnail() ) : echo "col-md-6"; else : echo "col-md-12"; endif;  ?>">
				<div class="course-info">
					<?php the_title( '<h1 class="entry-title" itemprop="name">', '</h1>' ); ?>
					<?php if($edumodo_lp_category) : ?>
						<div class="course-meta">
							<i class="fa fa-folder-open" aria-hidden="true"></i><?php learn_press_course_categories(); ?>
						</div>
					<?php endif; ?>
					<div class="single-excerpt">
						<?php echo wp_trim_words( get_the_excerpt(),$edumodo_lp_excerpt_length, ''); ?>
					</div>

					<div class="lpcourse-top-button">
						<div class="single-price">
							<?php learn_press_courses_loop_item_price(); ?>
						</div>
				<?php if ( ! is_user_logged_in() && $enroll_btn_popup == '1'): ?>
					<div class="edumodo-popup-login-register">
					  <a id="modal_trigger" href="#modal">
					  	<?php learn_press_course_buttons(); ?>
					  </a>

					  <div id="modal" class="lp-popupContainer" style="display:none;">
					    <header class="lp-popupHeader">
					      <span class="header_title"><?php _e( 'Login', 'edumodo' ); ?></span>
					      <span class="modal_close"><i class="glyph-icon flaticon-remove-symbol"></i></i></span>
					    </header>

					    <section class="edumodo-lp-popupBody">
					    	<!-- Social Login widget-->
							<div class="social_login_widget">
								<?php if ( is_active_sidebar( 'lp-login-register' ) ) : ?>    
								     <?php dynamic_sidebar( 'lp-login-register' ); ?>
								<?php endif; ?>
							</div>
					      <!-- Username & Password Login form -->
					      	<?php if (function_exists('learn_press_profile_login_form')) { ?>
					      <div class="lp_user_login">
					    	<?php learn_press_profile_login_form(); ?>
					          <?php _e( 'Not a member yet?', 'edumodo' ); ?> <a class="lp-register-link" href="#" id="register_form"><?php _e( 'Register now', 'edumodo' ); ?></a>
					      </div>
							<?php } ?>
					      <!-- Register Form -->
					    <?php if (function_exists('learn_press_profile_register_form')) { ?>
					      <div class="user_register">
					    	<?php learn_press_profile_register_form(); ?>
					    	  <div class="lp_action_btns">
						            <div class="one_half"><a href="#" class=" back_btn"><i class="fa fa-angle-double-left"></i> <?php _e( 'Back', 'edumodo' ); ?></a>
						            </div>
					            <div>
					      </div>
					  		<?php } ?>
					    </section>
					  </div>
					</div>	
				<?php else : ?>	
					<?php learn_press_course_buttons(); ?>
				<?php endif; ?>
					</div>
				</div> 
			</div>

			<div class="<?php if ( has_post_thumbnail() ) : echo "col-md-6";  endif;  ?> less-padding-two">
				<?php 
					if ( has_post_thumbnail() ) { ?>
				<div class="course-thumbnail"> 
					<?php the_post_thumbnail(); ?>
				</div>
				<?php } ?>
			</div>
		</div>

		<div class="lpcourse-main">
			<div class="col-md-8"> 
				<?php
				/**
				 * @since 3.0.0
				 */
				//do_action( 'learn-press/before-main-content' );

				do_action( 'learn-press/before-single-course' );

				?>
				<div id="learn-press-course" class="course-summary">
					<?php
					/**
					 * @since 3.0.0
					 *
					 * @see learn_press_single_course_summary()
					 */
					do_action( 'learn-press/single-course-summary' );
					?>
				</div>

				<?php
					/**
					 * @since 3.0.0
					 */
					//do_action( 'learn-press/after-main-content' );

					//do_action( 'learn-press/after-single-course' ); 
				?>

			</div>
			<div class="col-md-4"> 
				<?php edumodo_course_info(); ?>
				<?php if ($enable_single_related_courses): ?>			
					<?php edumodo_related_courses(); ?>
				<?php endif; ?>

			</div>
		</div>
</div>


<?php
/**
 * @deprecated
 */
do_action( 'learn_press_after_single_course_summary' );
do_action( 'learn_press_after_single_course' );
do_action( 'learn_press_after_main_content' );