<?php
$links       = array();
$links['docs'] = "#";
$links['support'] = "#";
$link_dashboard = TX_Dashboard::get_link_main_dashboard();
?>

<div class="txw-modal-importer md-modal md-effect-16" data-template="tx-form-import">
</div>
<div class="md-overlay"></div>

<script type="text/html" id="tmpl-tx-form-import">
    <div class="md-content">
        <h3 class="title"><?php esc_html_e( 'Import Demo', 'edumodo' ); ?> <span class="demo-name"></span><span class="close"></span></h3>
        <div class="main">
            <form id="form-importer">
                <div class="pre-import">
                    <h4><?php esc_html_e( 'Pre-import', 'edumodo' ); ?></h4>
                    <ul class="options">
                        <li class="package plugins obligatory" data-package="plugins">
                            <label>
                                <input type="checkbox" id="importer-plugins" checked="checked" disabled="disabled">
                            </label>
                            <div class="heading"><?php esc_html_e( 'Required Plugins', 'edumodo' ); ?></div>
                            <div class="description"><?php esc_html_e( 'This will install and active plugins required and it is obligatory.', 'edumodo' ); ?></div>
                            <span class="package-progress-bar"></span>
                        </li>
                    </ul>
                </div>

                <div class="import-content">
                    <h4><?php esc_html_e( 'Select what type of content you want to import', 'edumodo' ); ?></h4>

					<?php
					$packages = TX_Importer::get_import_packages();
					if ( count( $packages ) ) :
						?>
                        <ul class="options">
							<?php foreach ( $packages as $key => $package ) : ?>
                                <li class="package <?php echo esc_attr( $key ); ?>"
                                    data-required="<?php echo esc_attr( isset( $package['required'] ) ? $package['required'] : '' ); ?>"
                                    data-package="<?php echo esc_attr( $key ); ?>">
                                    <label>
                                        <input type="checkbox" id="importer-<?php echo esc_attr( $key ); ?>" checked="checked">
                                    </label>
                                    <div class="heading"><?php echo esc_html( $package['title'] ); ?></div>
                                    <div class="description"><?php echo esc_html( $package['description'] ); ?></div>
                                    <span class="package-progress-bar"></span>
                                </li>
							<?php endforeach; ?>
                        </ul>
					<?php endif; ?>
                </div>
            </form>
        </div>

        <div class="footer">
            <button class="button button-primary txw-button" id="start-import" data-text="<?php esc_attr_e( 'Import', 'edumodo' ); ?>"
                    data-importing="<?php esc_attr_e( 'Importing', 'edumodo' ); ?>" data-completed="<?php esc_attr_e( 'Completed', 'edumodo' ); ?>"></button>

            <div class="text-waiting"><?php esc_html_e( 'Enjoy a cup of coffee while you are waiting for importing :)', 'edumodo' ); ?></div>
        </div>

        <div class="wrapper-finish">
            <div class="full-box">
                <div class="middle notification text-center">
                    <div class="details-error">
                        <h3></h3>
                        <div class="how-to"></div>
                        <div class="try-again">
                            <button class="button button-primary txw-button" id="retry-import"><?php esc_html_e( 'Try again', 'edumodo' ); ?></button>
                        </div>

                        <div class="get-support">
                            <a target="_blank" href="<?php echo esc_url( $links['docs'] ); ?>"
                               class="button button-secondary txw-button"><?php esc_html_e( 'Documentation', 'edumodo' ); ?></a>
                            <button
                                    class="button button-primary txw-button tx-wizard-open-send-feedback" title="<?php esc_attr_e( 'Send feedback', 'edumodo' ); ?>"><?php esc_html_e( 'Send feedback', 'edumodo' ); ?></button>
							<?php echo __( 'with <code>CODE: <span class="error-code"></span></code>', 'edumodo' ); ?>
                        </div>
                    </div>
                    <div class="details-success">
                        <h3><?php esc_html_e( 'Hooray! All Done.', 'edumodo' ); ?></h3>
                        <p><?php printf( __( 'View <a href="%1$s" target="_blank">your site</a> or return to <a href="%2$s">dashboard</a>.', 'edumodo' ), home_url( '/' ), $link_dashboard ); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</script>
