<?php
$theme_data   = wp_get_theme();
$current_page = TX_Dashboard::get_current_page_key();
$sub_pages    = TX_Dashboard::get_sub_pages();
?>

<?php do_action( 'txw_before_dashboard_wrapper' ); ?>

<div class="tx-wrapper">
    <header class="txw-header">
        <div class="title">
            <h1 class="name"><?php echo esc_html( $theme_data->get('Name') . ' Theme Dashboard' ); ?></h1>
            <span class="version"><?php echo esc_html( $theme_data->get('Version') ); ?></span>
        </div>

        <nav class="nav-tab-wrapper txw-nav-tab-wrapper">
			<?php
            foreach ( $sub_pages as $key => $sub_page ) :
				$prefix = TX_Dashboard::$prefix_slug;
				$link = admin_url( 'admin.php?page=' . $prefix . $key );
				$title = $sub_page['title'];
				?>
                <a id="txw-nav-tag-<?php echo esc_attr( $key ); ?>" href="<?php echo esc_url( $link ); ?>" class="nav-tab<?php echo ( $key === $current_page ) ? ' nav-tab-active' : ''; ?>"
                   title="<?php echo esc_attr( $title ); ?>"><?php echo esc_html( $title ); ?></a>
			<?php endforeach; ?>
        </nav>
    </header>

    <div class="notifications" id="txw-notifications">
		<?php do_action( 'tx_dashboard_notifications', $current_page ); ?>
    </div>

    <div class="txw-main">
		<?php
		do_action( "tx_dashboard_before_page_$current_page" );
		?>

		<?php
		do_action( "tx_dashboard_main_page_$current_page" );
		?>

		<?php
		do_action( "tx_dashboard_after_page_$current_page" );
		?>
    </div>
</div>

<?php do_action( 'txw_after_dashboard_wrapper' ); ?>
